/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.stats;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.datatables.HitConditionBonus;
import com.l2jserver.gameserver.datatables.KarmaData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.CustomZoneManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.type.ArmorType;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncArmorSet;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncAtkAccuracy;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncAtkCritical;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncAtkEvasion;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncGatesMDefMod;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncGatesPDefMod;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncHenna;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncMAtkCritical;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncMAtkMod;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncMAtkSpeed;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncMDefMod;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncMaxCpMul;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncMaxHpMul;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncMaxMpMul;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncMoveSpeed;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncPAtkMod;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncPAtkSpeed;
import com.l2jserver.gameserver.model.skills.funcs.formulas.FuncPDefMod;
import com.l2jserver.gameserver.model.stats.BaseStats;
import com.l2jserver.gameserver.model.stats.Calculator;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.TraitType;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.model.zone.type.L2CastleZone;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.model.zone.type.L2FortZone;
import com.l2jserver.gameserver.model.zone.type.L2MotherTreeZone;
import com.l2jserver.gameserver.model.zone.type.L2ResidenceZone;
import com.l2jserver.gameserver.network.Debug;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class Formulas {
    private static final Logger _log = Logger.getLogger(Formulas.class.getName());
    private static final int HP_REGENERATE_PERIOD = 3000;
    public static final byte SHIELD_DEFENSE_FAILED = 0;
    public static final byte SHIELD_DEFENSE_SUCCEED = 1;
    public static final byte SHIELD_DEFENSE_PERFECT_BLOCK = 2;
    private static final byte MELEE_ATTACK_RANGE = 40;

    public static int getRegeneratePeriod(L2Character cha) {
        return cha.isDoor() ? 300000 : 3000;
    }

    public static Calculator[] getStdNPCCalculators() {
        Calculator[] std = new Calculator[Stats.NUM_STATS];
        std[Stats.MAX_HP.ordinal()] = new Calculator();
        std[Stats.MAX_HP.ordinal()].addFunc(FuncMaxHpMul.getInstance());
        std[Stats.MAX_MP.ordinal()] = new Calculator();
        std[Stats.MAX_MP.ordinal()].addFunc(FuncMaxMpMul.getInstance());
        std[Stats.POWER_ATTACK.ordinal()] = new Calculator();
        std[Stats.POWER_ATTACK.ordinal()].addFunc(FuncPAtkMod.getInstance());
        std[Stats.MAGIC_ATTACK.ordinal()] = new Calculator();
        std[Stats.MAGIC_ATTACK.ordinal()].addFunc(FuncMAtkMod.getInstance());
        std[Stats.POWER_DEFENCE.ordinal()] = new Calculator();
        std[Stats.POWER_DEFENCE.ordinal()].addFunc(FuncPDefMod.getInstance());
        std[Stats.MAGIC_DEFENCE.ordinal()] = new Calculator();
        std[Stats.MAGIC_DEFENCE.ordinal()].addFunc(FuncMDefMod.getInstance());
        std[Stats.CRITICAL_RATE.ordinal()] = new Calculator();
        std[Stats.CRITICAL_RATE.ordinal()].addFunc(FuncAtkCritical.getInstance());
        std[Stats.MCRITICAL_RATE.ordinal()] = new Calculator();
        std[Stats.MCRITICAL_RATE.ordinal()].addFunc(FuncMAtkCritical.getInstance());
        std[Stats.ACCURACY_COMBAT.ordinal()] = new Calculator();
        std[Stats.ACCURACY_COMBAT.ordinal()].addFunc(FuncAtkAccuracy.getInstance());
        std[Stats.EVASION_RATE.ordinal()] = new Calculator();
        std[Stats.EVASION_RATE.ordinal()].addFunc(FuncAtkEvasion.getInstance());
        std[Stats.POWER_ATTACK_SPEED.ordinal()] = new Calculator();
        std[Stats.POWER_ATTACK_SPEED.ordinal()].addFunc(FuncPAtkSpeed.getInstance());
        std[Stats.MAGIC_ATTACK_SPEED.ordinal()] = new Calculator();
        std[Stats.MAGIC_ATTACK_SPEED.ordinal()].addFunc(FuncMAtkSpeed.getInstance());
        std[Stats.MOVE_SPEED.ordinal()] = new Calculator();
        std[Stats.MOVE_SPEED.ordinal()].addFunc(FuncMoveSpeed.getInstance());
        return std;
    }

    public static Calculator[] getStdDoorCalculators() {
        Calculator[] std = new Calculator[Stats.NUM_STATS];
        std[Stats.ACCURACY_COMBAT.ordinal()] = new Calculator();
        std[Stats.ACCURACY_COMBAT.ordinal()].addFunc(FuncAtkAccuracy.getInstance());
        std[Stats.EVASION_RATE.ordinal()] = new Calculator();
        std[Stats.EVASION_RATE.ordinal()].addFunc(FuncAtkEvasion.getInstance());
        std[Stats.POWER_DEFENCE.ordinal()] = new Calculator();
        std[Stats.POWER_DEFENCE.ordinal()].addFunc(FuncGatesPDefMod.getInstance());
        std[Stats.MAGIC_DEFENCE.ordinal()] = new Calculator();
        std[Stats.MAGIC_DEFENCE.ordinal()].addFunc(FuncGatesMDefMod.getInstance());
        return std;
    }

    public static void addFuncsToNewCharacter(L2Character cha) {
        if (cha.isPlayer()) {
            cha.addStatFunc(FuncMaxHpMul.getInstance());
            cha.addStatFunc(FuncMaxCpMul.getInstance());
            cha.addStatFunc(FuncMaxMpMul.getInstance());
            cha.addStatFunc(FuncPAtkMod.getInstance());
            cha.addStatFunc(FuncMAtkMod.getInstance());
            cha.addStatFunc(FuncPDefMod.getInstance());
            cha.addStatFunc(FuncMDefMod.getInstance());
            cha.addStatFunc(FuncAtkCritical.getInstance());
            cha.addStatFunc(FuncMAtkCritical.getInstance());
            cha.addStatFunc(FuncAtkAccuracy.getInstance());
            cha.addStatFunc(FuncAtkEvasion.getInstance());
            cha.addStatFunc(FuncPAtkSpeed.getInstance());
            cha.addStatFunc(FuncMAtkSpeed.getInstance());
            cha.addStatFunc(FuncMoveSpeed.getInstance());
            cha.addStatFunc(FuncHenna.getInstance(Stats.STAT_STR));
            cha.addStatFunc(FuncHenna.getInstance(Stats.STAT_DEX));
            cha.addStatFunc(FuncHenna.getInstance(Stats.STAT_INT));
            cha.addStatFunc(FuncHenna.getInstance(Stats.STAT_MEN));
            cha.addStatFunc(FuncHenna.getInstance(Stats.STAT_CON));
            cha.addStatFunc(FuncHenna.getInstance(Stats.STAT_WIT));
            cha.addStatFunc(FuncArmorSet.getInstance(Stats.STAT_STR));
            cha.addStatFunc(FuncArmorSet.getInstance(Stats.STAT_DEX));
            cha.addStatFunc(FuncArmorSet.getInstance(Stats.STAT_INT));
            cha.addStatFunc(FuncArmorSet.getInstance(Stats.STAT_MEN));
            cha.addStatFunc(FuncArmorSet.getInstance(Stats.STAT_CON));
            cha.addStatFunc(FuncArmorSet.getInstance(Stats.STAT_WIT));
        } else if (cha.isSummon()) {
            cha.addStatFunc(FuncMaxHpMul.getInstance());
            cha.addStatFunc(FuncMaxMpMul.getInstance());
            cha.addStatFunc(FuncPAtkMod.getInstance());
            cha.addStatFunc(FuncMAtkMod.getInstance());
            cha.addStatFunc(FuncPDefMod.getInstance());
            cha.addStatFunc(FuncMDefMod.getInstance());
            cha.addStatFunc(FuncAtkCritical.getInstance());
            cha.addStatFunc(FuncMAtkCritical.getInstance());
            cha.addStatFunc(FuncAtkAccuracy.getInstance());
            cha.addStatFunc(FuncAtkEvasion.getInstance());
            cha.addStatFunc(FuncMoveSpeed.getInstance());
            cha.addStatFunc(FuncPAtkSpeed.getInstance());
            cha.addStatFunc(FuncMAtkSpeed.getInstance());
        }
    }

    public static final double calcHpRegen(L2Character cha) {
        double init = cha.isPlayer() ? cha.getActingPlayer().getTemplate().getBaseHpRegen(cha.getLevel()) : (double)cha.getTemplate().getBaseHpReg();
        double hpRegenMultiplier = cha.isRaid() ? Config.RAID_HP_REGEN_MULTIPLIER : Config.HP_REGEN_MULTIPLIER;
        double hpRegenBonus = 0.0;
        if (cha instanceof L2GrandBossInstance && ((L2GrandBossInstance)cha).getId() == 29022 && CustomZoneManager.getInstance().isZakenWeakZone(cha)) {
            hpRegenMultiplier *= 0.75;
        }
        if (Config.L2JMOD_CHAMPION_ENABLE && cha.isChampion()) {
            hpRegenMultiplier *= (double)Config.L2JMOD_CHAMPION_HP_REGEN;
        }
        if (cha.isPlayer()) {
            L2PcInstance player = cha.getActingPlayer();
            if (SevenSignsFestival.getInstance().isFestivalInProgress() && player.isFestivalParticipant()) {
                hpRegenMultiplier *= Formulas.calcFestivalRegenModifier(player);
            } else {
                double siegeModifier = Formulas.calcSiegeRegenModifier(player);
                if (siegeModifier > 0.0) {
                    hpRegenMultiplier *= siegeModifier;
                }
            }
            if (player.isInsideZone(ZoneId.CLAN_HALL) && player.getClan() != null && player.getClan().getHideoutId() > 0) {
                ClanHall clansHall;
                L2ClanHallZone zone = ZoneManager.getInstance().getZone(player, L2ClanHallZone.class);
                int posChIndex = zone == null ? -1 : zone.getResidenceId();
                int clanHallIndex = player.getClan().getHideoutId();
                if (clanHallIndex > 0 && clanHallIndex == posChIndex && (clansHall = ClanHallManager.getInstance().getClanHallById(clanHallIndex)) != null && clansHall.getFunction(3) != null) {
                    hpRegenMultiplier *= 1.0 + (double)clansHall.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.CASTLE) && player.getClan() != null && player.getClan().getCastleId() > 0) {
                Castle castle;
                L2CastleZone zone = ZoneManager.getInstance().getZone(player, L2CastleZone.class);
                int posCastleIndex = zone == null ? -1 : zone.getResidenceId();
                int castleIndex = player.getClan().getCastleId();
                if (castleIndex > 0 && castleIndex == posCastleIndex && (castle = CastleManager.getInstance().getCastleById(castleIndex)) != null && castle.getFunction(2) != null) {
                    hpRegenMultiplier *= 1.0 + (double)castle.getFunction(2).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.FORT) && player.getClan() != null && player.getClan().getFortId() > 0) {
                Fort fort;
                L2FortZone zone = ZoneManager.getInstance().getZone(player, L2FortZone.class);
                int posFortIndex = zone == null ? -1 : zone.getResidenceId();
                int fortIndex = player.getClan().getFortId();
                if (fortIndex > 0 && fortIndex == posFortIndex && (fort = FortManager.getInstance().getFortById(fortIndex)) != null && fort.getFunction(2) != null) {
                    hpRegenMultiplier *= 1.0 + (double)fort.getFunction(2).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.MOTHER_TREE)) {
                L2MotherTreeZone zone = ZoneManager.getInstance().getZone(player, L2MotherTreeZone.class);
                int hpBonus = zone == null ? 0 : zone.getHpRegenBonus();
                hpRegenBonus += (double)hpBonus;
            }
            if (player.isSitting()) {
                hpRegenMultiplier *= 1.5;
            } else if (!player.isMoving()) {
                hpRegenMultiplier *= 1.1;
            } else if (player.isRunning()) {
                hpRegenMultiplier *= 0.7;
            }
            init *= cha.getLevelMod() * BaseStats.CON.calcBonus(cha);
        } else if (cha.isPet()) {
            init = (double)((L2PetInstance)cha).getPetLevelData().getPetRegenHP() * Config.PET_HP_REGEN_MULTIPLIER;
        }
        return cha.calcStat(Stats.REGENERATE_HP_RATE, Math.max(1.0, init), null, null) * hpRegenMultiplier + hpRegenBonus;
    }

    public static final double calcMpRegen(L2Character cha) {
        double init = cha.isPlayer() ? cha.getActingPlayer().getTemplate().getBaseMpRegen(cha.getLevel()) : (double)cha.getTemplate().getBaseMpReg();
        double mpRegenMultiplier = cha.isRaid() ? Config.RAID_MP_REGEN_MULTIPLIER : Config.MP_REGEN_MULTIPLIER;
        double mpRegenBonus = 0.0;
        if (cha.isPlayer()) {
            L2ZoneType zone;
            L2PcInstance player = cha.getActingPlayer();
            if (SevenSignsFestival.getInstance().isFestivalInProgress() && player.isFestivalParticipant()) {
                mpRegenMultiplier *= Formulas.calcFestivalRegenModifier(player);
            }
            if (player.isInsideZone(ZoneId.MOTHER_TREE)) {
                zone = ZoneManager.getInstance().getZone(player, L2MotherTreeZone.class);
                int mpBonus = zone == null ? 0 : ((L2MotherTreeZone)zone).getMpRegenBonus();
                mpRegenBonus += (double)mpBonus;
            }
            if (player.isInsideZone(ZoneId.CLAN_HALL) && player.getClan() != null && player.getClan().getHideoutId() > 0) {
                ClanHall clansHall;
                zone = ZoneManager.getInstance().getZone(player, L2ClanHallZone.class);
                int posChIndex = zone == null ? -1 : ((L2ResidenceZone)zone).getResidenceId();
                int clanHallIndex = player.getClan().getHideoutId();
                if (clanHallIndex > 0 && clanHallIndex == posChIndex && (clansHall = ClanHallManager.getInstance().getClanHallById(clanHallIndex)) != null && clansHall.getFunction(4) != null) {
                    mpRegenMultiplier *= 1.0 + (double)clansHall.getFunction(4).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.CASTLE) && player.getClan() != null && player.getClan().getCastleId() > 0) {
                Castle castle;
                zone = ZoneManager.getInstance().getZone(player, L2CastleZone.class);
                int posCastleIndex = zone == null ? -1 : ((L2ResidenceZone)zone).getResidenceId();
                int castleIndex = player.getClan().getCastleId();
                if (castleIndex > 0 && castleIndex == posCastleIndex && (castle = CastleManager.getInstance().getCastleById(castleIndex)) != null && castle.getFunction(3) != null) {
                    mpRegenMultiplier *= 1.0 + (double)castle.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.FORT) && player.getClan() != null && player.getClan().getFortId() > 0) {
                Fort fort;
                zone = ZoneManager.getInstance().getZone(player, L2FortZone.class);
                int posFortIndex = zone == null ? -1 : ((L2ResidenceZone)zone).getResidenceId();
                int fortIndex = player.getClan().getFortId();
                if (fortIndex > 0 && fortIndex == posFortIndex && (fort = FortManager.getInstance().getFortById(fortIndex)) != null && fort.getFunction(3) != null) {
                    mpRegenMultiplier *= 1.0 + (double)fort.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isSitting()) {
                mpRegenMultiplier *= 1.5;
            } else if (!player.isMoving()) {
                mpRegenMultiplier *= 1.1;
            } else if (player.isRunning()) {
                mpRegenMultiplier *= 0.7;
            }
            init *= cha.getLevelMod() * BaseStats.MEN.calcBonus(cha);
        } else if (cha.isPet()) {
            init = (double)((L2PetInstance)cha).getPetLevelData().getPetRegenMP() * Config.PET_MP_REGEN_MULTIPLIER;
        }
        return cha.calcStat(Stats.REGENERATE_MP_RATE, Math.max(1.0, init), null, null) * mpRegenMultiplier + mpRegenBonus;
    }

    public static final double calcCpRegen(L2Character cha) {
        double init = cha.isPlayer() ? cha.getActingPlayer().getTemplate().getBaseCpRegen(cha.getLevel()) : (double)cha.getTemplate().getBaseHpReg();
        double cpRegenMultiplier = Config.CP_REGEN_MULTIPLIER;
        double cpRegenBonus = 0.0;
        if (cha.isPlayer()) {
            L2PcInstance player = cha.getActingPlayer();
            if (player.isSitting()) {
                cpRegenMultiplier *= 1.5;
            } else if (!player.isMoving()) {
                cpRegenMultiplier *= 1.1;
            } else if (player.isRunning()) {
                cpRegenMultiplier *= 0.7;
            }
        } else if (!cha.isMoving()) {
            cpRegenMultiplier *= 1.1;
        } else if (cha.isRunning()) {
            cpRegenMultiplier *= 0.7;
        }
        return cha.calcStat(Stats.REGENERATE_CP_RATE, Math.max(1.0, init *= cha.getLevelMod() * BaseStats.CON.calcBonus(cha)), null, null) * cpRegenMultiplier + cpRegenBonus;
    }

    public static final double calcFestivalRegenModifier(L2PcInstance activeChar) {
        int[] festivalInfo = SevenSignsFestival.getInstance().getFestivalForPlayer(activeChar);
        int oracle = festivalInfo[0];
        int festivalId = festivalInfo[1];
        if (festivalId < 0) {
            return 0.0;
        }
        int[] festivalCenter = oracle == 2 ? SevenSignsFestival.FESTIVAL_DAWN_PLAYER_SPAWNS[festivalId] : SevenSignsFestival.FESTIVAL_DUSK_PLAYER_SPAWNS[festivalId];
        double distToCenter = activeChar.calculateDistance(festivalCenter[0], festivalCenter[1], 0, false, false);
        if (Config.DEBUG) {
            _log.info("Distance: " + distToCenter + ", RegenMulti: " + distToCenter * 2.5 / 50.0);
        }
        return 1.0 - distToCenter * 5.0E-4;
    }

    public static final double calcSiegeRegenModifier(L2PcInstance activeChar) {
        if (activeChar == null || activeChar.getClan() == null) {
            return 0.0;
        }
        Siege siege = SiegeManager.getInstance().getSiege(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        if (siege == null || !siege.isInProgress()) {
            return 0.0;
        }
        L2SiegeClan siegeClan = siege.getAttackerClan(activeChar.getClan().getId());
        if (siegeClan == null || siegeClan.getFlag().isEmpty() || !Util.checkIfInRange(200, activeChar, siegeClan.getFlag().get(0), true)) {
            return 0.0;
        }
        return 1.5;
    }

    public static double calcBlowDamage(L2Character attacker, L2Character target, Skill skill, byte shld, boolean ss) {
        double defence = target.getPDef(attacker);
        switch (shld) {
            case 1: {
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        boolean isPvP = attacker.isPlayable() && target.isPlayable();
        boolean isPvE = attacker.isPlayable() && target.isAttackable();
        double power = skill.getPower(isPvP, isPvE);
        double damage = 0.0;
        double proximityBonus = attacker.isBehindTarget() ? 1.2 : (attacker.isInFrontOfTarget() ? 1.0 : 1.1);
        double ssboost = ss ? 2.0 : 1.0;
        double pvpBonus = 1.0;
        if (isPvP) {
            pvpBonus = attacker.calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0, null, null);
            defence *= target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null);
        }
        double baseMod = 77.0 * (power + (double)attacker.getPAtk(target) * ssboost) / defence;
        double criticalMod = attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, skill);
        double criticalVulnMod = target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE, 1.0, target, skill);
        double criticalAddMod = attacker.getStat().calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0) * 6.1 * 77.0 / defence;
        double criticalAddVuln = target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE_ADD, 0.0, target, skill);
        double weaponTraitMod = Formulas.calcWeaponTraitBonus(attacker, target);
        double generalTraitMod = Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
        double attributeMod = Formulas.calcAttributeBonus(attacker, target, skill);
        double weaponMod = attacker.getRandomDamageMultiplier();
        double penaltyMod = 1.0;
        if (target instanceof L2Attackable && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            penaltyMod = lvlDiff >= Config.NPC_SKILL_DMG_PENALTY.size() ? (penaltyMod *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size() - 1).floatValue()) : (penaltyMod *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff).floatValue());
        }
        damage = baseMod * criticalMod * criticalVulnMod * proximityBonus * pvpBonus + criticalAddMod + criticalAddVuln;
        damage *= weaponTraitMod;
        damage *= generalTraitMod;
        damage *= attributeMod;
        damage *= weaponMod;
        damage *= penaltyMod;
        if (attacker.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("skillPower", skill.getPower(isPvP, isPvE));
            set.set("ssboost", ssboost);
            set.set("proximityBonus", proximityBonus);
            set.set("pvpBonus", pvpBonus);
            set.set("baseMod", baseMod);
            set.set("criticalMod", criticalMod);
            set.set("criticalVulnMod", criticalVulnMod);
            set.set("criticalAddMod", criticalAddMod);
            set.set("criticalAddVuln", criticalAddVuln);
            set.set("weaponTraitMod", weaponTraitMod);
            set.set("generalTraitMod", generalTraitMod);
            set.set("attributeMod", attributeMod);
            set.set("weaponMod", weaponMod);
            set.set("penaltyMod", penaltyMod);
            set.set("damage", (int)damage);
            Debug.sendSkillDebug(attacker, target, skill, set);
        }
        return Math.max(damage, 1.0);
    }

    public static double calcBackstabDamage(L2Character attacker, L2Character target, Skill skill, byte shld, boolean ss) {
        double defence = target.getPDef(attacker);
        switch (shld) {
            case 1: {
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        boolean isPvP = attacker.isPlayable() && target.isPlayer();
        boolean isPvE = attacker.isPlayable() && target.isAttackable();
        double damage = 0.0;
        double proximityBonus = attacker.isBehindTarget() ? 1.2 : (attacker.isInFrontOfTarget() ? 1.0 : 1.1);
        double ssboost = ss ? 2.0 : 1.0;
        double pvpBonus = 1.0;
        if (isPvP) {
            pvpBonus = attacker.calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0, null, null);
            defence *= target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null);
        }
        double baseMod = 77.0 * (skill.getPower(isPvP, isPvE) + (double)attacker.getPAtk(target)) / defence * ssboost;
        double criticalMod = attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, skill);
        double criticalVulnMod = target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE, 1.0, target, skill);
        double criticalAddMod = attacker.calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0, target, skill) * 6.1 * 77.0 / defence;
        double criticalAddVuln = target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE_ADD, 0.0, target, skill);
        double generalTraitMod = Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
        double attributeMod = Formulas.calcAttributeBonus(attacker, target, skill);
        double weaponMod = attacker.getRandomDamageMultiplier();
        double penaltyMod = 1.0;
        if (target.isAttackable() && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            penaltyMod = lvlDiff >= Config.NPC_SKILL_DMG_PENALTY.size() ? (penaltyMod *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size() - 1).floatValue()) : (penaltyMod *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff).floatValue());
        }
        damage = baseMod * criticalMod * criticalVulnMod * proximityBonus * pvpBonus + criticalAddMod + criticalAddVuln;
        damage *= generalTraitMod;
        damage *= attributeMod;
        damage *= weaponMod;
        damage *= penaltyMod;
        if (attacker.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("skillPower", skill.getPower(isPvP, isPvE));
            set.set("ssboost", ssboost);
            set.set("proximityBonus", proximityBonus);
            set.set("pvpBonus", pvpBonus);
            set.set("baseMod", baseMod);
            set.set("criticalMod", criticalMod);
            set.set("criticalVulnMod", criticalVulnMod);
            set.set("criticalAddMod", criticalAddMod);
            set.set("criticalAddVuln", criticalAddVuln);
            set.set("generalTraitMod", generalTraitMod);
            set.set("attributeMod", attributeMod);
            set.set("weaponMod", weaponMod);
            set.set("penaltyMod", penaltyMod);
            set.set("damage", (int)damage);
            Debug.sendSkillDebug(attacker, target, skill, set);
        }
        return Math.max(damage, 1.0);
    }

    public static final double calcPhysDam(L2Character attacker, L2Character target, Skill skill, byte shld, boolean crit, boolean ss) {
        boolean isPvP = attacker.isPlayable() && target.isPlayable();
        boolean isPvE = attacker.isPlayable() && target.isAttackable();
        double damage = attacker.getPAtk(target);
        double defence = target.getPDef(attacker);
        if (isPvP) {
            defence *= skill == null ? target.calcStat(Stats.PVP_PHYSICAL_DEF, 1.0, null, null) : target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null);
        }
        switch (shld) {
            case 1: {
                if (Config.ALT_GAME_SHIELD_BLOCKS) break;
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        int ssBoost = ss ? 2 : 1;
        double d = damage = skill != null ? damage * (double)ssBoost + skill.getPower(attacker, target, isPvP, isPvE) : damage * (double)ssBoost;
        if (crit) {
            damage = 2.0 * attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, skill) * target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE, 1.0, target, null) * (70.0 * damage / defence);
            damage += attacker.calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0, target, skill) * 70.0 / defence;
            damage += target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE_ADD, 0.0, target, skill);
        } else {
            damage = 70.0 * damage / defence;
        }
        damage *= Formulas.calcAttackTraitBonus(attacker, target);
        damage *= attacker.getRandomDamageMultiplier();
        if (shld > 0 && Config.ALT_GAME_SHIELD_BLOCKS && (damage -= (double)target.getShldDef()) < 0.0) {
            damage = 0.0;
        }
        if (damage > 0.0 && damage < 1.0) {
            damage = 1.0;
        } else if (damage < 0.0) {
            damage = 0.0;
        }
        if (isPvP) {
            damage = skill == null ? (damage *= attacker.calcStat(Stats.PVP_PHYSICAL_DMG, 1.0, null, null)) : (damage *= attacker.calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0, null, null));
        }
        if (skill != null) {
            damage = attacker.calcStat(Stats.PHYSICAL_SKILL_POWER, damage, null, null);
        }
        damage *= Formulas.calcAttributeBonus(attacker, target, skill);
        if (target.isAttackable()) {
            L2Weapon weapon = attacker.getActiveWeaponItem();
            damage = weapon != null && (weapon.getItemType() == WeaponType.BOW || weapon.getItemType() == WeaponType.CROSSBOW) ? (skill != null ? (damage *= attacker.calcStat(Stats.PVE_BOW_SKILL_DMG, 1.0, null, null)) : (damage *= attacker.calcStat(Stats.PVE_BOW_DMG, 1.0, null, null))) : (damage *= attacker.calcStat(Stats.PVE_PHYSICAL_DMG, 1.0, null, null));
            if (!target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
                int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
                damage = skill != null ? (lvlDiff >= Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size() - 1).floatValue()) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff).floatValue())) : (crit ? (lvlDiff >= Config.NPC_CRIT_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_CRIT_DMG_PENALTY.get(Config.NPC_CRIT_DMG_PENALTY.size() - 1).floatValue()) : (damage *= (double)Config.NPC_CRIT_DMG_PENALTY.get(lvlDiff).floatValue())) : (lvlDiff >= Config.NPC_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_DMG_PENALTY.get(Config.NPC_DMG_PENALTY.size() - 1).floatValue()) : (damage *= (double)Config.NPC_DMG_PENALTY.get(lvlDiff).floatValue())));
            }
        }
        return damage;
    }

    public static final double calcMagicDam(L2Character attacker, L2Character target, Skill skill, byte shld, boolean sps, boolean bss, boolean mcrit) {
        boolean isPvE;
        int mDef = target.getMDef(attacker, skill);
        switch (shld) {
            case 1: {
                mDef += target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        int mAtk = attacker.getMAtk(target, skill);
        boolean isPvP = attacker.isPlayable() && target.isPlayable();
        boolean bl = isPvE = attacker.isPlayable() && target.isAttackable();
        if (isPvP) {
            mDef = skill.isMagic() ? (int)((double)mDef * target.calcStat(Stats.PVP_MAGICAL_DEF, 1.0, null, null)) : (int)((double)mDef * target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null));
        }
        double damage = 91.0 * Math.sqrt(mAtk *= bss ? 4 : (sps ? 2 : 1)) / (double)mDef * skill.getPower(attacker, target, isPvP, isPvE);
        if (Config.ALT_GAME_MAGICFAILURES && !Formulas.calcMagicSuccess(attacker, target, skill)) {
            SystemMessage sm;
            if (attacker.isPlayer()) {
                if (Formulas.calcMagicSuccess(attacker, target, skill) && target.getLevel() - attacker.getLevel() <= 9) {
                    if (skill.hasEffectType(L2EffectType.HP_DRAIN)) {
                        attacker.sendPacket(SystemMessageId.DRAIN_HALF_SUCCESFUL);
                    } else {
                        attacker.sendPacket(SystemMessageId.ATTACK_FAILED);
                    }
                    damage /= 2.0;
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                    sm.addCharName(target);
                    sm.addSkillName(skill);
                    attacker.sendPacket(sm);
                    damage = 1.0;
                }
            }
            if (target.isPlayer()) {
                sm = skill.hasEffectType(L2EffectType.HP_DRAIN) ? SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_DRAIN) : SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_MAGIC);
                sm.addCharName(attacker);
                target.sendPacket(sm);
            }
        } else if (mcrit) {
            damage *= attacker.isPlayer() && target.isPlayer() ? 2.5 : 3.0;
            damage *= attacker.calcStat(Stats.MAGIC_CRIT_DMG, 1.0, null, null);
        }
        damage *= attacker.getRandomDamageMultiplier();
        if (isPvP) {
            Stats stat = skill.isMagic() ? Stats.PVP_MAGICAL_DMG : Stats.PVP_PHYS_SKILL_DMG;
            damage *= attacker.calcStat(stat, 1.0, null, null);
        }
        damage *= Formulas.calcAttributeBonus(attacker, target, skill);
        if (target.isAttackable()) {
            damage *= attacker.calcStat(Stats.PVE_MAGICAL_DMG, 1.0, null, null);
            if (!target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
                int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
                damage = lvlDiff >= Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size() - 1).floatValue()) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff).floatValue());
            }
        }
        return damage;
    }

    public static final double calcMagicDam(L2CubicInstance attacker, L2Character target, Skill skill, boolean mcrit, byte shld) {
        int mDef = target.getMDef(attacker.getOwner(), skill);
        switch (shld) {
            case 1: {
                mDef += target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        int mAtk = attacker.getCubicPower();
        boolean isPvP = target.isPlayable();
        boolean isPvE = target.isAttackable();
        double damage = 91.0 * (((double)mAtk + skill.getPower(isPvP, isPvE)) / (double)mDef);
        L2PcInstance owner = attacker.getOwner();
        if (Config.ALT_GAME_MAGICFAILURES && !Formulas.calcMagicSuccess(owner, target, skill)) {
            SystemMessage sm;
            if (Formulas.calcMagicSuccess(owner, target, skill) && target.getLevel() - skill.getMagicLevel() <= 9) {
                if (skill.hasEffectType(L2EffectType.HP_DRAIN)) {
                    owner.sendPacket(SystemMessageId.DRAIN_HALF_SUCCESFUL);
                } else {
                    owner.sendPacket(SystemMessageId.ATTACK_FAILED);
                }
                damage /= 2.0;
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                sm.addCharName(target);
                sm.addSkillName(skill);
                owner.sendPacket(sm);
                damage = 1.0;
            }
            if (target.isPlayer()) {
                if (skill.hasEffectType(L2EffectType.HP_DRAIN)) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_DRAIN);
                    sm.addCharName(owner);
                    target.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_MAGIC);
                    sm.addCharName(owner);
                    target.sendPacket(sm);
                }
            }
        } else if (mcrit) {
            damage *= 3.0;
        }
        damage *= Formulas.calcAttributeBonus(owner, target, skill);
        if (target.isAttackable()) {
            damage *= attacker.getOwner().calcStat(Stats.PVE_MAGICAL_DMG, 1.0, null, null);
            if (!target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getOwner() != null && target.getLevel() - attacker.getOwner().getLevel() >= 2) {
                int lvlDiff = target.getLevel() - attacker.getOwner().getLevel() - 1;
                damage = lvlDiff >= Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size() - 1).floatValue()) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff).floatValue());
            }
        }
        return damage;
    }

    public static final boolean calcCrit(double rate, boolean skill, L2Character target) {
        double finalRate = target.getStat().calcStat(Stats.DEFENCE_CRITICAL_RATE, rate, null, null) + target.getStat().calcStat(Stats.DEFENCE_CRITICAL_RATE_ADD, 0.0, null, null);
        return finalRate > (double)Rnd.get(1000);
    }

    public static final boolean calcMCrit(double mRate) {
        return mRate > (double)Rnd.get(1000);
    }

    public static final boolean calcAtkBreak(L2Character target, double dmg) {
        L2Weapon wpn;
        if (target.isChanneling()) {
            return false;
        }
        double init = 0.0;
        if (Config.ALT_GAME_CANCEL_CAST && target.isCastingNow()) {
            init = 15.0;
        }
        if (Config.ALT_GAME_CANCEL_BOW && target.isAttackingNow() && (wpn = target.getActiveWeaponItem()) != null && wpn.getItemType() == WeaponType.BOW) {
            init = 15.0;
        }
        if (target.isRaid() || target.isInvul() || init <= 0.0) {
            return false;
        }
        init += Math.sqrt(13.0 * dmg);
        double rate = target.calcStat(Stats.ATTACK_CANCEL, init -= BaseStats.MEN.calcBonus(target) * 100.0 - 100.0, null, null);
        rate = Math.max(Math.min(rate, 99.0), 1.0);
        return (double)Rnd.get(100) < rate;
    }

    public static final int calcPAtkSpd(L2Character attacker, L2Character target, double rate) {
        if (rate < 2.0) {
            return 2700;
        }
        return (int)(470000.0 / rate);
    }

    public static final int calcAtkSpd(L2Character attacker, Skill skill, double skillTime) {
        if (skill.isMagic()) {
            return (int)(skillTime / (double)attacker.getMAtkSpd() * 333.0);
        }
        return (int)(skillTime / (double)attacker.getPAtkSpd() * 300.0);
    }

    public static boolean calcHitMiss(L2Character attacker, L2Character target) {
        int chance = (80 + 2 * (attacker.getAccuracy() - target.getEvasionRate(attacker))) * 10;
        chance = (int)((double)chance * HitConditionBonus.getInstance().getConditionBonus(attacker, target));
        chance = Math.max(chance, 200);
        return (chance = Math.min(chance, 980)) < Rnd.get(1000);
    }

    public static byte calcShldUse(L2Character attacker, L2Character target, Skill skill, boolean sendSysMsg) {
        if (skill != null && skill.ignoreShield()) {
            return 0;
        }
        L2Item item = target.getSecondaryWeaponItem();
        if (item == null || !(item instanceof L2Armor) || ((L2Armor)item).getItemType() == ArmorType.SIGIL) {
            return 0;
        }
        double shldRate = target.calcStat(Stats.SHIELD_RATE, 0.0, attacker, null) * BaseStats.DEX.calcBonus(target);
        if (shldRate <= 1.0E-6) {
            return 0;
        }
        int degreeside = (int)target.calcStat(Stats.SHIELD_DEFENCE_ANGLE, 0.0, null, null) + 120;
        if (degreeside < 360 && !target.isFacing(attacker, degreeside)) {
            return 0;
        }
        byte shldSuccess = 0;
        L2Weapon at_weapon = attacker.getActiveWeaponItem();
        if (at_weapon != null && at_weapon.getItemType() == WeaponType.BOW) {
            shldRate *= 1.3;
        }
        if (shldRate > 0.0 && 100 - Config.ALT_PERFECT_SHLD_BLOCK < Rnd.get(100)) {
            shldSuccess = 2;
        } else if (shldRate > (double)Rnd.get(100)) {
            shldSuccess = 1;
        }
        if (sendSysMsg && target.isPlayer()) {
            L2PcInstance enemy = target.getActingPlayer();
            switch (shldSuccess) {
                case 1: {
                    enemy.sendPacket(SystemMessageId.SHIELD_DEFENCE_SUCCESSFULL);
                    break;
                }
                case 2: {
                    enemy.sendPacket(SystemMessageId.YOUR_EXCELLENT_SHIELD_DEFENSE_WAS_A_SUCCESS);
                }
            }
        }
        return shldSuccess;
    }

    public static byte calcShldUse(L2Character attacker, L2Character target, Skill skill) {
        return Formulas.calcShldUse(attacker, target, skill, true);
    }

    public static byte calcShldUse(L2Character attacker, L2Character target) {
        return Formulas.calcShldUse(attacker, target, null, true);
    }

    public static boolean calcMagicAffected(L2Character actor, L2Character target, Skill skill) {
        double defence = 0.0;
        if (skill.isActive() && skill.isBad()) {
            defence = target.getMDef(actor, skill);
        }
        double attack = (double)(2 * actor.getMAtk(target, skill)) * Formulas.calcGeneralTraitBonus(actor, target, skill.getTraitType(), false);
        double d = (attack - defence) / (attack + defence);
        if (skill.isDebuff() && target.calcStat(Stats.DEBUFF_IMMUNITY, 0.0, null, skill) > 0.0) {
            return false;
        }
        return (d += 0.5 * Rnd.nextGaussian()) > 0.0;
    }

    public static double calcLvlBonusMod(L2Character attacker, L2Character target, Skill skill) {
        int attackerLvl = skill.getMagicLevel() > 0 ? skill.getMagicLevel() : attacker.getLevel();
        double skillLvlBonusRateMod = 1.0 + (double)skill.getLvlBonusRate() / 100.0;
        double lvlMod = 1.0 + (double)(attackerLvl - target.getLevel()) / 100.0;
        return skillLvlBonusRateMod * lvlMod;
    }

    public static boolean calcEffectSuccess(Env env) {
        double finalRate;
        L2Character target = env.getTarget();
        if (target.isDoor() || target instanceof L2SiegeFlagInstance || target instanceof L2StaticObjectInstance) {
            return false;
        }
        L2Character attacker = env.getCharacter();
        Skill skill = env.getSkill();
        if (skill.isDebuff() && target.calcStat(Stats.DEBUFF_IMMUNITY, 0.0, attacker, skill) > 0.0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
            sm.addCharName(target);
            sm.addSkillName(skill);
            attacker.sendPacket(sm);
            return false;
        }
        int activateRate = skill.getActivateRate();
        if (activateRate == -1 || skill.getBasicProperty() == BaseStats.NONE) {
            return true;
        }
        int magicLevel = skill.getMagicLevel();
        if (magicLevel <= -1) {
            magicLevel = target.getLevel() + 3;
        }
        int targetBaseStat = 0;
        switch (skill.getBasicProperty()) {
            case STR: {
                targetBaseStat = target.getSTR();
                break;
            }
            case DEX: {
                targetBaseStat = target.getDEX();
                break;
            }
            case CON: {
                targetBaseStat = target.getCON();
                break;
            }
            case INT: {
                targetBaseStat = target.getINT();
                break;
            }
            case MEN: {
                targetBaseStat = target.getMEN();
                break;
            }
            case WIT: {
                targetBaseStat = target.getWIT();
            }
        }
        double baseMod = (double)((magicLevel - target.getLevel() + 3) * skill.getLvlBonusRate() + activateRate) + 30.0 - (double)targetBaseStat;
        double elementMod = Formulas.calcAttributeBonus(attacker, target, skill);
        double traitMod = Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
        double buffDebuffMod = 1.0 + target.calcStat(skill.isDebuff() ? Stats.DEBUFF_VULN : Stats.BUFF_VULN, 1.0, null, null) / 100.0;
        double mAtkMod = 1.0;
        if (skill.isMagic()) {
            double mAtk = attacker.getMAtk(null, null);
            double val = 0.0;
            if (env.isBlessedSpiritShot()) {
                val = mAtk * 3.0;
            }
            val += mAtk;
            mAtkMod = val = Math.sqrt(val) / (double)target.getMDef(null, null) * 11.0;
        }
        double rate = baseMod * elementMod * traitMod * mAtkMod * buffDebuffMod;
        double d = finalRate = traitMod > 0.0 ? Util.constrain(rate, (double)skill.getMinChance(), (double)skill.getMaxChance()) : 0.0;
        if (attacker.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("baseMod", baseMod);
            set.set("elementMod", elementMod);
            set.set("traitMod", traitMod);
            set.set("mAtkMod", mAtkMod);
            set.set("buffDebuffMod", buffDebuffMod);
            set.set("rate", rate);
            set.set("finalRate", finalRate);
            Debug.sendSkillDebug(attacker, target, skill, set);
        }
        if (finalRate <= (double)Rnd.get(100)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
            sm.addCharName(target);
            sm.addSkillName(skill);
            attacker.sendPacket(sm);
            return false;
        }
        return true;
    }

    public static boolean calcCubicSkillSuccess(L2CubicInstance attacker, L2Character target, Skill skill, byte shld) {
        if (skill.isDebuff()) {
            if (skill.getPower() == -1.0) {
                return true;
            }
            if (target.calcStat(Stats.DEBUFF_IMMUNITY, 0.0, null, skill) > 0.0) {
                return false;
            }
        }
        if (shld == 2) {
            return false;
        }
        if (Formulas.calcBuffDebuffReflection(target, skill)) {
            return false;
        }
        double baseRate = skill.getPower();
        double statMod = skill.getBasicProperty().calcBonus(target);
        double rate = baseRate / statMod;
        double resMod = Formulas.calcGeneralTraitBonus(attacker.getOwner(), target, skill.getTraitType(), false);
        rate *= resMod;
        double lvlBonusMod = Formulas.calcLvlBonusMod(attacker.getOwner(), target, skill);
        rate *= lvlBonusMod;
        double elementMod = Formulas.calcAttributeBonus(attacker.getOwner(), target, skill);
        double finalRate = Util.constrain(rate *= elementMod, (double)skill.getMinChance(), (double)skill.getMaxChance());
        if (attacker.getOwner().isDebug()) {
            StatsSet set = new StatsSet();
            set.set("baseMod", baseRate);
            set.set("resMod", resMod);
            set.set("statMod", statMod);
            set.set("elementMod", elementMod);
            set.set("lvlBonusMod", lvlBonusMod);
            set.set("rate", rate);
            set.set("finalRate", finalRate);
            Debug.sendSkillDebug(attacker.getOwner(), target, skill, set);
        }
        return (double)Rnd.get(100) < finalRate;
    }

    public static boolean calcMagicSuccess(L2Character attacker, L2Character target, Skill skill) {
        if (skill.getPower() == -1.0) {
            return true;
        }
        int lvlDifference = target.getLevel() - (skill.getMagicLevel() > 0 ? skill.getMagicLevel() : attacker.getLevel());
        double lvlModifier = Math.pow(1.3, lvlDifference);
        float targetModifier = 1.0f;
        if (target.isAttackable() && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_MAGIC_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 3) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 2;
            targetModifier = lvlDiff >= Config.NPC_SKILL_CHANCE_PENALTY.size() ? Config.NPC_SKILL_CHANCE_PENALTY.get(Config.NPC_SKILL_CHANCE_PENALTY.size() - 1).floatValue() : Config.NPC_SKILL_CHANCE_PENALTY.get(lvlDiff).floatValue();
        }
        double resModifier = target.calcStat(Stats.MAGIC_SUCCESS_RES, 1.0, null, skill);
        int rate = 100 - Math.round((float)(lvlModifier * (double)targetModifier * resModifier));
        if (attacker.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("lvlDifference", lvlDifference);
            set.set("lvlModifier", lvlModifier);
            set.set("resModifier", resModifier);
            set.set("targetModifier", targetModifier);
            set.set("rate", rate);
            Debug.sendSkillDebug(attacker, target, skill, set);
        }
        return Rnd.get(100) < rate;
    }

    public static double calcManaDam(L2Character attacker, L2Character target, Skill skill, byte shld, boolean sps, boolean bss, boolean mcrit) {
        double mAtk = attacker.getMAtk(target, skill);
        double mDef = target.getMDef(attacker, skill);
        boolean isPvP = attacker.isPlayable() && target.isPlayable();
        boolean isPvE = attacker.isPlayable() && target.isAttackable();
        double mp = target.getMaxMp();
        switch (shld) {
            case 1: {
                mDef += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        double damage = Math.sqrt(mAtk *= bss ? 4.0 : (sps ? 2.0 : 1.0)) * skill.getPower(attacker, target, isPvP, isPvE) * (mp / 97.0) / mDef;
        damage *= Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
        if (target.isAttackable()) {
            damage *= attacker.calcStat(Stats.PVE_MAGICAL_DMG, 1.0, null, null);
            if (!target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
                int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
                damage = lvlDiff >= Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size() - 1).floatValue()) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff).floatValue());
            }
        }
        if (Config.ALT_GAME_MAGICFAILURES && !Formulas.calcMagicSuccess(attacker, target, skill)) {
            if (attacker.isPlayer()) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                sm.addCharName(target);
                sm.addSkillName(skill);
                attacker.sendPacket(sm);
                damage /= 2.0;
            }
            if (target.isPlayer()) {
                SystemMessage sm2 = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_MAGIC);
                sm2.addCharName(attacker);
                target.sendPacket(sm2);
            }
        }
        if (mcrit) {
            damage *= 3.0;
            attacker.sendPacket(SystemMessageId.CRITICAL_HIT_MAGIC);
        }
        return damage;
    }

    public static double calculateSkillResurrectRestorePercent(double baseRestorePercent, L2Character caster) {
        if (baseRestorePercent == 0.0 || baseRestorePercent == 100.0) {
            return baseRestorePercent;
        }
        double restorePercent = baseRestorePercent * BaseStats.WIT.calcBonus(caster);
        if (restorePercent - baseRestorePercent > 20.0) {
            restorePercent += 20.0;
        }
        restorePercent = Math.max(restorePercent, baseRestorePercent);
        restorePercent = Math.min(restorePercent, 90.0);
        return restorePercent;
    }

    public static boolean calcPhysicalSkillEvasion(L2Character activeChar, L2Character target, Skill skill) {
        if (skill.isMagic() || skill.isDebuff()) {
            return false;
        }
        if ((double)Rnd.get(100) < target.calcStat(Stats.P_SKILL_EVASION, 0.0, null, skill)) {
            SystemMessage sm;
            if (activeChar.isPlayer()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DODGES_ATTACK);
                sm.addString(target.getName());
                activeChar.getActingPlayer().sendPacket(sm);
            }
            if (target.isPlayer()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.AVOIDED_C1_ATTACK2);
                sm.addString(activeChar.getName());
                target.getActingPlayer().sendPacket(sm);
            }
            return true;
        }
        return false;
    }

    public static boolean calcSkillMastery(L2Character actor, Skill sk) {
        if (sk.isStatic()) {
            return false;
        }
        double val = actor.getStat().calcStat(Stats.SKILL_MASTERY, 1.0, null, null);
        if (actor.isPlayer()) {
            val *= (actor.getActingPlayer().isMageClass() ? BaseStats.INT : BaseStats.STR).calcBonus(actor);
        }
        return (double)Rnd.get(100) < val;
    }

    public static double calcAttributeBonus(L2Character attacker, L2Character target, Skill skill) {
        double min;
        double max;
        int defence_attribute;
        int attack_attribute;
        if (skill != null) {
            if (skill.getElement() == -1) {
                attack_attribute = 0;
                defence_attribute = target.getDefenseElementValue((byte)-1);
            } else if (attacker.getAttackElement() == skill.getElement()) {
                attack_attribute = attacker.getAttackElementValue(attacker.getAttackElement()) + skill.getElementPower();
                defence_attribute = target.getDefenseElementValue(attacker.getAttackElement());
            } else {
                attack_attribute = skill.getElementPower();
                defence_attribute = target.getDefenseElementValue(skill.getElement());
            }
        } else {
            attack_attribute = attacker.getAttackElementValue(attacker.getAttackElement());
            defence_attribute = target.getDefenseElementValue(attacker.getAttackElement());
        }
        double attack_attribute_mod = 0.0;
        double defence_attribute_mod = 0.0;
        if (attack_attribute >= 450) {
            if (defence_attribute >= 450) {
                attack_attribute_mod = 0.06909;
                defence_attribute_mod = 0.078;
            } else if (attack_attribute >= 350) {
                attack_attribute_mod = 0.0887;
                defence_attribute_mod = 0.1007;
            } else {
                attack_attribute_mod = 0.129;
                defence_attribute_mod = 0.1473;
            }
        } else if (attack_attribute >= 300) {
            if (defence_attribute >= 300) {
                attack_attribute_mod = 0.0887;
                defence_attribute_mod = 0.1007;
            } else if (defence_attribute >= 150) {
                attack_attribute_mod = 0.129;
                defence_attribute_mod = 0.1473;
            } else {
                attack_attribute_mod = 0.25;
                defence_attribute_mod = 0.2894;
            }
        } else if (attack_attribute >= 150) {
            if (defence_attribute >= 150) {
                attack_attribute_mod = 0.129;
                defence_attribute_mod = 0.1473;
            } else if (defence_attribute >= 0) {
                attack_attribute_mod = 0.25;
                defence_attribute_mod = 0.2894;
            } else {
                attack_attribute_mod = 0.4;
                defence_attribute_mod = 0.55;
            }
        } else if (attack_attribute >= -99) {
            if (defence_attribute >= 0) {
                attack_attribute_mod = 0.25;
                defence_attribute_mod = 0.2894;
            } else {
                attack_attribute_mod = 0.4;
                defence_attribute_mod = 0.55;
            }
        } else if (defence_attribute >= 450) {
            attack_attribute_mod = 0.06909;
            defence_attribute_mod = 0.078;
        } else if (defence_attribute >= 350) {
            attack_attribute_mod = 0.0887;
            defence_attribute_mod = 0.1007;
        } else {
            attack_attribute_mod = 0.129;
            defence_attribute_mod = 0.1473;
        }
        int attribute_diff = attack_attribute - defence_attribute;
        if (attribute_diff >= 300) {
            max = 100.0;
            min = -50.0;
        } else if (attribute_diff >= 150) {
            max = 70.0;
            min = -50.0;
        } else if (attribute_diff >= -150) {
            max = 40.0;
            min = -50.0;
        } else if (attribute_diff >= -300) {
            max = 40.0;
            min = -60.0;
        } else {
            max = 40.0;
            min = -80.0;
        }
        attack_attribute += 100;
        attack_attribute *= attack_attribute;
        attack_attribute_mod = (double)attack_attribute / 144.0 * attack_attribute_mod;
        defence_attribute += 100;
        defence_attribute *= defence_attribute;
        defence_attribute_mod = (double)defence_attribute / 169.0 * defence_attribute_mod;
        double attribute_mod_diff = attack_attribute_mod - defence_attribute_mod;
        attribute_mod_diff = Util.constrain(attribute_mod_diff, min, max);
        double result = attribute_mod_diff / 100.0 + 1.0;
        if (attacker.isPlayer() && target.isPlayer() && result < 1.0) {
            result = 1.0;
        }
        return result;
    }

    public static void calcDamageReflected(L2Character attacker, L2Character target, Skill skill, boolean crit) {
        if (skill.isMagic() || skill.getCastRange() > 40) {
            return;
        }
        double chance = target.calcStat(Stats.VENGEANCE_SKILL_PHYSICAL_DAMAGE, 0.0, target, skill);
        if ((double)Rnd.get(100) < chance) {
            SystemMessage sm;
            if (target.isPlayer()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.COUNTERED_C1_ATTACK);
                sm.addCharName(attacker);
                target.sendPacket(sm);
            }
            if (attacker.isPlayer()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_PERFORMING_COUNTERATTACK);
                sm.addCharName(target);
                attacker.sendPacket(sm);
            }
            double counterdmg = (double)target.getPAtk(attacker) * 10.0 * 70.0 / (double)attacker.getPDef(target);
            counterdmg *= Formulas.calcWeaponTraitBonus(attacker, target);
            counterdmg *= Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
            attacker.reduceCurrentHp(counterdmg *= Formulas.calcAttributeBonus(attacker, target, skill), target, skill);
            if (crit) {
                attacker.reduceCurrentHp(counterdmg, target, skill);
            }
        }
    }

    public static boolean calcBuffDebuffReflection(L2Character target, Skill skill) {
        if (!skill.isDebuff() || skill.getActivateRate() == -1) {
            return false;
        }
        double reflectChance = target.calcStat(skill.isMagic() ? Stats.REFLECT_SKILL_MAGIC : Stats.REFLECT_SKILL_PHYSIC, 0.0, null, skill);
        return reflectChance > (double)Rnd.get(100);
    }

    public static double calcFallDam(L2Character cha, int fallHeight) {
        if (!Config.ENABLE_FALLING_DAMAGE || fallHeight < 0) {
            return 0.0;
        }
        double damage = cha.calcStat(Stats.FALL, (double)(fallHeight * cha.getMaxHp()) / 1000.0, null, null);
        return damage;
    }

    public static boolean calcBlowSuccess(L2Character activeChar, L2Character target, Skill skill) {
        double dexMod = BaseStats.DEX.calcBonus(activeChar);
        double blowChance = skill.getBlowChance();
        double sideMod = activeChar.isInFrontOfTarget() ? 1.0 : (activeChar.isBehindTarget() ? 2.0 : 1.5);
        double baseRate = blowChance * dexMod * sideMod;
        double rate = activeChar.calcStat(Stats.BLOW_RATE, baseRate, target, null);
        if (activeChar.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("dexMod", dexMod);
            set.set("blowChance", blowChance);
            set.set("sideMod", sideMod);
            set.set("baseRate", baseRate);
            set.set("rate", rate);
            Debug.sendSkillDebug(activeChar, target, skill, set);
        }
        return (double)Rnd.get(100) < rate;
    }

    public static List<BuffInfo> calcCancelStealEffects(L2Character activeChar, L2Character target, Skill skill, String slot, int rate, int max) {
        ArrayList<BuffInfo> canceled = new ArrayList<BuffInfo>(max);
        block4 : switch (slot) {
            case "buff": {
                ArrayList<BuffInfo> buffs;
                int cancelMagicLvl = skill.getMagicLevel();
                double vuln = target.calcStat(Stats.CANCEL_VULN, 0.0, target, null);
                double prof = activeChar.calcStat(Stats.CANCEL_PROF, 0.0, target, null);
                double resMod = 1.0 + (vuln + prof) * -1.0 / 100.0;
                double finalRate = (double)rate / resMod;
                if (activeChar.isDebug()) {
                    StatsSet set = new StatsSet();
                    set.set("baseMod", rate);
                    set.set("magicLevel", cancelMagicLvl);
                    set.set("resMod", resMod);
                    set.set("rate", finalRate);
                    Debug.sendSkillDebug(activeChar, target, skill, set);
                }
                ArrayList<BuffInfo> arrayList = buffs = target.getEffectList().hasBuffs() ? new ArrayList<BuffInfo>(target.getEffectList().getBuffs().values()) : new ArrayList(1);
                if (target.getEffectList().hasTriggered()) {
                    buffs.addAll(target.getEffectList().getTriggered().values());
                }
                if (target.getEffectList().hasDances()) {
                    buffs.addAll(target.getEffectList().getDances().values());
                }
                for (int i = buffs.size() - 1; i >= 0; --i) {
                    BuffInfo info = (BuffInfo)buffs.get(i);
                    if (!info.getSkill().canBeStolen() || !Formulas.calcCancelSuccess(info, cancelMagicLvl, (int)finalRate, skill)) continue;
                    canceled.add(info);
                    if (canceled.size() >= max) break block4;
                }
                break;
            }
            case "debuff": {
                ArrayList<BuffInfo> debuffs = new ArrayList<BuffInfo>(target.getEffectList().getDebuffs().values());
                for (int i = debuffs.size() - 1; i >= 0; --i) {
                    BuffInfo info = (BuffInfo)debuffs.get(i);
                    if (!info.getSkill().isDebuff() || !info.getSkill().canBeDispeled() || Rnd.get(100) > rate) continue;
                    canceled.add(info);
                    if (canceled.size() >= max) break block4;
                }
                break;
            }
        }
        return canceled;
    }

    public static boolean calcCancelSuccess(BuffInfo info, int cancelMagicLvl, int rate, Skill skill) {
        rate = (int)((double)rate * (info.getSkill().getMagicLevel() > 0 ? 1.0 + (double)(cancelMagicLvl - info.getSkill().getMagicLevel()) / 100.0 : 1.0));
        return Rnd.get(100) < Util.constrain(rate, skill.getMinChance(), skill.getMaxChance());
    }

    public static int calcEffectAbnormalTime(Env env) {
        int time;
        L2Character caster = env.getCharacter();
        L2Character target = env.getTarget();
        Skill skill = env.getSkill();
        int n = time = skill.isPassive() || skill.isToggle() ? -1 : skill.getAbnormalTime();
        if (target != null && target.isServitor() && skill.isAbnormalInstant()) {
            time /= 2;
        }
        if (env.isSkillMastery()) {
            time *= 2;
        }
        if (caster != null && target != null && skill.isDebuff()) {
            double statMod = skill.getBasicProperty().calcBonus(target);
            double resMod = Formulas.calcGeneralTraitBonus(caster, target, skill.getTraitType(), false);
            double lvlBonusMod = Formulas.calcLvlBonusMod(caster, target, skill);
            double elementMod = Formulas.calcAttributeBonus(caster, target, skill);
            time = (int)Math.ceil(Util.constrain((double)time * resMod * lvlBonusMod * elementMod / statMod, (double)time * 0.5, (double)time));
        }
        return time;
    }

    public static boolean calcProbability(double baseChance, L2Character attacker, L2Character target, Skill skill) {
        return (double)Rnd.get(100) < ((double)skill.getMagicLevel() + baseChance - (double)target.getLevel() + 30.0 - (double)target.getINT()) * Formulas.calcAttributeBonus(attacker, target, skill) * Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
    }

    public static int calculateKarmaLost(L2PcInstance player, long exp) {
        double karmaLooseMul = KarmaData.getInstance().getMultiplier(player.getLevel());
        if (exp > 0L) {
            exp = (long)((float)exp / Config.RATE_KARMA_LOST);
        }
        return (int)((double)Math.abs(exp) / karmaLooseMul / 15.0);
    }

    public static int calculateKarmaGain(int pkCount, boolean isSummon) {
        int result = 43200;
        if (isSummon && (result = (int)(((double)pkCount * 0.375 + 1.0) * 60.0 * 4.0) - 150) > 10800) {
            return 10800;
        }
        if (pkCount < 99) {
            result = (int)(((double)pkCount * 0.5 + 1.0) * 60.0 * 12.0);
        } else if (pkCount < 180) {
            result = (int)(((double)pkCount * 0.125 + 37.75) * 60.0 * 12.0);
        }
        return result;
    }

    public static double calcGeneralTraitBonus(L2Character attacker, L2Character target, TraitType traitType, boolean ignoreResistance) {
        if (traitType == TraitType.NONE) {
            return 1.0;
        }
        if (target.getStat().isTraitInvul(traitType)) {
            return 0.0;
        }
        switch (traitType.getType()) {
            case 2: {
                if (attacker.getStat().hasAttackTrait(traitType) && target.getStat().hasDefenceTrait(traitType)) break;
                return 1.0;
            }
            case 3: {
                if (!ignoreResistance) break;
                return 1.0;
            }
            default: {
                return 1.0;
            }
        }
        double result = (double)(attacker.getStat().getAttackTrait(traitType) - target.getStat().getDefenceTrait(traitType)) + 1.0;
        return Util.constrain(result, 0.05, 2.0);
    }

    public static double calcWeaponTraitBonus(L2Character attacker, L2Character target) {
        TraitType type = attacker.getAttackType().getTraitType();
        double result = (double)target.getStat().getDefenceTraits()[type.getId()] - 1.0;
        return 1.0 - result;
    }

    public static double calcAttackTraitBonus(L2Character attacker, L2Character target) {
        double weaponTraitBonus = Formulas.calcWeaponTraitBonus(attacker, target);
        if (weaponTraitBonus == 0.0) {
            return 0.0;
        }
        double weaknessBonus = 1.0;
        for (TraitType traitType : TraitType.values()) {
            if (traitType.getType() != 2 || (weaknessBonus *= Formulas.calcGeneralTraitBonus(attacker, target, traitType, true)) != 0.0) continue;
            return 0.0;
        }
        return Util.constrain(weaponTraitBonus * weaknessBonus, 0.05, 2.0);
    }
}

