/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.variables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.variables.AbstractVariables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccountVariables
extends AbstractVariables {
    private static final Logger _log = Logger.getLogger(AccountVariables.class.getName());
    private static final String SELECT_QUERY = "SELECT * FROM account_gsdata WHERE account_name = ?";
    private static final String DELETE_QUERY = "DELETE FROM account_gsdata WHERE account_name = ?";
    private static final String INSERT_QUERY = "INSERT INTO account_gsdata (account_name, var, value) VALUES (?, ?, ?)";
    private final String _accountName;

    public AccountVariables(String accountName) {
        this._accountName = accountName;
        this.restoreMe();
    }

    @Override
    public boolean restoreMe() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement st = con.prepareStatement(SELECT_QUERY);){
            st.setString(1, this._accountName);
            try (ResultSet rset = st.executeQuery();){
                while (rset.next()) {
                    this.set(rset.getString("var"), rset.getString("value"));
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't restore variables for: " + this._accountName, e);
            return false;
        }
        return true;
    }

    @Override
    public boolean storeMe() {
        if (!this.getAndResetChanges()) {
            return false;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            try (PreparedStatement st = con.prepareStatement(DELETE_QUERY);){
                st.setString(1, this._accountName);
                st.execute();
            }
            st = con.prepareStatement(INSERT_QUERY);
            var4_7 = null;
            try {
                st.setString(1, this._accountName);
                for (Map.Entry<String, Object> entry : this.getSet().entrySet()) {
                    st.setString(2, entry.getKey());
                    st.setString(3, String.valueOf(entry.getValue()));
                    st.addBatch();
                }
                st.executeBatch();
            }
            catch (Throwable throwable) {
                var4_7 = throwable;
                throw throwable;
            }
            finally {
                if (st != null) {
                    if (var4_7 != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable) {
                            var4_7.addSuppressed(throwable);
                        }
                    } else {
                        st.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't update variables for: " + this._accountName, e);
            return false;
        }
        return true;
    }
}

