/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;

public abstract class L2ZoneRespawn
extends L2ZoneType {
    private List<Location> _spawnLocs = null;
    private List<Location> _otherSpawnLocs = null;
    private List<Location> _chaoticSpawnLocs = null;
    private List<Location> _banishSpawnLocs = null;

    protected L2ZoneRespawn(int id) {
        super(id);
    }

    public void parseLoc(int x, int y, int z, String type) {
        if (type == null || type.isEmpty()) {
            this.addSpawn(x, y, z);
        } else {
            switch (type) {
                case "other": {
                    this.addOtherSpawn(x, y, z);
                    break;
                }
                case "chaotic": {
                    this.addChaoticSpawn(x, y, z);
                    break;
                }
                case "banish": {
                    this.addBanishSpawn(x, y, z);
                    break;
                }
                default: {
                    _log.warning(this.getClass().getSimpleName() + ": Unknown location type: " + type);
                }
            }
        }
    }

    public final void addSpawn(int x, int y, int z) {
        if (this._spawnLocs == null) {
            this._spawnLocs = new ArrayList<Location>();
        }
        this._spawnLocs.add(new Location(x, y, z));
    }

    public final void addOtherSpawn(int x, int y, int z) {
        if (this._otherSpawnLocs == null) {
            this._otherSpawnLocs = new ArrayList<Location>();
        }
        this._otherSpawnLocs.add(new Location(x, y, z));
    }

    public final void addChaoticSpawn(int x, int y, int z) {
        if (this._chaoticSpawnLocs == null) {
            this._chaoticSpawnLocs = new ArrayList<Location>();
        }
        this._chaoticSpawnLocs.add(new Location(x, y, z));
    }

    public final void addBanishSpawn(int x, int y, int z) {
        if (this._banishSpawnLocs == null) {
            this._banishSpawnLocs = new ArrayList<Location>();
        }
        this._banishSpawnLocs.add(new Location(x, y, z));
    }

    public final List<Location> getSpawns() {
        return this._spawnLocs;
    }

    public final Location getSpawnLoc() {
        if (Config.RANDOM_RESPAWN_IN_TOWN_ENABLED) {
            return this._spawnLocs.get(Rnd.get(this._spawnLocs.size()));
        }
        return this._spawnLocs.get(0);
    }

    public final Location getOtherSpawnLoc() {
        if (this._otherSpawnLocs != null) {
            if (Config.RANDOM_RESPAWN_IN_TOWN_ENABLED) {
                return this._otherSpawnLocs.get(Rnd.get(this._otherSpawnLocs.size()));
            }
            return this._otherSpawnLocs.get(0);
        }
        return this.getSpawnLoc();
    }

    public final Location getChaoticSpawnLoc() {
        if (this._chaoticSpawnLocs != null) {
            if (Config.RANDOM_RESPAWN_IN_TOWN_ENABLED) {
                return this._chaoticSpawnLocs.get(Rnd.get(this._chaoticSpawnLocs.size()));
            }
            return this._chaoticSpawnLocs.get(0);
        }
        return this.getSpawnLoc();
    }

    public final Location getBanishSpawnLoc() {
        if (this._banishSpawnLocs != null) {
            if (Config.RANDOM_RESPAWN_IN_TOWN_ENABLED) {
                return this._banishSpawnLocs.get(Rnd.get(this._banishSpawnLocs.size()));
            }
            return this._banishSpawnLocs.get(0);
        }
        return this.getSpawnLoc();
    }
}

