/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.model.zone.type.L2ResidenceZone;
import com.l2jserver.gameserver.network.serverpackets.AgitDecoInfo;

public class L2ClanHallZone
extends L2ResidenceZone {
    public L2ClanHallZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("clanHallId")) {
            this.setResidenceId(Integer.parseInt(value));
            ClanHall hall = ClanHallManager.getInstance().getClanHallById(this.getResidenceId());
            if (hall == null) {
                _log.warning("L2ClanHallZone: Clan hall with id " + this.getResidenceId() + " does not exist!");
            } else {
                hall.setZone(this);
            }
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.CLAN_HALL, true);
            AuctionableHall clanHall = ClanHallManager.getInstance().getAuctionableHallById(this.getResidenceId());
            if (clanHall == null) {
                return;
            }
            AgitDecoInfo deco = new AgitDecoInfo(clanHall);
            character.sendPacket(deco);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.CLAN_HALL, false);
        }
    }
}

