/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2OlympiadManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneRespawn;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMatchEnd;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadUserInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.List;

public class L2OlympiadStadiumZone
extends L2ZoneRespawn {
    private ArrayList<Location> _spectatorLocations;

    public L2OlympiadStadiumZone(int id) {
        super(id);
        AbstractZoneSettings settings = ZoneManager.getSettings(this.getName());
        if (settings == null) {
            settings = new Settings();
        }
        this.setSettings(settings);
    }

    @Override
    public Settings getSettings() {
        return (Settings)super.getSettings();
    }

    public final void registerTask(OlympiadGameTask task) {
        this.getSettings().setTask(task);
    }

    public final void openDoors() {
        for (L2DoorInstance door : InstanceManager.getInstance().getInstance(this.getInstanceId()).getDoors()) {
            if (door == null || door.getOpen()) continue;
            door.openMe();
        }
    }

    public final void closeDoors() {
        for (L2DoorInstance door : InstanceManager.getInstance().getInstance(this.getInstanceId()).getDoors()) {
            if (door == null || !door.getOpen()) continue;
            door.closeMe();
        }
    }

    public final void spawnBuffers() {
        for (L2Npc buffer : InstanceManager.getInstance().getInstance(this.getInstanceId()).getNpcs()) {
            if (!(buffer instanceof L2OlympiadManagerInstance) || buffer.isVisible()) continue;
            buffer.spawnMe();
        }
    }

    public final void deleteBuffers() {
        for (L2Npc buffer : InstanceManager.getInstance().getInstance(this.getInstanceId()).getNpcs()) {
            if (!(buffer instanceof L2OlympiadManagerInstance) || !buffer.isVisible()) continue;
            buffer.decayMe();
        }
    }

    public final void broadcastStatusUpdate(L2PcInstance player) {
        ExOlympiadUserInfo packet = new ExOlympiadUserInfo(player);
        for (L2PcInstance target : this.getPlayersInside()) {
            if (target == null || !target.inObserverMode() && target.getOlympiadSide() == player.getOlympiadSide()) continue;
            target.sendPacket(packet);
        }
    }

    public final void broadcastPacketToObservers(L2GameServerPacket packet) {
        for (L2Character character : this.getCharactersInside()) {
            if (character == null || !character.isPlayer() || !character.getActingPlayer().inObserverMode()) continue;
            character.sendPacket(packet);
        }
    }

    @Override
    protected final void onEnter(L2Character character) {
        L2PcInstance player;
        if (this.getSettings().getOlympiadTask() != null && this.getSettings().getOlympiadTask().isBattleStarted()) {
            character.setInsideZone(ZoneId.PVP, true);
            if (character.isPlayer()) {
                character.sendPacket(SystemMessageId.ENTERED_COMBAT_ZONE);
                this.getSettings().getOlympiadTask().getGame().sendOlympiadInfo(character);
            }
        }
        if (character.isPlayable() && (player = character.getActingPlayer()) != null) {
            if (!(player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS) || player.isInOlympiadMode() || player.inObserverMode())) {
                ThreadPoolManager.getInstance().executeGeneral(new KickPlayer(player));
            } else if (player.hasPet()) {
                player.getSummon().unSummon(player);
            }
        }
    }

    @Override
    protected final void onExit(L2Character character) {
        if (this.getSettings().getOlympiadTask() != null && this.getSettings().getOlympiadTask().isBattleStarted()) {
            character.setInsideZone(ZoneId.PVP, false);
            if (character.isPlayer()) {
                character.sendPacket(SystemMessageId.LEFT_COMBAT_ZONE);
                character.sendPacket(ExOlympiadMatchEnd.STATIC_PACKET);
            }
        }
    }

    public final void updateZoneStatusForCharactersInside() {
        if (this.getSettings().getOlympiadTask() == null) {
            return;
        }
        boolean battleStarted = this.getSettings().getOlympiadTask().isBattleStarted();
        SystemMessage sm = battleStarted ? SystemMessage.getSystemMessage(SystemMessageId.ENTERED_COMBAT_ZONE) : SystemMessage.getSystemMessage(SystemMessageId.LEFT_COMBAT_ZONE);
        for (L2Character character : this.getCharactersInside()) {
            if (character == null) continue;
            if (battleStarted) {
                character.setInsideZone(ZoneId.PVP, true);
                if (!character.isPlayer()) continue;
                character.sendPacket(sm);
                continue;
            }
            character.setInsideZone(ZoneId.PVP, false);
            if (!character.isPlayer()) continue;
            character.sendPacket(sm);
            character.sendPacket(ExOlympiadMatchEnd.STATIC_PACKET);
        }
    }

    @Override
    public void parseLoc(int x, int y, int z, String type) {
        if (type != null && type.equals("spectatorSpawn")) {
            if (this._spectatorLocations == null) {
                this._spectatorLocations = new ArrayList();
            }
            this._spectatorLocations.add(new Location(x, y, z));
        } else {
            super.parseLoc(x, y, z, type);
        }
    }

    public List<Location> getSpectatorSpawns() {
        return this._spectatorLocations;
    }

    private static final class KickPlayer
    implements Runnable {
        private L2PcInstance _player;

        public KickPlayer(L2PcInstance player) {
            this._player = player;
        }

        @Override
        public void run() {
            if (this._player != null) {
                if (this._player.hasSummon()) {
                    this._player.getSummon().unSummon(this._player);
                }
                this._player.teleToLocation(TeleportWhereType.TOWN);
                this._player.setInstanceId(0);
                this._player = null;
            }
        }
    }

    private final class Settings
    extends AbstractZoneSettings {
        private OlympiadGameTask _task = null;

        public OlympiadGameTask getOlympiadTask() {
            return this._task;
        }

        protected void setTask(OlympiadGameTask task) {
            this._task = task;
        }

        @Override
        public void clear() {
            this._task = null;
        }
    }
}

