/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;

public class L2SiegeZone
extends L2ZoneType {
    private static final int DISMOUNT_DELAY = 5;

    public L2SiegeZone(int id) {
        super(id);
        AbstractZoneSettings settings = ZoneManager.getSettings(this.getName());
        if (settings == null) {
            settings = new Settings();
        }
        this.setSettings(settings);
    }

    @Override
    public Settings getSettings() {
        return (Settings)super.getSettings();
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("castleId")) {
            if (this.getSettings().getSiegeableId() != -1) {
                throw new IllegalArgumentException("Siege object already defined!");
            }
            this.getSettings().setSiegeableId(Integer.parseInt(value));
        } else if (name.equals("fortId")) {
            if (this.getSettings().getSiegeableId() != -1) {
                throw new IllegalArgumentException("Siege object already defined!");
            }
            this.getSettings().setSiegeableId(Integer.parseInt(value));
        } else if (name.equals("clanHallId")) {
            if (this.getSettings().getSiegeableId() != -1) {
                throw new IllegalArgumentException("Siege object already defined!");
            }
            this.getSettings().setSiegeableId(Integer.parseInt(value));
            SiegableHall hall = (SiegableHall)CHSiegeManager.getInstance().getConquerableHalls().get((Object)this.getSettings().getSiegeableId());
            if (hall == null) {
                _log.warning("L2SiegeZone: Siegable clan hall with id " + value + " does not exist!");
            } else {
                hall.setSiegeZone(this);
            }
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (this.getSettings().isActiveSiege()) {
            character.setInsideZone(ZoneId.PVP, true);
            character.setInsideZone(ZoneId.SIEGE, true);
            character.setInsideZone(ZoneId.NO_SUMMON_FRIEND, true);
            if (character.isPlayer()) {
                L2PcInstance plyer = character.getActingPlayer();
                if (plyer.isRegisteredOnThisSiegeField(this.getSettings().getSiegeableId())) {
                    plyer.setIsInSiege(true);
                    if (this.getSettings().getSiege().giveFame() && this.getSettings().getSiege().getFameFrequency() > 0) {
                        plyer.startFameTask(this.getSettings().getSiege().getFameFrequency() * 1000, this.getSettings().getSiege().getFameAmount());
                    }
                }
                character.sendPacket(SystemMessageId.ENTERED_COMBAT_ZONE);
                if (!Config.ALLOW_WYVERN_DURING_SIEGE && plyer.getMountType() == MountType.WYVERN) {
                    plyer.sendPacket(SystemMessageId.AREA_CANNOT_BE_ENTERED_WHILE_MOUNTED_WYVERN);
                    plyer.enteredNoLanding(5);
                }
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone(ZoneId.PVP, false);
        character.setInsideZone(ZoneId.SIEGE, false);
        character.setInsideZone(ZoneId.NO_SUMMON_FRIEND, false);
        if (this.getSettings().isActiveSiege() && character.isPlayer()) {
            L2PcInstance player = character.getActingPlayer();
            character.sendPacket(SystemMessageId.LEFT_COMBAT_ZONE);
            if (player.getMountType() == MountType.WYVERN) {
                player.exitedNoLanding();
            }
            if (player.getPvpFlag() == 0) {
                player.startPvPFlag();
            }
        }
        if (character.isPlayer()) {
            L2PcInstance activeChar = character.getActingPlayer();
            activeChar.stopFameTask();
            activeChar.setIsInSiege(false);
            if (this.getSettings().getSiege() instanceof FortSiege && activeChar.getInventory().getItemByItemId(9819) != null) {
                Fort fort = FortManager.getInstance().getFortById(this.getSettings().getSiegeableId());
                if (fort != null) {
                    FortSiegeManager.getInstance().dropCombatFlag(activeChar, fort.getResidenceId());
                } else {
                    int slot = activeChar.getInventory().getSlotFromItem(activeChar.getInventory().getItemByItemId(9819));
                    activeChar.getInventory().unEquipItemInBodySlot(slot);
                    activeChar.destroyItem("CombatFlag", activeChar.getInventory().getItemByItemId(9819), null, true);
                }
            }
        }
    }

    @Override
    public void onDieInside(L2Character character) {
        if (this.getSettings().isActiveSiege() && character.isPlayer() && character.getActingPlayer().isRegisteredOnThisSiegeField(this.getSettings().getSiegeableId())) {
            Skill skill;
            int lvl = 1;
            BuffInfo info = character.getEffectList().getBuffInfoBySkillId(5660);
            if (info != null) {
                lvl = Math.min(lvl + info.getSkill().getLevel(), 5);
            }
            if ((skill = SkillData.getInstance().getSkill(5660, lvl)) != null) {
                skill.applyEffects(character, character);
            }
        }
    }

    public void updateZoneStatusForCharactersInside() {
        if (this.getSettings().isActiveSiege()) {
            for (L2Character character : this.getCharactersInside()) {
                if (character == null) continue;
                this.onEnter(character);
            }
        } else {
            for (L2Character character : this.getCharactersInside()) {
                if (character == null) continue;
                character.setInsideZone(ZoneId.PVP, false);
                character.setInsideZone(ZoneId.SIEGE, false);
                character.setInsideZone(ZoneId.NO_SUMMON_FRIEND, false);
                if (!character.isPlayer()) continue;
                L2PcInstance player = character.getActingPlayer();
                character.sendPacket(SystemMessageId.LEFT_COMBAT_ZONE);
                player.stopFameTask();
                if (player.getMountType() != MountType.WYVERN) continue;
                player.exitedNoLanding();
            }
        }
    }

    public void announceToPlayers(String message) {
        for (L2PcInstance player : this.getPlayersInside()) {
            if (player == null) continue;
            player.sendMessage(message);
        }
    }

    public int getSiegeObjectId() {
        return this.getSettings().getSiegeableId();
    }

    public boolean isActive() {
        return this.getSettings().isActiveSiege();
    }

    public void setIsActive(boolean val) {
        this.getSettings().setActiveSiege(val);
    }

    public void setSiegeInstance(Siegable siege) {
        this.getSettings().setSiege(siege);
    }

    public void banishForeigners(int owningClanId) {
        TeleportWhereType type = TeleportWhereType.TOWN;
        for (L2PcInstance temp : this.getPlayersInside()) {
            if (temp.getClanId() == owningClanId) continue;
            temp.teleToLocation(type);
        }
    }

    private final class Settings
    extends AbstractZoneSettings {
        private int _siegableId = -1;
        private Siegable _siege = null;
        private boolean _isActiveSiege = false;

        public int getSiegeableId() {
            return this._siegableId;
        }

        protected void setSiegeableId(int id) {
            this._siegableId = id;
        }

        public Siegable getSiege() {
            return this._siege;
        }

        public void setSiege(Siegable s) {
            this._siege = s;
        }

        public boolean isActiveSiege() {
            return this._isActiveSiege;
        }

        public void setActiveSiege(boolean val) {
            this._isActiveSiege = val;
        }

        @Override
        public void clear() {
            this._siegableId = -1;
            this._siege = null;
            this._isActiveSiege = false;
        }
    }
}

