/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.CrystalType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.Arrays;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;

public abstract class AbstractRefinePacket
extends L2GameClientPacket {
    public static final int GRADE_NONE = 0;
    public static final int GRADE_MID = 1;
    public static final int GRADE_HIGH = 2;
    public static final int GRADE_TOP = 3;
    public static final int GRADE_ACC = 4;
    protected static final int GEMSTONE_D = 2130;
    protected static final int GEMSTONE_C = 2131;
    protected static final int GEMSTONE_B = 2132;
    private static final SortedIntObjectArrayMap<LifeStone> _lifeStones = new SortedIntObjectArrayMap((Object[])new LifeStone[0]).append(8723, (Object)new LifeStone(0, 0)).append(8724, (Object)new LifeStone(0, 1)).append(8725, (Object)new LifeStone(0, 2)).append(8726, (Object)new LifeStone(0, 3)).append(8727, (Object)new LifeStone(0, 4)).append(8728, (Object)new LifeStone(0, 5)).append(8729, (Object)new LifeStone(0, 6)).append(8730, (Object)new LifeStone(0, 7)).append(8731, (Object)new LifeStone(0, 8)).append(8732, (Object)new LifeStone(0, 9)).append(8733, (Object)new LifeStone(1, 0)).append(8734, (Object)new LifeStone(1, 1)).append(8735, (Object)new LifeStone(1, 2)).append(8736, (Object)new LifeStone(1, 3)).append(8737, (Object)new LifeStone(1, 4)).append(8738, (Object)new LifeStone(1, 5)).append(8739, (Object)new LifeStone(1, 6)).append(8740, (Object)new LifeStone(1, 7)).append(8741, (Object)new LifeStone(1, 8)).append(8742, (Object)new LifeStone(1, 9)).append(8743, (Object)new LifeStone(2, 0)).append(8744, (Object)new LifeStone(2, 1)).append(8745, (Object)new LifeStone(2, 2)).append(8746, (Object)new LifeStone(2, 3)).append(8747, (Object)new LifeStone(2, 4)).append(8748, (Object)new LifeStone(2, 5)).append(8749, (Object)new LifeStone(2, 6)).append(8750, (Object)new LifeStone(2, 7)).append(8751, (Object)new LifeStone(2, 8)).append(8752, (Object)new LifeStone(2, 9)).append(8753, (Object)new LifeStone(3, 0)).append(8754, (Object)new LifeStone(3, 1)).append(8755, (Object)new LifeStone(3, 2)).append(8756, (Object)new LifeStone(3, 3)).append(8757, (Object)new LifeStone(3, 4)).append(8758, (Object)new LifeStone(3, 5)).append(8759, (Object)new LifeStone(3, 6)).append(8760, (Object)new LifeStone(3, 7)).append(8761, (Object)new LifeStone(3, 8)).append(8762, (Object)new LifeStone(3, 9)).append(9573, (Object)new LifeStone(0, 10)).append(9574, (Object)new LifeStone(1, 10)).append(9575, (Object)new LifeStone(2, 10)).append(9576, (Object)new LifeStone(3, 10)).append(10483, (Object)new LifeStone(0, 11)).append(10484, (Object)new LifeStone(1, 11)).append(10485, (Object)new LifeStone(2, 11)).append(10486, (Object)new LifeStone(3, 11)).append(12754, (Object)new LifeStone(4, 0)).append(12755, (Object)new LifeStone(4, 1)).append(12756, (Object)new LifeStone(4, 2)).append(12757, (Object)new LifeStone(4, 3)).append(12758, (Object)new LifeStone(4, 4)).append(12759, (Object)new LifeStone(4, 5)).append(12760, (Object)new LifeStone(4, 6)).append(12761, (Object)new LifeStone(4, 7)).append(12762, (Object)new LifeStone(4, 8)).append(12763, (Object)new LifeStone(4, 9)).append(12821, (Object)new LifeStone(4, 10)).append(12822, (Object)new LifeStone(4, 11)).append(12840, (Object)new LifeStone(4, 0)).append(12841, (Object)new LifeStone(4, 1)).append(12842, (Object)new LifeStone(4, 2)).append(12843, (Object)new LifeStone(4, 3)).append(12844, (Object)new LifeStone(4, 4)).append(12845, (Object)new LifeStone(4, 5)).append(12846, (Object)new LifeStone(4, 6)).append(12847, (Object)new LifeStone(4, 7)).append(12848, (Object)new LifeStone(4, 8)).append(12849, (Object)new LifeStone(4, 9)).append(12850, (Object)new LifeStone(4, 10)).append(12851, (Object)new LifeStone(4, 11)).append(14008, (Object)new LifeStone(4, 12)).append(14166, (Object)new LifeStone(0, 12)).append(14167, (Object)new LifeStone(1, 12)).append(14168, (Object)new LifeStone(2, 12)).append(14169, (Object)new LifeStone(3, 12)).append(16160, (Object)new LifeStone(0, 13)).append(16161, (Object)new LifeStone(1, 13)).append(16162, (Object)new LifeStone(2, 13)).append(16163, (Object)new LifeStone(3, 13)).append(16177, (Object)new LifeStone(4, 13)).append(16164, (Object)new LifeStone(0, 13)).append(16165, (Object)new LifeStone(1, 13)).append(16166, (Object)new LifeStone(2, 13)).append(16167, (Object)new LifeStone(3, 13)).append(16178, (Object)new LifeStone(4, 13));

    protected static final LifeStone getLifeStone(int itemId) {
        return (LifeStone)_lifeStones.get(itemId);
    }

    protected static final boolean isValid(L2PcInstance player, L2ItemInstance item, L2ItemInstance refinerItem, L2ItemInstance gemStones) {
        if (!AbstractRefinePacket.isValid(player, item, refinerItem)) {
            return false;
        }
        if (gemStones.getOwnerId() != player.getObjectId()) {
            return false;
        }
        if (gemStones.getItemLocation() != ItemLocation.INVENTORY) {
            return false;
        }
        CrystalType grade = item.getItem().getItemGrade();
        LifeStone ls = (LifeStone)_lifeStones.get(refinerItem.getId());
        if (AbstractRefinePacket.getGemStoneId(grade) != gemStones.getId()) {
            return false;
        }
        return (long)AbstractRefinePacket.getGemStoneCount(grade, ls.getGrade()) <= gemStones.getCount();
    }

    protected static final boolean isValid(L2PcInstance player, L2ItemInstance item, L2ItemInstance refinerItem) {
        if (!AbstractRefinePacket.isValid(player, item)) {
            return false;
        }
        if (refinerItem.getOwnerId() != player.getObjectId()) {
            return false;
        }
        if (refinerItem.getItemLocation() != ItemLocation.INVENTORY) {
            return false;
        }
        LifeStone ls = (LifeStone)_lifeStones.get(refinerItem.getId());
        if (ls == null) {
            return false;
        }
        if (item.getItem() instanceof L2Weapon && ls.getGrade() == 4) {
            return false;
        }
        if (item.getItem() instanceof L2Armor && ls.getGrade() != 4) {
            return false;
        }
        return player.getLevel() >= ls.getPlayerLevel();
    }

    protected static final boolean isValid(L2PcInstance player, L2ItemInstance item) {
        block20: {
            block21: {
                block19: {
                    if (!AbstractRefinePacket.isValid(player)) {
                        return false;
                    }
                    if (item.getOwnerId() != player.getObjectId()) {
                        return false;
                    }
                    if (item.isAugmented()) {
                        return false;
                    }
                    if (item.isHeroItem()) {
                        return false;
                    }
                    if (item.isShadowItem()) {
                        return false;
                    }
                    if (item.isCommonItem()) {
                        return false;
                    }
                    if (item.isEtcItem()) {
                        return false;
                    }
                    if (item.isTimeLimitedItem()) {
                        return false;
                    }
                    if (item.isPvp() && !Config.ALT_ALLOW_AUGMENT_PVP_ITEMS) {
                        return false;
                    }
                    if (item.getItem().getCrystalType().isLesser(CrystalType.C)) {
                        return false;
                    }
                    switch (item.getItemLocation()) {
                        case INVENTORY: 
                        case PAPERDOLL: {
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (!(item.getItem() instanceof L2Weapon)) break block19;
                    switch (((L2Weapon)item.getItem()).getItemType()) {
                        case NONE: 
                        case FISHINGROD: {
                            return false;
                        }
                    }
                    break block20;
                }
                if (!(item.getItem() instanceof L2Armor)) break block21;
                switch (item.getItem().getBodyPart()) {
                    case 6: 
                    case 8: 
                    case 48: {
                        break block20;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        return Arrays.binarySearch(Config.AUGMENTATION_BLACKLIST, item.getId()) < 0;
    }

    protected static final boolean isValid(L2PcInstance player) {
        if (player.getPrivateStoreType() != PrivateStoreType.NONE) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_A_PRIVATE_STORE_OR_PRIVATE_WORKSHOP_IS_IN_OPERATION);
            return false;
        }
        if (player.getActiveTradeList() != null) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_TRADING);
            return false;
        }
        if (player.isDead()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_DEAD);
            return false;
        }
        if (player.isParalyzed()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_PARALYZED);
            return false;
        }
        if (player.isFishing()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_FISHING);
            return false;
        }
        if (player.isSitting()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_SITTING_DOWN);
            return false;
        }
        if (player.isCursedWeaponEquipped()) {
            return false;
        }
        return !player.isEnchanting() && !player.isProcessingTransaction();
    }

    protected static final int getGemStoneId(CrystalType itemGrade) {
        switch (itemGrade) {
            case C: 
            case B: {
                return 2130;
            }
            case A: 
            case S: {
                return 2131;
            }
            case S80: 
            case S84: {
                return 2132;
            }
        }
        return 0;
    }

    protected static final int getGemStoneCount(CrystalType itemGrade, int lifeStoneGrade) {
        switch (lifeStoneGrade) {
            case 4: {
                switch (itemGrade) {
                    case C: {
                        return 200;
                    }
                    case B: {
                        return 300;
                    }
                    case A: {
                        return 200;
                    }
                    case S: {
                        return 250;
                    }
                    case S80: {
                        return 360;
                    }
                    case S84: {
                        return 480;
                    }
                }
                return 0;
            }
        }
        switch (itemGrade) {
            case C: {
                return 20;
            }
            case B: {
                return 30;
            }
            case A: {
                return 20;
            }
            case S: {
                return 25;
            }
            case S80: 
            case S84: {
                return 36;
            }
        }
        return 0;
    }

    protected static final class LifeStone {
        private static final int[] LEVELS = new int[]{46, 49, 52, 55, 58, 61, 64, 67, 70, 76, 80, 82, 84, 85};
        private final int _grade;
        private final int _level;

        public LifeStone(int grade, int level) {
            this._grade = grade;
            this._level = level;
        }

        public final int getLevel() {
            return this._level;
        }

        public final int getGrade() {
            return this._grade;
        }

        public final int getPlayerLevel() {
            return LEVELS[this._level];
        }
    }
}

