/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;

public final class Action
extends L2GameClientPacket {
    private static final String __C__1F_ACTION = "[C] 1F Action";
    private int _objectId;
    private int _originX;
    private int _originY;
    private int _originZ;
    private int _actionId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._originX = this.readD();
        this._originY = this.readD();
        this._originZ = this.readD();
        this._actionId = this.readC();
    }

    @Override
    protected void runImpl() {
        L2Object obj;
        L2PcInstance activeChar;
        if (Config.DEBUG) {
            _log.info(this.getType() + ": " + (this._actionId == 0 ? "Simple-click" : "Shift-click") + " Target object ID: " + this._objectId + " orignX: " + this._originX + " orignY: " + this._originY + " orignZ: " + this._originZ);
        }
        if ((activeChar = this.getActiveChar()) == null) {
            return;
        }
        if (activeChar.inObserverMode()) {
            activeChar.sendPacket(SystemMessageId.OBSERVERS_CANNOT_PARTICIPATE);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        BuffInfo info = activeChar.getEffectList().getBuffInfoByAbnormalType(AbnormalType.BOT_PENALTY);
        if (info != null) {
            for (AbstractEffect effect : info.getEffects()) {
                if (effect.checkCondition(-4)) continue;
                activeChar.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REPORTED_SO_ACTIONS_NOT_ALLOWED);
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        if ((obj = activeChar.getTargetId() == this._objectId ? activeChar.getTarget() : (activeChar.isInAirShip() && activeChar.getAirShip().getHelmObjectId() == this._objectId ? activeChar.getAirShip() : L2World.getInstance().findObject(this._objectId))) == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!obj.isTargetable() && !activeChar.canOverrideCond(PcCondOverride.TARGET_ALL)) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (obj.getInstanceId() != activeChar.getInstanceId() && activeChar.getInstanceId() != -1) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!obj.isVisibleFor(activeChar)) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.getActiveRequester() != null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        switch (this._actionId) {
            case 0: {
                obj.onAction(activeChar);
                break;
            }
            case 1: {
                if (!(activeChar.isGM() || obj.isNpc() && Config.ALT_GAME_VIEWNPC)) {
                    obj.onAction(activeChar, false);
                    break;
                }
                obj.onActionShift(activeChar);
                break;
            }
            default: {
                _log.warning(this.getType() + ": Character: " + activeChar.getName() + " requested invalid action: " + this._actionId);
                this.sendPacket(ActionFailed.STATIC_PACKET);
            }
        }
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }

    @Override
    public String getType() {
        return __C__1F_ACTION;
    }
}

