/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.SecondaryAuthData;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSelect;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharSelected;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SSQInfo;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CharacterSelect
extends L2GameClientPacket {
    private static final String _C__12_CHARACTERSELECT = "[C] 12 CharacterSelect";
    protected static final Logger _logAccounting = Logger.getLogger("accounting");
    private int _charSlot;
    private int _unk1;
    private int _unk2;
    private int _unk3;
    private int _unk4;

    @Override
    protected void readImpl() {
        this._charSlot = this.readD();
        this._unk1 = this.readH();
        this._unk2 = this.readD();
        this._unk3 = this.readD();
        this._unk4 = this.readD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2GameClient client = (L2GameClient)this.getClient();
        if (!client.getFloodProtectors().getCharacterSelect().tryPerformAction("CharacterSelect")) {
            return;
        }
        if (SecondaryAuthData.getInstance().isEnabled() && !client.getSecondaryAuth().isAuthed()) {
            client.getSecondaryAuth().openDialog();
            return;
        }
        if (client.getActiveCharLock().tryLock()) {
            try {
                if (client.getActiveChar() == null) {
                    L2PcInstance cha;
                    CharSelectInfoPackage info = client.getCharSelection(this._charSlot);
                    if (info == null) {
                        return;
                    }
                    if (PunishmentManager.getInstance().hasPunishment(info.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.BAN) || PunishmentManager.getInstance().hasPunishment(client.getAccountName(), PunishmentAffect.ACCOUNT, PunishmentType.BAN) || PunishmentManager.getInstance().hasPunishment(client.getConnectionAddress().getHostAddress(), PunishmentAffect.IP, PunishmentType.BAN)) {
                        client.close(ServerClose.STATIC_PACKET);
                        return;
                    }
                    if (info.getAccessLevel() < 0) {
                        client.close(ServerClose.STATIC_PACKET);
                        return;
                    }
                    if (Config.L2JMOD_DUALBOX_CHECK_MAX_PLAYERS_PER_IP > 0 && !AntiFeedManager.getInstance().tryAddClient(0, client, Config.L2JMOD_DUALBOX_CHECK_MAX_PLAYERS_PER_IP)) {
                        NpcHtmlMessage msg = new NpcHtmlMessage();
                        msg.setFile(info.getHtmlPrefix(), "data/html/mods/IPRestriction.htm");
                        msg.replace((CharSequence)"%max%", AntiFeedManager.getInstance().getLimit(client, Config.L2JMOD_DUALBOX_CHECK_MAX_PLAYERS_PER_IP));
                        client.sendPacket(msg);
                        return;
                    }
                    if (Config.DEBUG) {
                        _log.fine("selected slot:" + this._charSlot);
                    }
                    if ((cha = client.loadCharFromDisk(this._charSlot)) == null) {
                        return;
                    }
                    CharNameTable.getInstance().addName(cha);
                    cha.setClient(client);
                    client.setActiveChar(cha);
                    cha.setOnlineStatus(true, true);
                    TerminateReturn terminate = EventDispatcher.getInstance().notifyEvent(new OnPlayerSelect(cha, cha.getObjectId(), cha.getName(), (L2GameClient)this.getClient()), Containers.Players(), TerminateReturn.class);
                    if (terminate != null && terminate.terminate()) {
                        cha.deleteMe();
                        return;
                    }
                    this.sendPacket(new SSQInfo());
                    client.setState(L2GameClient.GameClientState.IN_GAME);
                    CharSelected cs = new CharSelected(cha, client.getSessionId().playOkID1);
                    this.sendPacket(cs);
                }
            }
            finally {
                client.getActiveCharLock().unlock();
            }
            LogRecord record = new LogRecord(Level.INFO, "Logged in");
            record.setParameters(new Object[]{client});
            _logAccounting.log(record);
        }
    }

    @Override
    public String getType() {
        return _C__12_CHARACTERSELECT;
    }
}

