/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.communitybbs.Manager.BaseBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.ClanBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.CustomBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.RegionBBSManager;
import com.l2jserver.gameserver.datatables.AdminTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.instancemanager.PetitionManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.instance.L2ClassMasterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.AbstractResidence;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Couple;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import com.l2jserver.gameserver.network.serverpackets.Die;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.network.serverpackets.ExGetBookMarkInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExNevitAdventPointInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExNevitAdventTimeChange;
import com.l2jserver.gameserver.network.serverpackets.ExNoticePostArrived;
import com.l2jserver.gameserver.network.serverpackets.ExNotifyPremiumItem;
import com.l2jserver.gameserver.network.serverpackets.ExShowContactList;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.ExVoteSystemInfo;
import com.l2jserver.gameserver.network.serverpackets.FriendList;
import com.l2jserver.gameserver.network.serverpackets.HennaInfo;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.PledgeStatusChanged;
import com.l2jserver.gameserver.network.serverpackets.QuestList;
import com.l2jserver.gameserver.network.serverpackets.ShortCutInit;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class EnterWorld
extends L2GameClientPacket {
    private static final String _C__11_ENTERWORLD = "[C] 11 EnterWorld";
    private final int[][] tracert = new int[5][4];

    @Override
    protected void readImpl() {
        this.readB(new byte[32]);
        this.readD();
        this.readD();
        this.readD();
        this.readD();
        this.readB(new byte[32]);
        this.readD();
        for (int i = 0; i < 5; ++i) {
            for (int o = 0; o < 4; ++o) {
                this.tracert[i][o] = this.readC();
            }
        }
    }

    @Override
    protected void runImpl() {
        L2ItemInstance[] contents;
        float points;
        Object fort;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            _log.warning("EnterWorld failed! activeChar returned 'null'.");
            ((L2GameClient)this.getClient()).closeNow();
            return;
        }
        String[] adress = new String[5];
        for (int i = 0; i < 5; ++i) {
            adress[i] = this.tracert[i][0] + "." + this.tracert[i][1] + "." + this.tracert[i][2] + "." + this.tracert[i][3];
        }
        LoginServerThread.getInstance().sendClientTracert(activeChar.getAccountName(), adress);
        ((L2GameClient)this.getClient()).setClientTracert(this.tracert);
        if (Config.RESTORE_PLAYER_INSTANCE) {
            activeChar.setInstanceId(InstanceManager.getInstance().getPlayerInstance(activeChar.getObjectId()));
        } else {
            int instanceId = InstanceManager.getInstance().getPlayerInstance(activeChar.getObjectId());
            if (instanceId > 0) {
                InstanceManager.getInstance().getInstance(instanceId).removePlayer(activeChar.getObjectId());
            }
        }
        if (L2World.getInstance().findObject(activeChar.getObjectId()) != null && Config.DEBUG) {
            _log.warning("User already exists in Object ID map! User " + activeChar.getName() + " is a character clone.");
        }
        if (activeChar.isGM()) {
            if (Config.GM_STARTUP_INVULNERABLE && AdminTable.getInstance().hasAccess("admin_invul", activeChar.getAccessLevel())) {
                activeChar.setIsInvul(true);
            }
            if (Config.GM_STARTUP_INVISIBLE && AdminTable.getInstance().hasAccess("admin_invisible", activeChar.getAccessLevel())) {
                activeChar.setInvisible(true);
            }
            if (Config.GM_STARTUP_SILENCE && AdminTable.getInstance().hasAccess("admin_silence", activeChar.getAccessLevel())) {
                activeChar.setSilenceMode(true);
            }
            if (Config.GM_STARTUP_DIET_MODE && AdminTable.getInstance().hasAccess("admin_diet", activeChar.getAccessLevel())) {
                activeChar.setDietMode(true);
                activeChar.refreshOverloaded();
            }
            if (Config.GM_STARTUP_AUTO_LIST && AdminTable.getInstance().hasAccess("admin_gmliston", activeChar.getAccessLevel())) {
                AdminTable.getInstance().addGm(activeChar, false);
            } else {
                AdminTable.getInstance().addGm(activeChar, true);
            }
            if (Config.GM_GIVE_SPECIAL_SKILLS) {
                SkillTreesData.getInstance().addSkills(activeChar, false);
            }
            if (Config.GM_GIVE_SPECIAL_AURA_SKILLS) {
                SkillTreesData.getInstance().addSkills(activeChar, true);
            }
        }
        if (activeChar.getCurrentHp() < 0.5) {
            activeChar.setIsDead(true);
        }
        boolean showClanNotice = false;
        if (activeChar.getClan() != null) {
            this.sendPacket(new PledgeSkillList(activeChar.getClan()));
            this.notifyClanMembers(activeChar);
            this.notifySponsorOrApprentice(activeChar);
            AuctionableHall clanHall = ClanHallManager.getInstance().getClanHallByOwner(activeChar.getClan());
            if (clanHall != null && !clanHall.getPaid()) {
                this.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.PAYMENT_FOR_YOUR_CLAN_HALL_HAS_NOT_BEEN_MADE_PLEASE_MAKE_PAYMENT_TO_YOUR_CLAN_WAREHOUSE_BY_S1_TOMORROW).addNumber(clanHall.getPaidTomorrow().get(11))));
            }
            for (Siege siege : SiegeManager.getInstance().getSieges()) {
                if (!siege.isInProgress()) continue;
                if (siege.checkIsAttacker(activeChar.getClan())) {
                    activeChar.setSiegeState((byte)1);
                    activeChar.setSiegeSide(siege.getCastle().getResidenceId());
                    continue;
                }
                if (!siege.checkIsDefender(activeChar.getClan())) continue;
                activeChar.setSiegeState((byte)2);
                activeChar.setSiegeSide(siege.getCastle().getResidenceId());
            }
            for (FortSiege fortSiege : FortSiegeManager.getInstance().getSieges()) {
                if (!fortSiege.isInProgress()) continue;
                if (fortSiege.checkIsAttacker(activeChar.getClan())) {
                    activeChar.setSiegeState((byte)1);
                    activeChar.setSiegeSide(fortSiege.getFort().getResidenceId());
                    continue;
                }
                if (!fortSiege.checkIsDefender(activeChar.getClan())) continue;
                activeChar.setSiegeState((byte)2);
                activeChar.setSiegeSide(fortSiege.getFort().getResidenceId());
            }
            for (SiegableHall siegableHall : CHSiegeManager.getInstance().getConquerableHalls().values()) {
                if (!siegableHall.isInSiege() || !siegableHall.isRegistered(activeChar.getClan())) continue;
                activeChar.setSiegeState((byte)1);
                activeChar.setSiegeSide(siegableHall.getId());
                activeChar.setIsInHideoutSiege(true);
            }
            this.sendPacket(new PledgeShowMemberListAll(activeChar.getClan(), activeChar));
            this.sendPacket(new PledgeStatusChanged(activeChar.getClan()));
            if (activeChar.getClan().getCastleId() > 0) {
                Castle castle = CastleManager.getInstance().getCastleByOwner(activeChar.getClan());
                if (castle == null) {
                    _log.warning("EnterWorld warning! " + activeChar.getName() + ".getCastleId() is " + activeChar.getClan().getCastleId() + ", getCastleByOwner(" + activeChar.getClan().getName() + ") returned NULL");
                } else {
                    castle.giveResidentialSkills(activeChar);
                }
            }
            if (activeChar.getClan().getFortId() > 0) {
                fort = FortManager.getInstance().getFortByOwner(activeChar.getClan());
                if (fort == null) {
                    _log.warning("EnterWorld warning! " + activeChar.getName() + ".getFortId() is " + activeChar.getClan().getCastleId() + ", getFortByOwner(" + activeChar.getClan().getName() + ") returned NULL");
                } else {
                    ((AbstractResidence)fort).giveResidentialSkills(activeChar);
                }
            }
            showClanNotice = activeChar.getClan().isNoticeEnabled();
        }
        if (TerritoryWarManager.getInstance().getRegisteredTerritoryId(activeChar) > 0) {
            if (TerritoryWarManager.getInstance().isTWInProgress()) {
                activeChar.setSiegeState((byte)1);
            }
            activeChar.setSiegeSide(TerritoryWarManager.getInstance().getRegisteredTerritoryId(activeChar));
        }
        if (SevenSigns.getInstance().isSealValidationPeriod() && SevenSigns.getInstance().getSealOwner(3) != 0) {
            int cabal = SevenSigns.getInstance().getPlayerCabal(activeChar.getObjectId());
            if (cabal != 0) {
                if (cabal == SevenSigns.getInstance().getSealOwner(3)) {
                    activeChar.addSkill(CommonSkill.THE_VICTOR_OF_WAR.getSkill());
                } else {
                    activeChar.addSkill(CommonSkill.THE_VANQUISHED_OF_WAR.getSkill());
                }
            }
        } else {
            activeChar.removeSkill(CommonSkill.THE_VICTOR_OF_WAR.getSkill());
            activeChar.removeSkill(CommonSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
        if (Config.ENABLE_VITALITY && Config.RECOVER_VITALITY_ON_RECONNECT && (points = Config.RATE_RECOVERY_ON_RECONNECT * (float)(System.currentTimeMillis() - activeChar.getLastAccess()) / 60000.0f) > 0.0f) {
            activeChar.updateVitalityPoints(points, false, true);
        }
        activeChar.checkRecoBonusTask();
        activeChar.checkAuraItemEquipped();
        activeChar.broadcastUserInfo();
        activeChar.getMacros().sendUpdate();
        this.sendPacket(new ItemList(activeChar, false));
        activeChar.queryGameGuard();
        this.sendPacket(new ExGetBookMarkInfoPacket(activeChar));
        this.sendPacket(new ShortCutInit(activeChar));
        this.sendPacket(ExBasicActionList.STATIC_PACKET);
        activeChar.sendSkillList();
        this.sendPacket(new HennaInfo(activeChar));
        Quest.playerEnter(activeChar);
        if (!Config.DISABLE_TUTORIAL) {
            this.loadTutorial(activeChar);
        }
        this.sendPacket(new QuestList());
        if (Config.PLAYER_SPAWN_PROTECTION > 0) {
            activeChar.setProtection(true);
        }
        activeChar.spawnMe(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        activeChar.getInventory().applyItemSkills();
        if (L2Event.isParticipant(activeChar)) {
            L2Event.restorePlayerEventStatus(activeChar);
        }
        if (Config.L2JMOD_ALLOW_WEDDING) {
            this.engage(activeChar);
            this.notifyPartner(activeChar, activeChar.getPartnerId());
        }
        if (activeChar.isCursedWeaponEquipped()) {
            CursedWeaponsManager.getInstance().getCursedWeapon(activeChar.getCursedWeaponEquippedId()).cursedOnLogin();
        }
        activeChar.updateEffectIcons();
        this.sendPacket(new EtcStatusUpdate(activeChar));
        this.sendPacket(new ExStorageMaxCount(activeChar));
        this.sendPacket(new FriendList(activeChar));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FRIEND_S1_HAS_LOGGED_IN);
        sm.addString(activeChar.getName());
        fort = activeChar.getFriendList().iterator();
        while (fort.hasNext()) {
            int n = (Integer)fort.next();
            L2Object obj = L2World.getInstance().findObject(n);
            if (obj == null) continue;
            obj.sendPacket(sm);
        }
        this.sendPacket(SystemMessageId.WELCOME_TO_LINEAGE);
        activeChar.sendMessage(this.getText("VGhpcyBTZXJ2ZXIgdXNlcyBMMkosIGEgUHJvamVjdCBmb3VuZGVkIGJ5IEwyQ2hlZg=="));
        activeChar.sendMessage(this.getText("YW5kIGRldmVsb3BlZCBieSBMMkogVGVhbSBhdCB3d3cubDJqc2VydmVyLmNvbQ=="));
        if (Config.DISPLAY_SERVER_VERSION) {
            if (Config.SERVER_VERSION != null) {
                activeChar.sendMessage(this.getText("TDJKIFNlcnZlciBWZXJzaW9uOg==") + "   " + Config.SERVER_VERSION);
            }
            if (Config.DATAPACK_VERSION != null) {
                activeChar.sendMessage(this.getText("TDJKIERhdGFQYWNrIFZlcnNpb246") + " " + Config.DATAPACK_VERSION);
            }
        }
        activeChar.sendMessage(this.getText("Q29weXJpZ2h0IDIwMDQtMjAxNA=="));
        activeChar.sendMessage(this.getText("VGhhbmsgeW91IGZvciAxMCB5ZWFycyE="));
        SevenSigns.getInstance().sendCurrentPeriodMsg(activeChar);
        Announcements.getInstance().showAnnouncements(activeChar);
        if (activeChar.getClan() != null && (contents = ClanBBSManager.getInstance().getMsgData("announce", activeChar.getClan().getId())) != null && !contents.isEmpty()) {
            NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage();
            npcHtmlMessage.setFile(activeChar.getHtmlPrefix(), "data/html/clannews.htm");
            npcHtmlMessage.replace((CharSequence)"%clan_name%", activeChar.getClan().getName());
            npcHtmlMessage.replace((CharSequence)"%contents%", BaseBBSManager.htmlescape((CharSequence)contents));
            contents = null;
            this.sendPacket(npcHtmlMessage);
        }
        if (Config.PETITIONING_ALLOWED) {
            PetitionManager.getInstance().checkPetitionMessages(activeChar);
        }
        if (activeChar.isAlikeDead()) {
            this.sendPacket(new Die(activeChar));
        }
        activeChar.onPlayerEnter();
        this.sendPacket(new SkillCoolTime(activeChar));
        this.sendPacket(new ExVoteSystemInfo(activeChar));
        this.sendPacket(new ExNevitAdventPointInfoPacket(0));
        this.sendPacket(new ExNevitAdventTimeChange(-1));
        this.sendPacket(new ExShowContactList(activeChar));
        for (L2ItemInstance i : activeChar.getInventory().getItems()) {
            if (i.isTimeLimitedItem()) {
                i.scheduleLifeTimeTask();
            }
            if (!i.isShadowItem() || !i.isEquipped()) continue;
            i.decreaseMana(false);
        }
        for (L2ItemInstance i : activeChar.getWarehouse().getItems()) {
            if (!i.isTimeLimitedItem()) continue;
            i.scheduleLifeTimeTask();
        }
        if (DimensionalRiftManager.getInstance().checkIfInRiftZone(activeChar.getX(), activeChar.getY(), activeChar.getZ(), false)) {
            DimensionalRiftManager.getInstance().teleportToWaitingRoom(activeChar);
        }
        if (activeChar.getClanJoinExpiryTime() > System.currentTimeMillis()) {
            this.sendPacket(SystemMessageId.CLAN_MEMBERSHIP_TERMINATED);
        }
        if (activeChar.getInventory().getItemByItemId(9819) != null) {
            fort = FortManager.getInstance().getFort(activeChar);
            if (fort != null) {
                FortSiegeManager.getInstance().dropCombatFlag(activeChar, ((AbstractResidence)fort).getResidenceId());
            } else {
                int n = activeChar.getInventory().getSlotFromItem(activeChar.getInventory().getItemByItemId(9819));
                activeChar.getInventory().unEquipItemInBodySlot(n);
                activeChar.destroyItem("CombatFlag", activeChar.getInventory().getItemByItemId(9819), null, true);
            }
        }
        if (!(activeChar.canOverrideCond(PcCondOverride.ZONE_CONDITIONS) || !activeChar.isInsideZone(ZoneId.SIEGE) || activeChar.isInSiege() && activeChar.getSiegeState() >= 2)) {
            activeChar.teleToLocation(TeleportWhereType.TOWN);
        }
        if (Config.ALLOW_MAIL && MailManager.getInstance().hasUnreadPost(activeChar)) {
            this.sendPacket(ExNoticePostArrived.valueOf(false));
        }
        RegionBBSManager.getInstance().changeCommunityBoard();
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(activeChar, null, 2));
        int privMsgCnt = CustomBBSManager.getInstance().getPrivateMsgCnt(activeChar);
        if (privMsgCnt > 0) {
            this.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.S1_UNREAD_MESSAGES).addNumber(privMsgCnt)));
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NEW_MAIL));
        }
        TvTEvent.onLogin(activeChar);
        if (Config.WELCOME_MESSAGE_ENABLED) {
            this.sendPacket(new ExShowScreenMessage(Config.WELCOME_MESSAGE_TEXT, Config.WELCOME_MESSAGE_TIME));
        }
        L2ClassMasterInstance.showQuestionMark(activeChar);
        int n = activeChar.checkBirthDay();
        if (n == 0) {
            this.sendPacket(SystemMessageId.YOUR_BIRTHDAY_GIFT_HAS_ARRIVED);
        } else if (n != -1) {
            this.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.THERE_ARE_S1_DAYS_UNTIL_YOUR_CHARACTERS_BIRTHDAY).addNumber(n)));
        }
        if (!activeChar.getPremiumItemList().isEmpty()) {
            this.sendPacket(ExNotifyPremiumItem.STATIC_PACKET);
        }
    }

    private void engage(L2PcInstance cha) {
        int chaId = cha.getObjectId();
        for (Couple cl : CoupleManager.getInstance().getCouples()) {
            if (cl.getPlayer1Id() != chaId && cl.getPlayer2Id() != chaId) continue;
            if (cl.getMaried()) {
                cha.setMarried(true);
            }
            cha.setCoupleId(cl.getId());
            if (cl.getPlayer1Id() == chaId) {
                cha.setPartnerId(cl.getPlayer2Id());
                continue;
            }
            cha.setPartnerId(cl.getPlayer1Id());
        }
    }

    private void notifyPartner(L2PcInstance cha, int partnerId) {
        L2PcInstance partner;
        int objId = cha.getPartnerId();
        if (objId != 0 && (partner = L2World.getInstance().getPlayer(objId)) != null) {
            partner.sendMessage("\u7d50\u5a5a\u76f8\u624b\u304c\u30ed\u30b0\u30a4\u30f3\u3057\u307e\u3057\u305f\u3002");
        }
    }

    private void notifyClanMembers(L2PcInstance activeChar) {
        L2Clan clan = activeChar.getClan();
        if (clan != null) {
            clan.getClanMember(activeChar.getObjectId()).setPlayerInstance(activeChar);
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_S1_LOGGED_IN);
            msg.addString(activeChar.getName());
            clan.broadcastToOtherOnlineMembers(msg, activeChar);
            clan.broadcastToOtherOnlineMembers(new PledgeShowMemberListUpdate(activeChar), activeChar);
        }
    }

    private void notifySponsorOrApprentice(L2PcInstance activeChar) {
        L2PcInstance apprentice;
        if (activeChar.getSponsor() != 0) {
            L2PcInstance sponsor = L2World.getInstance().getPlayer(activeChar.getSponsor());
            if (sponsor != null) {
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOUR_APPRENTICE_S1_HAS_LOGGED_IN);
                msg.addString(activeChar.getName());
                sponsor.sendPacket(msg);
            }
        } else if (activeChar.getApprentice() != 0 && (apprentice = L2World.getInstance().getPlayer(activeChar.getApprentice())) != null) {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOUR_SPONSOR_C1_HAS_LOGGED_IN);
            msg.addString(activeChar.getName());
            apprentice.sendPacket(msg);
        }
    }

    private String getText(String string) {
        return new String(Base64.getDecoder().decode(string), StandardCharsets.UTF_8);
    }

    private void loadTutorial(L2PcInstance player) {
        QuestState qs = player.getQuestState("255_Tutorial");
        if (qs != null) {
            qs.getQuest().notifyEvent("UC", null, player);
        }
    }

    @Override
    public String getType() {
        return _C__11_ENTERWORLD;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

