/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.enums.IllegalActionPunishmentType;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2FishermanInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2VillageMasterInstance;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSkillLearn;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillDone;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.List;

public final class RequestAcquireSkill
extends L2GameClientPacket {
    private static final String _C__7C_REQUESTACQUIRESKILL = "[C] 7C RequestAcquireSkill";
    private static final String[] QUEST_VAR_NAMES = new String[]{"EmergentAbility65-", "EmergentAbility70-", "ClassAbility75-", "ClassAbility80-"};
    private int _id;
    private int _level;
    private AcquireSkillType _skillType;
    private int _subType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = AcquireSkillType.getAcquireSkillType(this.readD());
        if (this._skillType == AcquireSkillType.SUBPLEDGE) {
            this._subType = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        L2SkillLearn s;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._level < 1 || this._level > 1000 || this._id < 1 || this._id > 32000) {
            Util.handleIllegalPlayerAction(activeChar, "Wrong Packet Data in Aquired Skill", Config.DEFAULT_PUNISH);
            _log.warning("Recived Wrong Packet Data in Aquired Skill - id: " + this._id + " level: " + this._level + " for " + activeChar);
            return;
        }
        L2Npc trainer = activeChar.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(activeChar) && !activeChar.isGM()) {
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(this._id, this._level);
        if (skill == null) {
            _log.warning(RequestAcquireSkill.class.getSimpleName() + ": Player " + activeChar.getName() + " is trying to learn a null skill Id: " + this._id + " level: " + this._level + "!");
            return;
        }
        int prevSkillLevel = activeChar.getSkillLevel(this._id);
        if (prevSkillLevel > 0 && this._skillType != AcquireSkillType.TRANSFER && this._skillType != AcquireSkillType.SUBPLEDGE) {
            if (prevSkillLevel == this._level) {
                _log.warning("Player " + activeChar.getName() + " is trying to learn a skill that already knows, Id: " + this._id + " level: " + this._level + "!");
                return;
            }
            if (prevSkillLevel != this._level - 1) {
                activeChar.sendPacket(SystemMessageId.PREVIOUS_LEVEL_SKILL_NOT_LEARNED);
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!", IllegalActionPunishmentType.NONE);
                return;
            }
        }
        if ((s = SkillTreesData.getInstance().getSkillLearn(this._skillType, this._id, this._level, activeChar)) == null) {
            return;
        }
        switch (this._skillType) {
            case CLASS: {
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case TRANSFORM: {
                if (!RequestAcquireSkill.canTransform(activeChar)) {
                    activeChar.sendPacket(SystemMessageId.NOT_COMPLETED_QUEST_FOR_SKILL_ACQUISITION);
                    Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without required quests!", IllegalActionPunishmentType.NONE);
                    return;
                }
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case FISHING: {
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case PLEDGE: {
                if (!activeChar.isClanLeader()) {
                    return;
                }
                L2Clan clan = activeChar.getClan();
                int repCost = s.getLevelUpSp();
                if (clan.getReputationScore() >= repCost) {
                    if (Config.LIFE_CRYSTAL_NEEDED) {
                        for (ItemHolder item : s.getRequiredItems()) {
                            if (!activeChar.destroyItemByItemId("Consume", item.getId(), item.getCount(), trainer, false)) {
                                activeChar.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                                L2VillageMasterInstance.showPledgeSkillList(activeChar);
                                return;
                            }
                            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                            sm.addItemName(item.getId());
                            sm.addItemNumber(item.getCount());
                            activeChar.sendPacket(sm);
                        }
                    }
                    clan.takeReputationScore(repCost, true);
                    SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                    cr.addInt(repCost);
                    activeChar.sendPacket(cr);
                    clan.addNewSkill(skill);
                    clan.broadcastToOnlineMembers(new PledgeSkillList(clan));
                    activeChar.sendPacket(new AcquireSkillDone());
                    L2VillageMasterInstance.showPledgeSkillList(activeChar);
                    break;
                }
                activeChar.sendPacket(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE);
                L2VillageMasterInstance.showPledgeSkillList(activeChar);
                break;
            }
            case SUBPLEDGE: {
                if (!activeChar.isClanLeader() || !activeChar.hasClanPrivilege(ClanPrivilege.CL_TROOPS_FAME)) {
                    return;
                }
                L2Clan clan = activeChar.getClan();
                if (clan.getFortId() == 0 && clan.getCastleId() == 0) {
                    return;
                }
                if (!clan.isLearnableSubPledgeSkill(skill, this._subType)) {
                    activeChar.sendPacket(SystemMessageId.SQUAD_SKILL_ALREADY_ACQUIRED);
                    Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!", IllegalActionPunishmentType.NONE);
                    return;
                }
                int repCost = s.getLevelUpSp();
                if (clan.getReputationScore() < repCost) {
                    activeChar.sendPacket(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE);
                    return;
                }
                for (ItemHolder item : s.getRequiredItems()) {
                    if (!activeChar.destroyItemByItemId("SubSkills", item.getId(), item.getCount(), trainer, false)) {
                        activeChar.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                        return;
                    }
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(item.getId());
                    sm.addItemNumber(item.getCount());
                    activeChar.sendPacket(sm);
                }
                if (repCost > 0) {
                    clan.takeReputationScore(repCost, true);
                    SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                    cr.addInt(repCost);
                    activeChar.sendPacket(cr);
                }
                clan.addNewSkill(skill, this._subType);
                clan.broadcastToOnlineMembers(new PledgeSkillList(clan));
                activeChar.sendPacket(new AcquireSkillDone());
                RequestAcquireSkill.showSubUnitSkillList(activeChar);
                break;
            }
            case TRANSFER: {
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case SUBCLASS: {
                if (activeChar.isSubClassActive()) {
                    activeChar.sendPacket(SystemMessageId.SKILL_NOT_FOR_SUBCLASS);
                    Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " while Sub-Class is active!", IllegalActionPunishmentType.NONE);
                    return;
                }
                if (prevSkillLevel == -1 && this._level > 1) {
                    activeChar.sendPacket(SystemMessageId.PREVIOUS_LEVEL_SKILL_NOT_LEARNED);
                    Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!", IllegalActionPunishmentType.NONE);
                    return;
                }
                QuestState st = activeChar.getQuestState("SubClassSkills");
                if (st == null) {
                    Quest subClassSkilllsQuest = QuestManager.getInstance().getQuest("SubClassSkills");
                    if (subClassSkilllsQuest != null) {
                        st = subClassSkilllsQuest.newQuestState(activeChar);
                    } else {
                        _log.warning("Null SubClassSkills quest, for Sub-Class skill Id: " + this._id + " level: " + this._level + " for player " + activeChar.getName() + "!");
                        return;
                    }
                }
                for (String varName : QUEST_VAR_NAMES) {
                    for (int i = 1; i <= Config.MAX_SUBCLASS; ++i) {
                        String itemOID = st.getGlobalQuestVar(varName + i);
                        if (itemOID.isEmpty() || itemOID.endsWith(";") || itemOID.equals("0")) continue;
                        if (Util.isDigit(itemOID)) {
                            int itemObjId = Integer.parseInt(itemOID);
                            L2ItemInstance item = activeChar.getInventory().getItemByObjectId(itemObjId);
                            if (item != null) {
                                for (ItemHolder itemIdCount : s.getRequiredItems()) {
                                    if (item.getId() != itemIdCount.getId()) continue;
                                    if (this.checkPlayerSkill(activeChar, trainer, s)) {
                                        this.giveSkill(activeChar, trainer, skill);
                                        st.saveGlobalQuestVar(varName + i, skill.getId() + ";");
                                    }
                                    return;
                                }
                                continue;
                            }
                            _log.warning("Inexistent item for object Id " + itemObjId + ", for Sub-Class skill Id: " + this._id + " level: " + this._level + " for player " + activeChar.getName() + "!");
                            continue;
                        }
                        _log.warning("Invalid item object Id " + itemOID + ", for Sub-Class skill Id: " + this._id + " level: " + this._level + " for player " + activeChar.getName() + "!");
                    }
                }
                activeChar.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                this.showSkillList(trainer, activeChar);
                break;
            }
            case COLLECT: {
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            default: {
                _log.warning("Recived Wrong Packet Data in Aquired Skill, unknown skill type:" + (Object)((Object)this._skillType));
            }
        }
    }

    public static void showSubUnitSkillList(L2PcInstance activeChar) {
        List<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableSubPledgeSkills(activeChar.getClan());
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillType.SUBPLEDGE);
        int count = 0;
        for (L2SkillLearn s : skills) {
            if (SkillData.getInstance().getSkill(s.getSkillId(), s.getSkillLevel()) == null) continue;
            asl.addSkill(s.getSkillId(), s.getSkillLevel(), s.getSkillLevel(), s.getLevelUpSp(), 0);
            ++count;
        }
        if (count == 0) {
            activeChar.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
        } else {
            activeChar.sendPacket(asl);
        }
    }

    private boolean checkPlayerSkill(L2PcInstance player, L2Npc trainer, L2SkillLearn s) {
        if (s != null && s.getSkillId() == this._id && s.getSkillLevel() == this._level) {
            if (s.getGetLevel() > player.getLevel()) {
                player.sendPacket(SystemMessageId.YOU_DONT_MEET_SKILL_LEVEL_REQUIREMENTS);
                Util.handleIllegalPlayerAction(player, "Player " + player.getName() + ", level " + player.getLevel() + " is requesting skill Id: " + this._id + " level " + this._level + " without having minimum required level, " + s.getGetLevel() + "!", IllegalActionPunishmentType.NONE);
                return false;
            }
            int levelUpSp = s.getCalculatedLevelUpSp(player.getClassId(), player.getLearningClass());
            if (levelUpSp > 0 && levelUpSp > player.getSp()) {
                player.sendPacket(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL);
                this.showSkillList(trainer, player);
                return false;
            }
            if (!Config.DIVINE_SP_BOOK_NEEDED && this._id == CommonSkill.DIVINE_INSPIRATION.getId()) {
                return true;
            }
            if (!s.getPreReqSkills().isEmpty()) {
                for (SkillHolder skill : s.getPreReqSkills()) {
                    if (player.getSkillLevel(skill.getSkillId()) == skill.getSkillLvl()) continue;
                    if (skill.getSkillId() == CommonSkill.ONYX_BEAST_TRANSFORMATION.getId()) {
                        player.sendPacket(SystemMessageId.YOU_MUST_LEARN_ONYX_BEAST_SKILL);
                    } else {
                        player.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                    }
                    return false;
                }
            }
            if (!s.getRequiredItems().isEmpty()) {
                long reqItemCount = 0L;
                for (ItemHolder item : s.getRequiredItems()) {
                    reqItemCount = player.getInventory().getInventoryItemCount(item.getId(), -1);
                    if (reqItemCount >= item.getCount()) continue;
                    player.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                    this.showSkillList(trainer, player);
                    return false;
                }
                for (ItemHolder itemIdCount : s.getRequiredItems()) {
                    if (player.destroyItemByItemId("SkillLearn", itemIdCount.getId(), itemIdCount.getCount(), trainer, true)) continue;
                    Util.handleIllegalPlayerAction(player, "Somehow player " + player.getName() + ", level " + player.getLevel() + " lose required item Id: " + itemIdCount.getId() + " to learn skill while learning skill Id: " + this._id + " level " + this._level + "!", IllegalActionPunishmentType.NONE);
                }
            }
            if (levelUpSp > 0) {
                player.setSp(player.getSp() - levelUpSp);
                StatusUpdate su = new StatusUpdate(player);
                su.addAttribute(13, player.getSp());
                player.sendPacket(su);
            }
            return true;
        }
        return false;
    }

    private void giveSkill(L2PcInstance player, L2Npc trainer, Skill skill) {
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.LEARNED_SKILL_S1);
        sm.addSkillName(skill);
        player.sendPacket(sm);
        player.sendPacket(new AcquireSkillDone());
        player.addSkill(skill, true);
        player.sendSkillList();
        player.updateShortCuts(this._id, this._level);
        this.showSkillList(trainer, player);
        if (this._id >= 1368 && this._id <= 1372) {
            player.sendPacket(new ExStorageMaxCount(player));
        }
        EventDispatcher.getInstance().notifyEventAsync(new OnPlayerSkillLearn(trainer, player, skill, this._skillType), trainer);
    }

    private void showSkillList(L2Npc trainer, L2PcInstance player) {
        if (this._skillType == AcquireSkillType.TRANSFORM || this._skillType == AcquireSkillType.SUBCLASS || this._skillType == AcquireSkillType.TRANSFER) {
            return;
        }
        if (trainer instanceof L2FishermanInstance) {
            L2FishermanInstance.showFishSkillList(player);
        } else {
            L2NpcInstance.showSkillList(player, trainer, player.getLearningClass());
        }
    }

    public static boolean canTransform(L2PcInstance player) {
        if (Config.ALLOW_TRANSFORM_WITHOUT_QUEST) {
            return true;
        }
        QuestState st = player.getQuestState("Q00136_MoreThanMeetsTheEye");
        return st != null && st.isCompleted();
    }

    @Override
    public String getType() {
        return _C__7C_REQUESTACQUIRESKILL;
    }
}

