/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBaseAttributeCancelResult;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;

public class RequestExRemoveItemAttribute
extends L2GameClientPacket {
    private static String _C__D0_23_REQUESTEXREMOVEITEMATTRIBUTE = "[C] D0:23 RequestExRemoveItemAttribute";
    private int _objectId;
    private long _price;
    private byte _element;

    @Override
    public void readImpl() {
        this._objectId = this.readD();
        this._element = (byte)this.readD();
    }

    @Override
    public void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2ItemInstance targetItem = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (targetItem == null) {
            return;
        }
        if (targetItem.getElementals() == null || targetItem.getElemental(this._element) == null) {
            return;
        }
        if (activeChar.reduceAdena("RemoveElement", this.getPrice(targetItem), activeChar, true)) {
            SystemMessage sm;
            byte realElement;
            if (targetItem.isEquipped()) {
                targetItem.getElemental(this._element).removeBonus(activeChar);
            }
            targetItem.clearElementAttr(this._element);
            activeChar.sendPacket(new UserInfo(activeChar));
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(targetItem);
            activeChar.sendPacket(iu);
            byte by = realElement = targetItem.isArmor() ? Elementals.getOppositeElement(this._element) : this._element;
            if (targetItem.getEnchantLevel() > 0) {
                sm = targetItem.isArmor() ? SystemMessage.getSystemMessage(SystemMessageId.S1_S2_S3_ATTRIBUTE_REMOVED_RESISTANCE_TO_S4_DECREASED) : SystemMessage.getSystemMessage(SystemMessageId.S1_S2_ELEMENTAL_POWER_REMOVED);
                sm.addInt(targetItem.getEnchantLevel());
                sm.addItemName(targetItem);
                if (targetItem.isArmor()) {
                    sm.addElemental(realElement);
                    sm.addElemental(Elementals.getOppositeElement(realElement));
                }
            } else {
                sm = targetItem.isArmor() ? SystemMessage.getSystemMessage(SystemMessageId.S1_S2_ATTRIBUTE_REMOVED_RESISTANCE_S3_DECREASED) : SystemMessage.getSystemMessage(SystemMessageId.S1_ELEMENTAL_POWER_REMOVED);
                sm.addItemName(targetItem);
                if (targetItem.isArmor()) {
                    sm.addElemental(realElement);
                    sm.addElemental(Elementals.getOppositeElement(realElement));
                }
            }
            activeChar.sendPacket(sm);
            activeChar.sendPacket(new ExBaseAttributeCancelResult(targetItem.getObjectId(), this._element));
        } else {
            activeChar.sendPacket(SystemMessageId.YOU_DO_NOT_HAVE_ENOUGH_FUNDS_TO_CANCEL_ATTRIBUTE);
        }
    }

    private long getPrice(L2ItemInstance item) {
        switch (item.getItem().getCrystalType()) {
            case S: {
                if (item.getItem() instanceof L2Weapon) {
                    this._price = 50000L;
                    break;
                }
                this._price = 40000L;
                break;
            }
            case S80: {
                if (item.getItem() instanceof L2Weapon) {
                    this._price = 100000L;
                    break;
                }
                this._price = 80000L;
                break;
            }
            case S84: {
                this._price = item.getItem() instanceof L2Weapon ? 200000L : 160000L;
            }
        }
        return this._price;
    }

    @Override
    public String getType() {
        return _C__D0_23_REQUESTEXREMOVEITEMATTRIBUTE;
    }
}

