/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.EnchantItemData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.enchant.EnchantScroll;
import com.l2jserver.gameserver.model.items.enchant.EnchantSupportItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExPutEnchantSupportItemResult;

public class RequestExTryToPutEnchantSupportItem
extends L2GameClientPacket {
    private static final String _C__D0_4D_REQUESTEXTRYTOPUTENCHANTSUPPORTITEM = "[C] D0:4D RequestExTryToPutEnchantSupportItem";
    private int _supportObjectId;
    private int _enchantObjectId;

    @Override
    protected void readImpl() {
        this._supportObjectId = this.readD();
        this._enchantObjectId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isEnchanting()) {
            L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._enchantObjectId);
            L2ItemInstance scroll = activeChar.getInventory().getItemByObjectId(activeChar.getActiveEnchantItemId());
            L2ItemInstance support = activeChar.getInventory().getItemByObjectId(this._supportObjectId);
            if (item == null || scroll == null || support == null) {
                activeChar.sendPacket(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION);
                activeChar.setActiveEnchantSupportItemId(-1);
                return;
            }
            EnchantScroll scrollTemplate = EnchantItemData.getInstance().getEnchantScroll(scroll);
            EnchantSupportItem supportTemplate = EnchantItemData.getInstance().getSupportItem(support);
            if (scrollTemplate == null || supportTemplate == null || !scrollTemplate.isValid(item, supportTemplate)) {
                activeChar.sendPacket(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION);
                activeChar.setActiveEnchantSupportItemId(-1);
                activeChar.sendPacket(new ExPutEnchantSupportItemResult(0));
                return;
            }
            activeChar.setActiveEnchantSupportItemId(support.getObjectId());
            activeChar.sendPacket(new ExPutEnchantSupportItemResult(this._supportObjectId));
        }
    }

    @Override
    public String getType() {
        return _C__D0_4D_REQUESTEXTRYTOPUTENCHANTSUPPORTITEM;
    }
}

