/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.FriendAddRequest;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestFriendInvite
extends L2GameClientPacket {
    private static final String _C__77_REQUESTFRIENDINVITE = "[C] 77 RequestFriendInvite";
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2PcInstance friend = L2World.getInstance().getPlayer(this._name);
        if (friend == null || !friend.isOnline() || friend.isInvisible()) {
            activeChar.sendPacket(SystemMessageId.THE_USER_YOU_REQUESTED_IS_NOT_IN_GAME);
            return;
        }
        if (friend == activeChar) {
            activeChar.sendPacket(SystemMessageId.YOU_CANNOT_ADD_YOURSELF_TO_OWN_FRIEND_LIST);
            return;
        }
        if (activeChar.isInOlympiadMode() || friend.isInOlympiadMode()) {
            activeChar.sendPacket(SystemMessageId.A_USER_CURRENTLY_PARTICIPATING_IN_THE_OLYMPIAD_CANNOT_SEND_PARTY_AND_FRIEND_INVITATIONS);
            return;
        }
        if (BlockList.isBlocked(friend, activeChar)) {
            activeChar.sendMessage("You are in target's block list.");
            return;
        }
        if (BlockList.isBlocked(activeChar, friend)) {
            activeChar.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.BLOCKED_C1).addPcName(friend)));
            return;
        }
        if (activeChar.getFriendList().contains(friend.getObjectId())) {
            activeChar.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.S1_ALREADY_IN_FRIENDS_LIST).addString(this._name)));
            return;
        }
        if (friend.isProcessingRequest()) {
            activeChar.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER).addString(this._name)));
            return;
        }
        activeChar.onTransactionRequest(friend);
        friend.sendPacket(new FriendAddRequest(activeChar.getName()));
        activeChar.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.YOU_REQUESTED_C1_TO_BE_FRIEND).addString(this._name)));
    }

    @Override
    public String getType() {
        return _C__77_REQUESTFRIENDINVITE;
    }
}

