/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.HennaData;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Henna;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.util.Util;

public final class RequestHennaEquip
extends L2GameClientPacket {
    private static final String _C__6F_REQUESTHENNAEQUIP = "[C] 6F RequestHennaEquip";
    private int _symbolId;

    @Override
    protected void readImpl() {
        this._symbolId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("HennaEquip")) {
            return;
        }
        if (activeChar.getHennaEmptySlots() == 0) {
            activeChar.sendPacket(SystemMessageId.SYMBOLS_FULL);
            this.sendActionFailed();
            return;
        }
        L2Henna henna = HennaData.getInstance().getHenna(this._symbolId);
        if (henna == null) {
            _log.warning(((Object)((Object)this)).getClass().getName() + ": Invalid Henna Id: " + this._symbolId + " from player " + activeChar);
            this.sendActionFailed();
            return;
        }
        long _count = activeChar.getInventory().getInventoryItemCount(henna.getDyeItemId(), -1);
        if (henna.isAllowedClass(activeChar.getClassId()) && _count >= (long)henna.getWearCount() && activeChar.getAdena() >= (long)henna.getWearFee() && activeChar.addHenna(henna)) {
            activeChar.destroyItemByItemId("Henna", henna.getDyeItemId(), henna.getWearCount(), activeChar, true);
            activeChar.getInventory().reduceAdena("Henna", henna.getWearFee(), activeChar, activeChar.getLastFolkNPC());
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(activeChar.getInventory().getAdenaInstance());
            activeChar.sendPacket(iu);
            activeChar.sendPacket(SystemMessageId.SYMBOL_ADDED);
        } else {
            activeChar.sendPacket(SystemMessageId.CANT_DRAW_SYMBOL);
            if (!activeChar.canOverrideCond(PcCondOverride.ITEM_CONDITIONS) && !henna.isAllowedClass(activeChar.getClassId())) {
                Util.handleIllegalPlayerAction(activeChar, "Exploit attempt: Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tryed to add a forbidden henna.", Config.DEFAULT_PUNISH);
            }
            this.sendActionFailed();
        }
    }

    @Override
    public String getType() {
        return _C__6F_REQUESTHENNAEQUIP;
    }
}

