/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;

public final class RequestPetGetItem
extends L2GameClientPacket {
    private static final String _C__98_REQUESTPETGETITEM = "[C] 98 RequestPetGetItem";
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2World world = L2World.getInstance();
        L2ItemInstance item = (L2ItemInstance)world.findObject(this._objectId);
        if (item == null || this.getActiveChar() == null || !this.getActiveChar().hasPet()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        int castleId = MercTicketManager.getInstance().getTicketCastleId(item.getId());
        if (castleId > 0) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (FortSiegeManager.getInstance().isCombat(item.getId())) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2PetInstance pet = (L2PetInstance)((L2GameClient)this.getClient()).getActiveChar().getSummon();
        if (pet.isDead() || pet.isOutOfControl()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (pet.isUncontrollable()) {
            this.sendPacket(SystemMessageId.WHEN_YOUR_PETS_HUNGER_GAUGE_IS_AT_0_YOU_CANNOT_USE_YOUR_PET);
            return;
        }
        pet.getAI().setIntention(CtrlIntention.AI_INTENTION_PICK_UP, item);
    }

    @Override
    public String getType() {
        return _C__98_REQUESTPETGETITEM;
    }
}

