/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.UniqueItemHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.List;

public class RequestProcureCropList
extends L2GameClientPacket {
    private static final int BATCH_LENGTH = 20;
    private List<CropHolder> _items = null;

    @Override
    protected final void readImpl() {
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 20 != this._buf.remaining()) {
            return;
        }
        this._items = new ArrayList<CropHolder>(count);
        for (int i = 0; i < count; ++i) {
            int objId = this.readD();
            int itemId = this.readD();
            int manorId = this.readD();
            long cnt = this.readQ();
            if (objId < 1 || itemId < 1 || manorId < 0 || cnt < 0L) {
                this._items = null;
                return;
            }
            this._items.add(new CropHolder(objId, itemId, cnt, manorId));
        }
    }

    @Override
    protected final void runImpl() {
        if (this._items == null) {
            return;
        }
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        CastleManorManager manor = CastleManorManager.getInstance();
        if (manor.isUnderMaintenance()) {
            this.sendActionFailed();
            return;
        }
        L2Npc manager = player.getLastFolkNPC();
        if (!(manager instanceof L2MerchantInstance) || !manager.canInteract(player)) {
            this.sendActionFailed();
            return;
        }
        int castleId = manager.getCastle().getResidenceId();
        if (manager.getTemplate().getParameters().getInt("manor_id", -1) != castleId) {
            this.sendActionFailed();
            return;
        }
        int slots = 0;
        int weight = 0;
        for (CropHolder i : this._items) {
            L2ItemInstance item = player.getInventory().getItemByObjectId(i.getObjectId());
            if (item == null || item.getCount() < i.getCount() || item.getId() != i.getId()) {
                this.sendActionFailed();
                return;
            }
            CropProcure cp = i.getCropProcure();
            if (cp == null || cp.getAmount() < i.getCount()) {
                this.sendActionFailed();
                return;
            }
            L2Item template = ItemTable.getInstance().getTemplate(i.getRewardId());
            weight = (int)((long)weight + i.getCount() * (long)template.getWeight());
            if (!template.isStackable()) {
                slots = (int)((long)slots + i.getCount());
                continue;
            }
            if (player.getInventory().getItemByItemId(i.getRewardId()) != null) continue;
            ++slots;
        }
        if (!player.getInventory().validateWeight(weight)) {
            player.sendPacket(SystemMessageId.WEIGHT_LIMIT_EXCEEDED);
            return;
        }
        if (!player.getInventory().validateCapacity(slots)) {
            player.sendPacket(SystemMessageId.SLOTS_FULL);
            return;
        }
        int updateListSize = Config.ALT_MANOR_SAVE_ALL_ACTIONS ? this._items.size() : 0;
        ArrayList<CropProcure> updateList = new ArrayList<CropProcure>(updateListSize);
        for (CropHolder i : this._items) {
            long fee;
            long rewardPrice = ItemTable.getInstance().getTemplate(i.getRewardId()).getReferencePrice();
            if (rewardPrice == 0L) continue;
            long rewardItemCount = i.getPrice() / rewardPrice;
            if (rewardItemCount < 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FAILED_IN_TRADING_S2_OF_CROP_S1);
                sm.addItemName(i.getId());
                sm.addItemNumber(i.getCount());
                player.sendPacket(sm);
                continue;
            }
            long l = fee = castleId == i.getManorId() ? 0L : (long)((double)i.getPrice() * 0.05);
            if (fee != 0L && player.getAdena() < fee) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FAILED_IN_TRADING_S2_OF_CROP_S1);
                sm.addItemName(i.getId());
                sm.addItemNumber(i.getCount());
                player.sendPacket(sm);
                sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
                player.sendPacket(sm);
                continue;
            }
            CropProcure cp = i.getCropProcure();
            if (!cp.decreaseAmount(i.getCount()) || fee > 0L && !player.reduceAdena("Manor", fee, manager, true) || !player.destroyItem("Manor", i.getObjectId(), i.getCount(), (L2Object)manager, true)) continue;
            player.addItem("Manor", i.getRewardId(), rewardItemCount, manager, true);
            if (!Config.ALT_MANOR_SAVE_ALL_ACTIONS) continue;
            updateList.add(cp);
        }
        if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
            manor.updateCurrentProcure(castleId, updateList);
        }
    }

    @Override
    public String getType() {
        return "[C] D0:02 RequestProcureCropList";
    }

    private final class CropHolder
    extends UniqueItemHolder {
        private final int _manorId;
        private CropProcure _cp;
        private int _rewardId;

        public CropHolder(int objectId, int id, long count, int manorId) {
            super(id, objectId, count);
            this._rewardId = 0;
            this._manorId = manorId;
        }

        public final int getManorId() {
            return this._manorId;
        }

        public final long getPrice() {
            return this.getCount() * this._cp.getPrice();
        }

        public final CropProcure getCropProcure() {
            if (this._cp == null) {
                this._cp = CastleManorManager.getInstance().getCropProcure(this._manorId, this.getId(), false);
            }
            return this._cp;
        }

        public final int getRewardId() {
            if (this._rewardId == 0) {
                this._rewardId = CastleManorManager.getInstance().getSeedByCrop(this._cp.getId()).getReward(this._cp.getReward());
            }
            return this._rewardId;
        }
    }
}

