/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.RecipeController;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestRecipeShopMakeItem
extends L2GameClientPacket {
    private static final String _C__BF_REQUESTRECIPESHOPMAKEITEM = "[C] BF RequestRecipeShopMakeItem";
    private int _id;
    private int _recipeId;
    private long _unknow;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._recipeId = this.readD();
        this._unknow = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getManufacture().tryPerformAction("RecipeShopMake")) {
            return;
        }
        L2PcInstance manufacturer = L2World.getInstance().getPlayer(this._id);
        if (manufacturer == null) {
            return;
        }
        if (manufacturer.getInstanceId() != activeChar.getInstanceId() && activeChar.getInstanceId() != -1) {
            return;
        }
        if (activeChar.getPrivateStoreType() != PrivateStoreType.NONE || activeChar.isInCraftMode()) {
            activeChar.sendPacket(SystemMessageId.CLOSE_STORE_WINDOW_AND_TRY_AGAIN);
            return;
        }
        if (manufacturer.getPrivateStoreType() != PrivateStoreType.MANUFACTURE || manufacturer.isInCraftMode()) {
            activeChar.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER).addPcName(manufacturer)));
            return;
        }
        if (Util.checkIfInRange(150, activeChar, manufacturer, true)) {
            RecipeController.getInstance().requestManufactureItem(manufacturer, this._recipeId, activeChar);
        }
    }

    @Override
    public String getType() {
        return _C__BF_REQUESTRECIPESHOPMAKEITEM;
    }
}

