/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.ArrayList;
import java.util.List;

public final class RequestSetCrop
extends L2GameClientPacket {
    private static final int BATCH_LENGTH = 21;
    private int _manorId;
    private List<CropProcure> _items;

    @Override
    protected void readImpl() {
        this._manorId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 21 != this._buf.remaining()) {
            return;
        }
        this._items = new ArrayList<CropProcure>(count);
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            long sales = this.readQ();
            long price = this.readQ();
            int type = this.readC();
            if (itemId < 1 || sales < 0L || price < 0L) {
                this._items.clear();
                return;
            }
            if (sales <= 0L) continue;
            this._items.add(new CropProcure(itemId, sales, type, sales, price));
        }
    }

    @Override
    protected void runImpl() {
        if (this._items.isEmpty()) {
            return;
        }
        CastleManorManager manor = CastleManorManager.getInstance();
        if (!manor.isModifiablePeriod()) {
            this.sendActionFailed();
            return;
        }
        L2PcInstance player = this.getActiveChar();
        if (player == null || player.getClan() == null || player.getClan().getCastleId() != this._manorId || !player.hasClanPrivilege(ClanPrivilege.CS_MANOR_ADMIN) || !player.getLastFolkNPC().canInteract(player)) {
            this.sendActionFailed();
            return;
        }
        ArrayList<CropProcure> list = new ArrayList<CropProcure>(this._items.size());
        for (CropProcure cp : this._items) {
            L2Seed s = manor.getSeedByCrop(cp.getId(), this._manorId);
            if (s == null || cp.getStartAmount() > (long)s.getCropLimit() || cp.getPrice() < (long)s.getCropMinPrice() || cp.getPrice() > (long)s.getCropMaxPrice()) continue;
            list.add(cp);
        }
        manor.setNextCropProcure(list, this._manorId);
    }

    @Override
    public String getType() {
        return "[C] D0:04 RequestSetCrop";
    }
}

