/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.ArrayList;
import java.util.List;

public class RequestSetSeed
extends L2GameClientPacket {
    private static final int BATCH_LENGTH = 20;
    private int _manorId;
    private List<SeedProduction> _items;

    @Override
    protected void readImpl() {
        this._manorId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 20 != this._buf.remaining()) {
            return;
        }
        this._items = new ArrayList<SeedProduction>(count);
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            long sales = this.readQ();
            long price = this.readQ();
            if (itemId < 1 || sales < 0L || price < 0L) {
                this._items.clear();
                return;
            }
            if (sales <= 0L) continue;
            this._items.add(new SeedProduction(itemId, sales, price, sales));
        }
    }

    @Override
    protected void runImpl() {
        if (this._items.isEmpty()) {
            return;
        }
        CastleManorManager manor = CastleManorManager.getInstance();
        if (!manor.isModifiablePeriod()) {
            this.sendActionFailed();
            return;
        }
        L2PcInstance player = this.getActiveChar();
        if (player == null || player.getClan() == null || player.getClan().getCastleId() != this._manorId || !player.hasClanPrivilege(ClanPrivilege.CS_MANOR_ADMIN) || !player.getLastFolkNPC().canInteract(player)) {
            this.sendActionFailed();
            return;
        }
        ArrayList<SeedProduction> list = new ArrayList<SeedProduction>(this._items.size());
        for (SeedProduction sp : this._items) {
            L2Seed s = manor.getSeed(sp.getId());
            if (s == null || sp.getStartAmount() > (long)s.getSeedLimit() || sp.getPrice() < (long)s.getSeedMinPrice() || sp.getPrice() > (long)s.getSeedMaxPrice()) continue;
            list.add(sp);
        }
        manor.setNextSeedProduction(list, this._manorId);
    }

    @Override
    public String getType() {
        return "[C] D0:03 RequestSetSeed";
    }
}

