/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestStartPledgeWar
extends L2GameClientPacket {
    private static final String _C__03_REQUESTSTARTPLEDGEWAR = "[C] 03 RequestStartPledgewar";
    private String _pledgeName;
    private L2Clan _clan;
    private L2PcInstance player;

    @Override
    protected void readImpl() {
        this._pledgeName = this.readS();
    }

    @Override
    protected void runImpl() {
        this.player = ((L2GameClient)this.getClient()).getActiveChar();
        if (this.player == null) {
            return;
        }
        this._clan = ((L2GameClient)this.getClient()).getActiveChar().getClan();
        if (this._clan == null) {
            return;
        }
        if (this._clan.getLevel() < 3 || this._clan.getMembersCount() < Config.ALT_CLAN_MEMBERS_FOR_WAR) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_IF_CLAN_LVL3_OR_15_MEMBER);
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            sm = null;
            return;
        }
        if (!this.player.hasClanPrivilege(ClanPrivilege.CL_PLEDGE_WAR)) {
            this.player.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._pledgeName);
        if (clan == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_CANNOT_DECLARED_CLAN_NOT_EXIST);
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (this._clan.getAllyId() == clan.getAllyId() && this._clan.getAllyId() != 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_AGAINST_A_ALLIED_CLAN_NOT_WORK);
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            sm = null;
            return;
        }
        if (clan.getLevel() < 3 || clan.getMembersCount() < Config.ALT_CLAN_MEMBERS_FOR_WAR) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_IF_CLAN_LVL3_OR_15_MEMBER);
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            sm = null;
            return;
        }
        if (this._clan.isAtWarWith(clan.getId())) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.ALREADY_AT_WAR_WITH_S1_WAIT_5_DAYS);
            sm.addString(clan.getName());
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            sm = null;
            return;
        }
        ClanTable.getInstance().storeclanswars(this.player.getClanId(), clan.getId());
        for (L2PcInstance member : this._clan.getOnlineMembers(0)) {
            member.broadcastUserInfo();
        }
        for (L2PcInstance member : clan.getOnlineMembers(0)) {
            member.broadcastUserInfo();
        }
    }

    @Override
    public String getType() {
        return _C__03_REQUESTSTARTPLEDGEWAR;
    }
}

