/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcWarehouse;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class SendWareHouseDepositList
extends L2GameClientPacket {
    private static final String _C__3B_SENDWAREHOUSEDEPOSITLIST = "[C] 3B SendWareHouseDepositList";
    private static final int BATCH_LENGTH = 12;
    private List<ItemHolder> _items = null;

    @Override
    protected void readImpl() {
        int size = this.readD();
        if (size <= 0 || size > Config.MAX_ITEM_IN_PACKET || size * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new ArrayList<ItemHolder>(size);
        for (int i = 0; i < size; ++i) {
            int objId = this.readD();
            long count = this.readQ();
            if (objId < 1 || count < 0L) {
                this._items = null;
                return;
            }
            this._items.add(new ItemHolder(objId, count));
        }
    }

    @Override
    protected void runImpl() {
        if (this._items == null) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("deposit")) {
            player.sendMessage("You are depositing items too fast.");
            return;
        }
        ItemContainer warehouse = player.getActiveWarehouse();
        if (warehouse == null) {
            return;
        }
        boolean isPrivate = warehouse instanceof PcWarehouse;
        L2Npc manager = player.getLastFolkNPC();
        if (!(manager != null && manager.isWarehouse() && manager.canInteract(player) || player.isGM())) {
            return;
        }
        if (!isPrivate && !player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disabled for your Access Level.");
            return;
        }
        if (player.getActiveEnchantItemId() != -1) {
            Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to use enchant Exploit!", Config.DEFAULT_PUNISH);
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_WAREHOUSE && player.getKarma() > 0) {
            return;
        }
        long fee = this._items.size() * 30;
        long currentAdena = player.getAdena();
        int slots = 0;
        for (ItemHolder itemHolder : this._items) {
            L2ItemInstance item = player.checkItemManipulation(itemHolder.getId(), itemHolder.getCount(), "deposit");
            if (item == null) {
                _log.warning("Error depositing a warehouse object for char " + player.getName() + " (validity check)");
                return;
            }
            if (item.getId() == 57) {
                currentAdena -= itemHolder.getCount();
            }
            if (!item.isStackable()) {
                slots = (int)((long)slots + itemHolder.getCount());
                continue;
            }
            if (warehouse.getItemByItemId(item.getId()) != null) continue;
            ++slots;
        }
        if (!warehouse.validateCapacity(slots)) {
            player.sendPacket(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED);
            return;
        }
        if (currentAdena < fee || !player.reduceAdena(warehouse.getName(), fee, manager, false)) {
            player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            return;
        }
        if (player.getActiveTradeList() != null) {
            return;
        }
        InventoryUpdate playerIU = Config.FORCE_INVENTORY_UPDATE ? null : new InventoryUpdate();
        for (ItemHolder i : this._items) {
            L2ItemInstance oldItem = player.checkItemManipulation(i.getId(), i.getCount(), "deposit");
            if (oldItem == null) {
                _log.warning("Error depositing a warehouse object for char " + player.getName() + " (olditem == null)");
                return;
            }
            if (!oldItem.isDepositable(isPrivate) || !oldItem.isAvailable(player, true, isPrivate)) continue;
            L2ItemInstance newItem = player.getInventory().transferItem(warehouse.getName(), i.getId(), i.getCount(), warehouse, player, manager);
            if (newItem == null) {
                _log.warning("Error depositing a warehouse object for char " + player.getName() + " (newitem == null)");
                continue;
            }
            if (playerIU == null) continue;
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                playerIU.addModifiedItem(oldItem);
                continue;
            }
            playerIU.addRemovedItem(oldItem);
        }
        if (playerIU != null) {
            player.sendPacket(playerIU);
        } else {
            player.sendPacket(new ItemList(player, false));
        }
        StatusUpdate statusUpdate = new StatusUpdate(player);
        statusUpdate.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(statusUpdate);
    }

    @Override
    public String getType() {
        return _C__3B_SENDWAREHOUSEDEPOSITLIST;
    }
}

