/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.ItemInfo;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;
import java.util.List;
import jp.sf.l2j.troja.FastIntObjectMap;

public abstract class AbstractInventoryUpdate
extends AbstractItemPacket {
    private final FastIntObjectMap<ItemInfo> _items = new FastIntObjectMap();

    public AbstractInventoryUpdate() {
    }

    public AbstractInventoryUpdate(L2ItemInstance item) {
        this.addItem(item);
    }

    public AbstractInventoryUpdate(List<ItemInfo> items) {
        for (ItemInfo item : items) {
            this._items.put(item.getObjectId(), (Object)item);
        }
    }

    public final void addItem(L2ItemInstance item) {
        this._items.put(item.getObjectId(), (Object)new ItemInfo(item));
    }

    public final void addNewItem(L2ItemInstance item) {
        this._items.put(item.getObjectId(), (Object)new ItemInfo(item, 1));
    }

    public final void addModifiedItem(L2ItemInstance item) {
        this._items.put(item.getObjectId(), (Object)new ItemInfo(item, 2));
    }

    public final void addRemovedItem(L2ItemInstance item) {
        this._items.put(item.getObjectId(), (Object)new ItemInfo(item, 3));
    }

    public final void addItems(List<L2ItemInstance> items) {
        for (L2ItemInstance item : items) {
            this._items.put(item.getObjectId(), (Object)new ItemInfo(item));
        }
    }

    public final boolean isEmpty() {
        return this._items.isEmpty();
    }

    protected final void writeItems() {
        this.writeH(this._items.size());
        for (ItemInfo item : this._items.values()) {
            this.writeH(item.getChange());
            this.writeItem(item);
        }
    }
}

