/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.logging.Level;

public abstract class AbstractMessagePacket<T extends AbstractMessagePacket<?>>
extends L2GameServerPacket {
    protected static final SMParam[] EMPTY_PARAM_ARRAY = new SMParam[0];
    private static final byte TYPE_SYSTEM_STRING = 13;
    private static final byte TYPE_PLAYER_NAME = 12;
    private static final byte TYPE_DOOR_NAME = 11;
    private static final byte TYPE_INSTANCE_NAME = 10;
    private static final byte TYPE_ELEMENT_NAME = 9;
    private static final byte TYPE_ZONE_NAME = 7;
    private static final byte TYPE_LONG_NUMBER = 6;
    private static final byte TYPE_CASTLE_NAME = 5;
    private static final byte TYPE_SKILL_NAME = 4;
    private static final byte TYPE_ITEM_NAME = 3;
    private static final byte TYPE_NPC_NAME = 2;
    private static final byte TYPE_INT_NUMBER = 1;
    private static final byte TYPE_TEXT = 0;
    private SMParam[] _params;
    private final SystemMessageId _smId;
    private int _paramIndex;

    public AbstractMessagePacket(SystemMessageId smId) {
        if (smId == null) {
            throw new NullPointerException("SystemMessageId cannot be null!");
        }
        this._smId = smId;
        this._params = smId.getParamCount() > 0 ? new SMParam[smId.getParamCount()] : EMPTY_PARAM_ARRAY;
    }

    public final int getId() {
        return this._smId.getId();
    }

    public final SystemMessageId getSystemMessageId() {
        return this._smId;
    }

    private final T append(SMParam param) {
        if (this._paramIndex >= this._params.length) {
            this._params = Arrays.copyOf(this._params, this._paramIndex + 1);
            this._smId.setParamCount(this._paramIndex + 1);
            _log.log(Level.INFO, "Wrong parameter count '" + (this._paramIndex + 1) + "' for SystemMessageId: " + this._smId);
        }
        this._params[this._paramIndex++] = param;
        return (T)((Object)this);
    }

    public final T addString(String text) {
        return this.append(new SMParam(0, text));
    }

    public final T addCastleId(int number) {
        return this.addCastleName(number);
    }

    public final T addCastleName(Castle castle) {
        return this.addCastleName(castle.getCastleId());
    }

    public final T addClanHallName(ClanHall clanHall) {
        return this.addCastleName(clanHall.getId());
    }

    public final T addSiegableHallName(SiegableHall siegableHall) {
        return this.addCastleName(siegableHall.getId());
    }

    public final T addTerritoryName(TerritoryWarManager.Territory territory) {
        return this.addCastleName(territory.getTerritoryId());
    }

    public final T addFortName(Fort fort) {
        return this.addCastleName(fort.getFortId());
    }

    private final T addCastleName(int number) {
        return this.append(new SMParam(5, number));
    }

    public final T addInt(int number) {
        return this.append(new SMParam(1, number));
    }

    public final T addLong(long number) {
        return this.append(new SMParam(6, number));
    }

    public final T addNumber(int number) {
        return this.addInt(number);
    }

    public T addNumber(long number) {
        if ((long)((int)number) == number) {
            return this.addInt((int)number);
        }
        return this.addLong(number);
    }

    public final T addItemNumber(int number) {
        return this.addNumber(number);
    }

    public final T addItemNumber(long number) {
        return this.addNumber(number);
    }

    public final T addCharName(L2Character cha) {
        if (cha.isNpc()) {
            L2Npc npc = (L2Npc)cha;
            if (npc.getTemplate().isUsingServerSideName()) {
                return this.addString(npc.getTemplate().getName());
            }
            return this.addNpcName(npc);
        }
        if (cha.isPlayer()) {
            return this.addPcName(cha.getActingPlayer());
        }
        if (cha.isSummon()) {
            L2Summon summon = (L2Summon)cha;
            if (summon.getTemplate().isUsingServerSideName()) {
                return this.addString(summon.getTemplate().getName());
            }
            return this.addNpcName(summon);
        }
        if (cha.isDoor()) {
            L2DoorInstance door = (L2DoorInstance)cha;
            return this.addDoorName(door.getId());
        }
        return this.addString(cha.getName());
    }

    public final T addPcName(L2PcInstance pc) {
        return this.append(new SMParam(12, pc.getAppearance().getVisibleName()));
    }

    public final T addDoorName(int doorId) {
        return this.append(new SMParam(11, doorId));
    }

    public final T addNpcName(L2Npc npc) {
        return this.addNpcName(npc.getTemplate());
    }

    public final T addNpcName(L2Summon npc) {
        return this.addNpcName(npc.getId());
    }

    public final T addNpcName(L2NpcTemplate template) {
        if (template.isUsingServerSideName()) {
            return this.addString(template.getName());
        }
        return this.addNpcName(template.getId());
    }

    public final T addNpcName(int id) {
        return this.append(new SMParam(2, 1000000 + id));
    }

    public final T addItemName(L2ItemInstance item) {
        return this.addItemName(item.getItem());
    }

    public final T addItemName(L2Item item) {
        int id = item.getId();
        if (item.getDisplayId() != id) {
            return this.addString(item.getName());
        }
        return this.append(new SMParam(3, id));
    }

    public final T addItemName(int id) {
        return this.addItemName(ItemTable.getInstance().getTemplate(id));
    }

    public final T addZoneName(int x, int y, int z) {
        return this.append(new SMParam(7, new int[]{x, y, z}));
    }

    public final T addSkillName(Skill skill) {
        if (skill.getId() != skill.getDisplayId()) {
            return this.addString(skill.getName());
        }
        return this.addSkillName(skill.getId(), skill.getLevel());
    }

    public final T addSkillName(int id) {
        return this.addSkillName(id, 1);
    }

    public final T addSkillName(int id, int lvl) {
        return this.append(new SMParam(4, new int[]{id, lvl}));
    }

    public final T addElemental(int type) {
        return this.append(new SMParam(9, type));
    }

    public final T addSystemString(int type) {
        return this.append(new SMParam(13, type));
    }

    public final T addInstanceName(int type) {
        return this.append(new SMParam(10, type));
    }

    protected final void writeMe() {
        this.writeD(this.getId());
        this.writeD(this._params.length);
        block7: for (int i = 0; i < this._paramIndex; ++i) {
            SMParam param = this._params[i];
            this.writeD(param.getType());
            switch (param.getType()) {
                case 0: 
                case 12: {
                    this.writeS(param.getStringValue());
                    continue block7;
                }
                case 6: {
                    this.writeQ(param.getLongValue());
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    this.writeD(param.getIntValue());
                    continue block7;
                }
                case 4: {
                    int[] array = param.getIntArrayValue();
                    this.writeD(array[0]);
                    this.writeD(array[1]);
                    continue block7;
                }
                case 7: {
                    int[] array = param.getIntArrayValue();
                    this.writeD(array[0]);
                    this.writeD(array[1]);
                    this.writeD(array[2]);
                    continue block7;
                }
            }
        }
    }

    void printMe(PrintStream out) {
        out.println(this.getId());
        out.println(this._params.length);
        block7: for (SMParam param : this._params) {
            switch (param.getType()) {
                case 0: 
                case 12: {
                    out.println(param.getStringValue());
                    continue block7;
                }
                case 6: {
                    out.println(param.getLongValue());
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    out.println(param.getIntValue());
                    continue block7;
                }
                case 4: {
                    int[] array = param.getIntArrayValue();
                    out.println(array[0]);
                    out.println(array[1]);
                    continue block7;
                }
                case 7: {
                    int[] array = param.getIntArrayValue();
                    out.println(array[0]);
                    out.println(array[1]);
                    out.println(array[2]);
                    continue block7;
                }
            }
        }
    }

    public final T getLocalizedMessage(String lang) {
        if (!Config.L2JMOD_MULTILANG_SM_ENABLE || this.getSystemMessageId() == SystemMessageId.S1) {
            return (T)((Object)this);
        }
        SystemMessageId.SMLocalisation sml = this.getSystemMessageId().getLocalisation(lang);
        if (sml == null) {
            return (T)((Object)this);
        }
        Object[] params = new Object[this._paramIndex];
        for (int i = 0; i < this._paramIndex; ++i) {
            SMParam param = this._params[i];
            switch (param.getType()) {
                case 0: 
                case 12: {
                    params[i] = param.getValue();
                    break;
                }
                case 6: {
                    params[i] = param.getValue();
                    break;
                }
                case 3: {
                    L2Item item = ItemTable.getInstance().getTemplate(param.getIntValue());
                    params[i] = item == null ? "Unknown" : item.getName();
                    break;
                }
                case 5: {
                    Castle castle = CastleManager.getInstance().getCastleById(param.getIntValue());
                    params[i] = castle == null ? "Unknown" : castle.getName();
                    break;
                }
                case 1: {
                    params[i] = param.getValue();
                    break;
                }
                case 2: {
                    L2NpcTemplate template = NpcData.getInstance().getTemplate(param.getIntValue());
                    params[i] = template == null ? "Unknown" : template.getName();
                    break;
                }
                case 9: {
                    params[i] = Elementals.getElementName((byte)param.getIntValue());
                    break;
                }
                case 13: {
                    params[i] = "SYS-S-" + param.getIntValue();
                    break;
                }
                case 10: {
                    String instanceName = InstanceManager.getInstance().getInstanceIdName(param.getIntValue());
                    params[i] = instanceName == null ? "Unknown" : instanceName;
                    break;
                }
                case 11: {
                    L2DoorInstance door = DoorTable.getInstance().getDoor(param.getIntValue());
                    params[i] = door == null ? "Unknown" : door.getName();
                    break;
                }
                case 4: {
                    int[] array = param.getIntArrayValue();
                    Skill skill = SkillData.getInstance().getSkill(array[0], array[1]);
                    params[i] = skill == null ? "Unknown" : skill.getName();
                    break;
                }
                case 7: {
                    int[] array = param.getIntArrayValue();
                    L2ZoneType zone = ZoneManager.getInstance().getZone(array[0], array[1], array[2], L2ZoneType.class);
                    params[i] = zone == null ? "Unknown ZONE-N-" + Arrays.toString(array) : zone.getName();
                    break;
                }
            }
            ++i;
        }
        return this.addString(sml.getLocalisation(params));
    }

    private static final class SMParam {
        private final byte _type;
        private final Object _value;

        public SMParam(byte type, Object value) {
            this._type = type;
            this._value = value;
        }

        public final byte getType() {
            return this._type;
        }

        public final Object getValue() {
            return this._value;
        }

        public final String getStringValue() {
            return (String)this._value;
        }

        public final int getIntValue() {
            return (Integer)this._value;
        }

        public final long getLongValue() {
            return (Long)this._value;
        }

        public final int[] getIntArrayValue() {
            return (int[])this._value;
        }
    }
}

