/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.L2Decoy;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class CharInfo
extends L2GameServerPacket {
    private final L2PcInstance _activeChar;
    private int _objId;
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private final int _mAtkSpd;
    private final int _pAtkSpd;
    private final int _runSpd;
    private final int _walkSpd;
    private final int _swimRunSpd;
    private final int _swimWalkSpd;
    private final int _flyRunSpd;
    private final int _flyWalkSpd;
    private final double _moveMultiplier;
    private final float _attackSpeedMultiplier;
    private int _vehicleId = 0;
    private static final int[] PAPERDOLL_ORDER = new int[]{0, 1, 5, 7, 10, 6, 11, 12, 23, 5, 2, 3, 16, 15, 17, 18, 19, 20, 21, 22, 24};

    public CharInfo(L2PcInstance cha) {
        this._activeChar = cha;
        this._objId = cha.getObjectId();
        if (this._activeChar.getVehicle() != null && this._activeChar.getInVehiclePosition() != null) {
            this._x = this._activeChar.getInVehiclePosition().getX();
            this._y = this._activeChar.getInVehiclePosition().getY();
            this._z = this._activeChar.getInVehiclePosition().getZ();
            this._vehicleId = this._activeChar.getVehicle().getObjectId();
        } else {
            this._x = this._activeChar.getX();
            this._y = this._activeChar.getY();
            this._z = this._activeChar.getZ();
        }
        this._heading = this._activeChar.getHeading();
        this._mAtkSpd = this._activeChar.getMAtkSpd();
        this._pAtkSpd = this._activeChar.getPAtkSpd();
        this._attackSpeedMultiplier = this._activeChar.getAttackSpeedMultiplier();
        this._invisible = cha.isInvisible();
        this._moveMultiplier = cha.getMovementSpeedMultiplier();
        this._runSpd = (int)Math.round(cha.getRunSpeed() / this._moveMultiplier);
        this._walkSpd = (int)Math.round(cha.getWalkSpeed() / this._moveMultiplier);
        this._swimRunSpd = (int)Math.round(cha.getSwimRunSpeed() / this._moveMultiplier);
        this._swimWalkSpd = (int)Math.round(cha.getSwimWalkSpeed() / this._moveMultiplier);
        this._flyRunSpd = cha.isFlying() ? this._runSpd : 0;
        this._flyWalkSpd = cha.isFlying() ? this._walkSpd : 0;
    }

    public CharInfo(L2Decoy decoy) {
        this(decoy.getActingPlayer());
        this._objId = decoy.getObjectId();
        this._x = decoy.getX();
        this._y = decoy.getY();
        this._z = decoy.getZ();
        this._heading = decoy.getHeading();
    }

    @Override
    protected final void writeImpl() {
        L2NpcTemplate template;
        L2PcInstance activeChar;
        boolean gmSeeInvis = false;
        if (this._invisible && (activeChar = ((L2GameClient)this.getClient()).getActiveChar()) != null && activeChar.canOverrideCond(PcCondOverride.SEE_ALL_PLAYERS)) {
            gmSeeInvis = true;
        }
        L2NpcTemplate l2NpcTemplate = template = this._activeChar.getPoly().isMorphed() ? NpcData.getInstance().getTemplate(this._activeChar.getPoly().getPolyId()) : null;
        if (template != null) {
            this.writeC(12);
            this.writeD(this._objId);
            this.writeD(template.getId() + 1000000);
            this.writeD(this._activeChar.getKarma() > 0 ? 1 : 0);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._heading);
            this.writeD(0);
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._swimRunSpd);
            this.writeD(this._swimWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeF(this._moveMultiplier);
            this.writeF(this._attackSpeedMultiplier);
            this.writeF(template.getfCollisionRadius());
            this.writeF(template.getfCollisionHeight());
            this.writeD(template.getRHandId());
            this.writeD(template.getChestId());
            this.writeD(template.getLHandId());
            this.writeC(1);
            this.writeC(this._activeChar.isRunning() ? 1 : 0);
            this.writeC(this._activeChar.isInCombat() ? 1 : 0);
            this.writeC(this._activeChar.isAlikeDead() ? 1 : 0);
            this.writeC(!gmSeeInvis && this._invisible ? 1 : 0);
            this.writeD(-1);
            this.writeS(this._activeChar.getAppearance().getVisibleName());
            this.writeD(-1);
            this.writeS(gmSeeInvis ? "Invisible" : this._activeChar.getAppearance().getVisibleTitle());
            this.writeD(this._activeChar.getAppearance().getTitleColor());
            this.writeD(this._activeChar.getPvpFlag());
            this.writeD(this._activeChar.getKarma());
            this.writeD(gmSeeInvis ? this._activeChar.getAbnormalVisualEffects() | AbnormalVisualEffect.STEALTH.getMask() : this._activeChar.getAbnormalVisualEffects());
            this.writeD(this._activeChar.getClanId());
            this.writeD(this._activeChar.getClanCrestId());
            this.writeD(this._activeChar.getAllyId());
            this.writeD(this._activeChar.getAllyCrestId());
            this.writeC(this._activeChar.isFlying() ? 2 : 0);
            this.writeC(this._activeChar.getTeam().getId());
            this.writeF(template.getfCollisionRadius());
            this.writeF(template.getfCollisionHeight());
            this.writeD(0);
            this.writeD(this._activeChar.isFlying() ? 2 : 0);
            this.writeD(0);
            this.writeD(0);
            this.writeC(template.isTargetable() ? 1 : 0);
            this.writeC(template.isShowName() ? 1 : 0);
            this.writeC(this._activeChar.getAbnormalVisualEffectSpecial());
            this.writeD(0);
        } else {
            this.writeC(49);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._vehicleId);
            this.writeD(this._objId);
            this.writeS(this._activeChar.getAppearance().getVisibleName());
            this.writeD(this._activeChar.getRace().ordinal());
            this.writeD(this._activeChar.getAppearance().getSex() ? 1 : 0);
            this.writeD(this._activeChar.getBaseClass());
            for (int slot : this.getPaperdollOrder()) {
                this.writeD(this._activeChar.getInventory().getPaperdollItemDisplayId(slot));
            }
            for (int slot : this.getPaperdollOrder()) {
                this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(slot));
            }
            this.writeD(this._activeChar.getInventory().getTalismanSlots());
            this.writeD(this._activeChar.getInventory().canEquipCloak() ? 1 : 0);
            this.writeD(this._activeChar.getPvpFlag());
            this.writeD(this._activeChar.getKarma());
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(0);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._swimRunSpd);
            this.writeD(this._swimWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeF(this._moveMultiplier);
            this.writeF(this._activeChar.getAttackSpeedMultiplier());
            this.writeF(this._activeChar.getCollisionRadius());
            this.writeF(this._activeChar.getCollisionHeight());
            this.writeD(this._activeChar.getAppearance().getHairStyle());
            this.writeD(this._activeChar.getAppearance().getHairColor());
            this.writeD(this._activeChar.getAppearance().getFace());
            this.writeS(gmSeeInvis ? "Invisible" : this._activeChar.getAppearance().getVisibleTitle());
            if (!this._activeChar.isCursedWeaponEquipped()) {
                this.writeD(this._activeChar.getClanId());
                this.writeD(this._activeChar.getClanCrestId());
                this.writeD(this._activeChar.getAllyId());
                this.writeD(this._activeChar.getAllyCrestId());
            } else {
                this.writeD(0);
                this.writeD(0);
                this.writeD(0);
                this.writeD(0);
            }
            this.writeC(this._activeChar.isSitting() ? 0 : 1);
            this.writeC(this._activeChar.isRunning() ? 1 : 0);
            this.writeC(this._activeChar.isInCombat() ? 1 : 0);
            this.writeC(!this._activeChar.isInOlympiadMode() && this._activeChar.isAlikeDead() ? 1 : 0);
            this.writeC(!gmSeeInvis && this._invisible ? 1 : 0);
            this.writeC(this._activeChar.getMountType().ordinal());
            this.writeC(this._activeChar.getPrivateStoreType().getId());
            this.writeH(this._activeChar.getCubics().size());
            Object object = this._activeChar.getCubics().values().iterator();
            while (object.hasNext()) {
                L2CubicInstance cubic = (L2CubicInstance)object.next();
                this.writeH(cubic.getId());
            }
            this.writeC(this._activeChar.isInPartyMatchRoom() ? 1 : 0);
            this.writeD(gmSeeInvis ? this._activeChar.getAbnormalVisualEffects() | AbnormalVisualEffect.STEALTH.getMask() : this._activeChar.getAbnormalVisualEffects());
            this.writeC(this._activeChar.isInsideZone(ZoneId.WATER) ? 1 : (this._activeChar.isFlyingMounted() ? 2 : 0));
            this.writeH(this._activeChar.getRecomHave());
            this.writeD(this._activeChar.getMountNpcId() + 1000000);
            this.writeD(this._activeChar.getClassId().getId());
            this.writeD(0);
            this.writeC(this._activeChar.isMounted() ? 0 : this._activeChar.getEnchantEffect());
            this.writeC(this._activeChar.getTeam().getId());
            this.writeD(this._activeChar.getClanCrestLargeId());
            this.writeC(this._activeChar.isNoble() ? 1 : 0);
            this.writeC(this._activeChar.isHero() || Config.GM_HERO_AURA && this._activeChar.isGM() || this._activeChar.aura ? 1 : 0);
            this.writeC(this._activeChar.isFishing() ? 1 : 0);
            this.writeD(this._activeChar.getFishx());
            this.writeD(this._activeChar.getFishy());
            this.writeD(this._activeChar.getFishz());
            this.writeD(this._activeChar.getAppearance().getNameColor());
            this.writeD(this._heading);
            this.writeD(this._activeChar.getPledgeClass());
            this.writeD(this._activeChar.getPledgeType());
            this.writeD(this._activeChar.getAppearance().getTitleColor());
            this.writeD(this._activeChar.isCursedWeaponEquipped() ? CursedWeaponsManager.getInstance().getLevel(this._activeChar.getCursedWeaponEquippedId()) : 0);
            this.writeD(this._activeChar.getClanId() > 0 ? this._activeChar.getClan().getReputationScore() : 0);
            this.writeD(this._activeChar.getTransformationDisplayId());
            this.writeD(this._activeChar.getAgathionId());
            this.writeD(1);
            this.writeD(this._activeChar.getAbnormalVisualEffectSpecial());
        }
    }

    @Override
    protected int[] getPaperdollOrder() {
        return PAPERDOLL_ORDER;
    }
}

