/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import jp.sf.l2j.troja.FastIntObjectMap;

public class ExShowCropSetting
extends L2GameServerPacket {
    private final int _manorId;
    private final ArrayList<L2Seed> _seeds;
    private final FastIntObjectMap<CropProcure> _current = new FastIntObjectMap();
    private final FastIntObjectMap<CropProcure> _next = new FastIntObjectMap();

    public ExShowCropSetting(int manorId) {
        CastleManorManager manor = CastleManorManager.getInstance();
        this._manorId = manorId;
        this._seeds = manor.getSeedsForCastle(this._manorId);
        for (L2Seed s : this._seeds) {
            CropProcure cp = manor.getCropProcure(manorId, s.getCropId(), false);
            if (cp != null) {
                this._current.put(s.getCropId(), (Object)cp);
            }
            if ((cp = manor.getCropProcure(manorId, s.getCropId(), true)) == null) continue;
            this._next.put(s.getCropId(), (Object)cp);
        }
    }

    @Override
    public void writeImpl() {
        this.writeC(254);
        this.writeH(43);
        this.writeD(this._manorId);
        this.writeD(this._seeds.size());
        for (L2Seed s : this._seeds) {
            this.writeD(s.getCropId());
            this.writeD(s.getLevel());
            this.writeC(1);
            this.writeD(s.getReward(1));
            this.writeC(1);
            this.writeD(s.getReward(2));
            this.writeD(s.getCropLimit());
            this.writeD(0);
            this.writeD(s.getCropMinPrice());
            this.writeD(s.getCropMaxPrice());
            CropProcure cp = (CropProcure)this._current.get(s.getCropId());
            if (cp != null) {
                this.writeQ(cp.getStartAmount());
                this.writeQ(cp.getPrice());
                this.writeC(cp.getReward());
            } else {
                this.writeQ(0L);
                this.writeQ(0L);
                this.writeC(0);
            }
            cp = (CropProcure)this._next.get(s.getCropId());
            if (cp != null) {
                this.writeQ(cp.getStartAmount());
                this.writeQ(cp.getPrice());
                this.writeC(cp.getReward());
                continue;
            }
            this.writeQ(0L);
            this.writeQ(0L);
            this.writeC(0);
        }
        this._next.clear();
        this._current.clear();
    }
}

