/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.ActionKey;
import com.l2jserver.gameserver.model.UIKeysSettings;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Iterator;
import java.util.List;

public class ExUISetting
extends L2GameServerPacket {
    private final UIKeysSettings _uiSettings;
    private int buffsize;
    private int categories;

    public ExUISetting(L2PcInstance player) {
        this._uiSettings = player.getUISettings();
        this.calcSize();
    }

    private void calcSize() {
        int size = 16;
        int category = 0;
        int numKeyCt = this._uiSettings.getKeys().size();
        for (int i = 0; i < numKeyCt; ++i) {
            ++size;
            if (this._uiSettings.getCategories().containsKey(category)) {
                List catElList1 = (List)this._uiSettings.getCategories().get(category);
                size += catElList1.size();
            }
            ++size;
            if (this._uiSettings.getCategories().containsKey(++category)) {
                List catElList2 = (List)this._uiSettings.getCategories().get(category);
                size += catElList2.size();
            }
            ++category;
            size += 4;
            if (!this._uiSettings.getKeys().containsKey(i)) continue;
            List keyElList = (List)this._uiSettings.getKeys().get(i);
            size += keyElList.size() * 20;
        }
        this.buffsize = size;
        this.categories = category;
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(112);
        this.writeD(this.buffsize);
        this.writeD(this.categories);
        int category = 0;
        int numKeyCt = this._uiSettings.getKeys().size();
        this.writeD(numKeyCt);
        for (int i = 0; i < numKeyCt; ++i) {
            int cmd;
            Iterator iterator;
            if (this._uiSettings.getCategories().containsKey(category)) {
                List catElList1 = (List)this._uiSettings.getCategories().get(category);
                this.writeC(catElList1.size());
                iterator = catElList1.iterator();
                while (iterator.hasNext()) {
                    cmd = (Integer)iterator.next();
                    this.writeC(cmd);
                }
            } else {
                this.writeC(0);
            }
            if (this._uiSettings.getCategories().containsKey(++category)) {
                List catElList2 = (List)this._uiSettings.getCategories().get(category);
                this.writeC(catElList2.size());
                iterator = catElList2.iterator();
                while (iterator.hasNext()) {
                    cmd = (Integer)iterator.next();
                    this.writeC(cmd);
                }
            } else {
                this.writeC(0);
            }
            ++category;
            if (this._uiSettings.getKeys().containsKey(i)) {
                List keyElList = (List)this._uiSettings.getKeys().get(i);
                this.writeD(keyElList.size());
                for (ActionKey akey : keyElList) {
                    this.writeD(akey.getCommandId());
                    this.writeD(akey.getKeyId());
                    this.writeD(akey.getToogleKey1());
                    this.writeD(akey.getToogleKey2());
                    this.writeD(akey.getShowStatus());
                }
                continue;
            }
            this.writeD(0);
        }
        this.writeD(17);
        this.writeD(16);
    }
}

