/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import javolution.util.FastList;

public class FriendListExtended
extends L2GameServerPacket {
    private final List<FriendInfo> _info;

    public FriendListExtended(L2PcInstance player) {
        this._info = new FastList(player.getFriendList().size());
        for (int objId : player.getFriendList()) {
            String name = CharNameTable.getInstance().getNameById(objId);
            L2PcInstance player1 = L2World.getInstance().getPlayer(objId);
            boolean online = false;
            int classid = 0;
            int level = 0;
            if (player1 == null) {
                try {
                    Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                    Throwable throwable = null;
                    try {
                        PreparedStatement statement = con.prepareStatement("SELECT char_name, online, classid, level FROM characters WHERE charId = ?");
                        Throwable throwable2 = null;
                        try {
                            statement.setInt(1, objId);
                            ResultSet rset = statement.executeQuery();
                            Throwable throwable3 = null;
                            try {
                                if (!rset.next()) continue;
                                this._info.add(new FriendInfo(objId, rset.getString(1), rset.getInt(2) == 1, rset.getInt(3), rset.getInt(4)));
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (rset == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        rset.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                rset.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (statement == null) continue;
                            if (throwable2 != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            statement.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (con == null) continue;
                        if (throwable != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        con.close();
                    }
                }
                catch (Exception e) {}
                continue;
            }
            if (player1.isOnline()) {
                online = true;
            }
            classid = player1.getClassId().getId();
            level = player1.getLevel();
            this._info.add(new FriendInfo(objId, name, online, classid, level));
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(88);
        this.writeD(this._info.size());
        for (FriendInfo info : this._info) {
            this.writeD(info._objId);
            this.writeS(info._name);
            this.writeD(info._online ? 1 : 0);
            this.writeD(info._online ? info._objId : 0);
            this.writeD(info._classid);
            this.writeD(info._level);
        }
    }

    private static class FriendInfo {
        int _objId;
        String _name;
        boolean _online;
        int _classid;
        int _level;

        public FriendInfo(int objId, String name, boolean online, int classid, int level) {
            this._objId = objId;
            this._name = name;
            this._online = online;
            this._classid = classid;
            this._level = level;
        }
    }
}

