/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IPositionable;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MagicSkillUse
extends L2GameServerPacket {
    private final int _targetId;
    private final int _tx;
    private final int _ty;
    private final int _tz;
    private final int _skillId;
    private final int _skillLevel;
    private final int _hitTime;
    private final int _reuseDelay;
    private final int _charObjId;
    private final int _x;
    private final int _y;
    private final int _z;
    private final List<Integer> _unknown = Collections.emptyList();
    private final List<Location> _groundLocations;

    public MagicSkillUse(L2Character cha, L2Character target, int skillId, int skillLevel, int hitTime, int reuseDelay) {
        L2PcInstance player;
        this._charObjId = cha.getObjectId();
        this._targetId = target.getObjectId();
        this._skillId = skillId;
        this._skillLevel = skillLevel;
        this._hitTime = hitTime;
        this._reuseDelay = reuseDelay;
        this._x = cha.getX();
        this._y = cha.getY();
        this._z = cha.getZ();
        this._tx = target.getX();
        this._ty = target.getY();
        this._tz = target.getZ();
        Location skillWorldPos = null;
        if (cha.isPlayer() && (player = cha.getActingPlayer()).getCurrentSkillWorldPosition() != null) {
            skillWorldPos = player.getCurrentSkillWorldPosition();
        }
        this._groundLocations = skillWorldPos != null ? Arrays.asList(skillWorldPos) : Collections.emptyList();
    }

    public MagicSkillUse(L2Character cha, int skillId, int skillLevel, int hitTime, int reuseDelay) {
        this(cha, cha, skillId, skillLevel, hitTime, reuseDelay);
    }

    @Override
    protected final void writeImpl() {
        this.writeC(72);
        this.writeD(this._charObjId);
        this.writeD(this._targetId);
        this.writeD(this._skillId);
        this.writeD(this._skillLevel);
        this.writeD(this._hitTime);
        this.writeD(this._reuseDelay);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeH(this._unknown.size());
        Iterator<Object> iterator = this._unknown.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            this.writeH(n);
        }
        this.writeH(this._groundLocations.size());
        for (IPositionable iPositionable : this._groundLocations) {
            this.writeLoc(iPositionable);
        }
        this.writeD(this._tx);
        this.writeD(this._ty);
        this.writeD(this._tz);
    }
}

