/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import javolution.util.FastList;

public final class RelationChanged
extends L2GameServerPacket {
    public static final int RELATION_PARTY1 = 1;
    public static final int RELATION_PARTY2 = 2;
    public static final int RELATION_PARTY3 = 4;
    public static final int RELATION_PARTY4 = 8;
    public static final int RELATION_PARTYLEADER = 16;
    public static final int RELATION_HAS_PARTY = 32;
    public static final int RELATION_CLAN_MEMBER = 64;
    public static final int RELATION_LEADER = 128;
    public static final int RELATION_CLAN_MATE = 256;
    public static final int RELATION_INSIEGE = 512;
    public static final int RELATION_ATTACKER = 1024;
    public static final int RELATION_ALLY = 2048;
    public static final int RELATION_ENEMY = 4096;
    public static final int RELATION_MUTUAL_WAR = 16384;
    public static final int RELATION_1SIDED_WAR = 32768;
    public static final int RELATION_ALLY_MEMBER = 65536;
    public static final int RELATION_TERRITORY_WAR = 524288;
    private Relation _singled;
    private FastList<Relation> _multi;

    public RelationChanged(L2Playable activeChar, int relation, boolean autoattackable) {
        this._singled = new Relation();
        this._singled._objId = activeChar.getObjectId();
        this._singled._relation = relation;
        this._singled._autoAttackable = autoattackable ? 1 : 0;
        this._singled._karma = activeChar.getKarma();
        this._singled._pvpFlag = activeChar.getPvpFlag();
        this._invisible = activeChar.isInvisible();
    }

    public RelationChanged() {
        this._multi = FastList.newInstance();
    }

    public void addRelation(L2Playable activeChar, int relation, boolean autoattackable) {
        if (activeChar.isInvisible()) {
            throw new IllegalArgumentException("Cannot add insivisble character to multi relation packet");
        }
        Relation r = new Relation();
        r._objId = activeChar.getObjectId();
        r._relation = relation;
        r._autoAttackable = autoattackable ? 1 : 0;
        r._karma = activeChar.getKarma();
        r._pvpFlag = activeChar.getPvpFlag();
        this._multi.add((Object)r);
    }

    @Override
    protected final void writeImpl() {
        this.writeC(206);
        if (this._multi == null) {
            this.writeD(1);
            this.writeRelation(this._singled);
        } else {
            this.writeD(this._multi.size());
            for (Relation r : this._multi) {
                this.writeRelation(r);
            }
            FastList.recycle(this._multi);
            this._multi = null;
        }
    }

    private void writeRelation(Relation relation) {
        this.writeD(relation._objId);
        this.writeD(relation._relation);
        this.writeD(relation._autoAttackable);
        this.writeD(relation._karma);
        this.writeD(relation._pvpFlag);
    }

    protected static class Relation {
        int _objId;
        int _relation;
        int _autoAttackable;
        int _karma;
        int _pvpFlag;

        protected Relation() {
        }
    }
}

