/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Calendar;

public class SiegeInfo
extends L2GameServerPacket {
    private Castle _castle;
    private ClanHall _hall;

    public SiegeInfo(Castle castle) {
        this._castle = castle;
    }

    public SiegeInfo(ClanHall hall) {
        this._hall = hall;
    }

    @Override
    protected final void writeImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        this.writeC(201);
        if (this._castle != null) {
            this.writeD(this._castle.getResidenceId());
            int ownerId = this._castle.getOwnerId();
            this.writeD(ownerId == activeChar.getClanId() && activeChar.isClanLeader() ? 1 : 0);
            this.writeD(ownerId);
            if (ownerId > 0) {
                L2Clan owner = ClanTable.getInstance().getClan(ownerId);
                if (owner != null) {
                    this.writeS(owner.getName());
                    this.writeS(owner.getLeaderName());
                    this.writeD(owner.getAllyId());
                    this.writeS(owner.getAllyName());
                } else {
                    _log.warning("Null owner for castle: " + this._castle.getName());
                }
            } else {
                this.writeS("");
                this.writeS("");
                this.writeD(0);
                this.writeS("");
            }
            this.writeD((int)(System.currentTimeMillis() / 1000L));
            if (!this._castle.getIsTimeRegistrationOver() && activeChar.isClanLeader() && activeChar.getClanId() == this._castle.getOwnerId()) {
                Calendar cal = (Calendar)this._castle.getSiegeDate().clone();
                cal.set(12, 0);
                cal.set(13, 0);
                this.writeD(0);
                this.writeD(Config.SIEGE_HOUR_LIST.size());
                for (int hour : Config.SIEGE_HOUR_LIST) {
                    cal.set(11, hour);
                    this.writeD((int)(cal.getTimeInMillis() / 1000L));
                }
            } else {
                this.writeD((int)(this._castle.getSiegeDate().getTimeInMillis() / 1000L));
                this.writeD(0);
            }
        } else {
            this.writeD(this._hall.getId());
            int ownerId = this._hall.getOwnerId();
            this.writeD(ownerId == activeChar.getClanId() && activeChar.isClanLeader() ? 1 : 0);
            this.writeD(ownerId);
            if (ownerId > 0) {
                L2Clan owner = ClanTable.getInstance().getClan(ownerId);
                if (owner != null) {
                    this.writeS(owner.getName());
                    this.writeS(owner.getLeaderName());
                    this.writeD(owner.getAllyId());
                    this.writeS(owner.getAllyName());
                } else {
                    _log.warning("Null owner for siegable hall: " + this._hall.getName());
                }
            } else {
                this.writeS("");
                this.writeS("");
                this.writeD(0);
                this.writeS("");
            }
            this.writeD((int)(System.currentTimeMillis() / 1000L));
            this.writeD((int)(CHSiegeManager.getInstance().getSiegableHall(this._hall.getId()).getNextSiegeTime() / 1000L));
            this.writeD(0);
        }
    }
}

