/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;

public final class WareHouseDepositList
extends AbstractItemPacket {
    public static final int PRIVATE = 1;
    public static final int CLAN = 4;
    public static final int CASTLE = 3;
    public static final int FREIGHT = 1;
    private final long _playerAdena;
    private final L2ItemInstance[] _items;
    private final int _size;
    private final int _whType;

    public WareHouseDepositList(L2PcInstance player, int type) {
        this._whType = type;
        this._playerAdena = player.getAdena();
        boolean isPrivate = this._whType == 1;
        this._items = player.getInventory().getAvailableItems(true, isPrivate, false);
        int index = 0;
        for (L2ItemInstance temp : this._items) {
            if (!temp.isDepositable(isPrivate)) continue;
            this._items[index++] = temp;
        }
        this._size = index;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(65);
        this.writeH(this._whType);
        this.writeQ(this._playerAdena);
        this.writeH(this._size);
        for (int index = 0; index < this._size; ++index) {
            L2ItemInstance item = this._items[index];
            this.writeItem(item);
            this.writeD(item.getObjectId());
        }
    }
}

