/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.pathfinding.cellnodes;

import com.l2jserver.Config;
import com.l2jserver.gameserver.pathfinding.cellnodes.CellNode;
import com.l2jserver.gameserver.pathfinding.cellnodes.NodeLoc;
import java.util.concurrent.locks.ReentrantLock;
import javolution.util.FastList;

public class CellNodeBuffer {
    private static final int MAX_ITERATIONS = 3500;
    private final ReentrantLock _lock = new ReentrantLock();
    private final int _mapSize;
    private final CellNode[][] _buffer;
    private int _baseX = 0;
    private int _baseY = 0;
    private int _targetX = 0;
    private int _targetY = 0;
    private int _targetZ = 0;
    private long _timeStamp = 0L;
    private long _lastElapsedTime = 0L;
    private CellNode _current = null;

    public CellNodeBuffer(int size) {
        this._mapSize = size;
        this._buffer = new CellNode[this._mapSize][this._mapSize];
    }

    public final boolean lock() {
        return this._lock.tryLock();
    }

    public final CellNode findPath(int x, int y, int z, int tx, int ty, int tz) {
        this._timeStamp = System.currentTimeMillis();
        this._baseX = x + (tx - x - this._mapSize) / 2;
        this._baseY = y + (ty - y - this._mapSize) / 2;
        this._targetX = tx;
        this._targetY = ty;
        this._targetZ = tz;
        this._current = this.getNode(x, y, z);
        this._current.setCost(this.getCost(x, y, z, Config.HIGH_WEIGHT));
        for (int count = 0; count < 3500; ++count) {
            if (this._current.getLoc().getNodeX() == this._targetX && this._current.getLoc().getNodeY() == this._targetY && Math.abs(this._current.getLoc().getZ() - this._targetZ) < 64) {
                return this._current;
            }
            this.getNeighbors();
            if (this._current.getNext() == null) {
                return null;
            }
            this._current = this._current.getNext();
        }
        return null;
    }

    public final void free() {
        this._current = null;
        for (int i = 0; i < this._mapSize; ++i) {
            for (int j = 0; j < this._mapSize; ++j) {
                CellNode node = this._buffer[i][j];
                if (node == null) continue;
                node.free();
            }
        }
        this._lock.unlock();
        this._lastElapsedTime = System.currentTimeMillis() - this._timeStamp;
    }

    public final long getElapsedTime() {
        return this._lastElapsedTime;
    }

    public final FastList<CellNode> debugPath() {
        FastList result = new FastList();
        CellNode n = this._current;
        while (n.getParent() != null) {
            result.add((Object)n);
            n.setCost(-n.getCost());
            n = (CellNode)n.getParent();
        }
        for (int i = 0; i < this._mapSize; ++i) {
            for (int j = 0; j < this._mapSize; ++j) {
                CellNode n2 = this._buffer[i][j];
                if (n2 == null || !n2.isInUse() || n2.getCost() <= 0.0f) continue;
                result.add((Object)n2);
            }
        }
        return result;
    }

    private final void getNeighbors() {
        if (((NodeLoc)this._current.getLoc()).canGoNone()) {
            return;
        }
        int x = this._current.getLoc().getNodeX();
        int y = this._current.getLoc().getNodeY();
        int z = this._current.getLoc().getZ();
        CellNode nodeE = null;
        CellNode nodeS = null;
        CellNode nodeW = null;
        CellNode nodeN = null;
        if (((NodeLoc)this._current.getLoc()).canGoEast()) {
            nodeE = this.addNode(x + 1, y, z, false);
        }
        if (((NodeLoc)this._current.getLoc()).canGoSouth()) {
            nodeS = this.addNode(x, y + 1, z, false);
        }
        if (((NodeLoc)this._current.getLoc()).canGoWest()) {
            nodeW = this.addNode(x - 1, y, z, false);
        }
        if (((NodeLoc)this._current.getLoc()).canGoNorth()) {
            nodeN = this.addNode(x, y - 1, z, false);
        }
        if (Config.ADVANCED_DIAGONAL_STRATEGY) {
            if (nodeE != null && nodeS != null && ((NodeLoc)nodeE.getLoc()).canGoSouth() && ((NodeLoc)nodeS.getLoc()).canGoEast()) {
                this.addNode(x + 1, y + 1, z, true);
            }
            if (nodeS != null && nodeW != null && ((NodeLoc)nodeW.getLoc()).canGoSouth() && ((NodeLoc)nodeS.getLoc()).canGoWest()) {
                this.addNode(x - 1, y + 1, z, true);
            }
            if (nodeN != null && nodeE != null && ((NodeLoc)nodeE.getLoc()).canGoNorth() && ((NodeLoc)nodeN.getLoc()).canGoEast()) {
                this.addNode(x + 1, y - 1, z, true);
            }
            if (nodeN != null && nodeW != null && ((NodeLoc)nodeW.getLoc()).canGoNorth() && ((NodeLoc)nodeN.getLoc()).canGoWest()) {
                this.addNode(x - 1, y - 1, z, true);
            }
        }
    }

    private final CellNode getNode(int x, int y, int z) {
        int aX = x - this._baseX;
        if (aX < 0 || aX >= this._mapSize) {
            return null;
        }
        int aY = y - this._baseY;
        if (aY < 0 || aY >= this._mapSize) {
            return null;
        }
        CellNode result = this._buffer[aX][aY];
        if (result == null) {
            this._buffer[aX][aY] = result = new CellNode(new NodeLoc(x, y, z));
        } else if (!result.isInUse()) {
            result.setInUse();
            if (result.getLoc() != null) {
                ((NodeLoc)result.getLoc()).set(x, y, z);
            } else {
                result.setLoc(new NodeLoc(x, y, z));
            }
        }
        return result;
    }

    private final CellNode addNode(int x, int y, int z, boolean diagonal) {
        float weight;
        CellNode newNode = this.getNode(x, y, z);
        if (newNode == null) {
            return null;
        }
        if (newNode.getCost() >= 0.0f) {
            return newNode;
        }
        int geoZ = newNode.getLoc().getZ();
        int stepZ = Math.abs(geoZ - this._current.getLoc().getZ());
        float f = weight = diagonal ? Config.DIAGONAL_WEIGHT : Config.LOW_WEIGHT;
        if (!((NodeLoc)newNode.getLoc()).canGoAll() || stepZ > 16) {
            weight = Config.HIGH_WEIGHT;
        } else if (this.isHighWeight(x + 1, y, geoZ)) {
            weight = Config.MEDIUM_WEIGHT;
        } else if (this.isHighWeight(x - 1, y, geoZ)) {
            weight = Config.MEDIUM_WEIGHT;
        } else if (this.isHighWeight(x, y + 1, geoZ)) {
            weight = Config.MEDIUM_WEIGHT;
        } else if (this.isHighWeight(x, y - 1, geoZ)) {
            weight = Config.MEDIUM_WEIGHT;
        }
        newNode.setParent(this._current);
        newNode.setCost(this.getCost(x, y, geoZ, weight));
        CellNode node = this._current;
        int count = 0;
        while (node.getNext() != null && count < 14000) {
            ++count;
            if (node.getNext().getCost() > newNode.getCost()) {
                newNode.setNext(node.getNext());
                break;
            }
            node = node.getNext();
        }
        if (count == 14000) {
            System.err.println("Pathfinding: too long loop detected, cost:" + newNode.getCost());
        }
        node.setNext(newNode);
        return newNode;
    }

    private final boolean isHighWeight(int x, int y, int z) {
        CellNode result = this.getNode(x, y, z);
        if (result == null) {
            return true;
        }
        if (!((NodeLoc)result.getLoc()).canGoAll()) {
            return true;
        }
        return Math.abs(result.getLoc().getZ() - z) > 16;
    }

    private final double getCost(int x, int y, int z, float weight) {
        int dX = x - this._targetX;
        int dY = y - this._targetY;
        int dZ = z - this._targetZ;
        double result = Math.sqrt((double)(dX * dX + dY * dY) + (double)(dZ * dZ) / 256.0);
        if (result > (double)weight) {
            result += (double)weight;
        }
        if (result > 3.4028234663852886E38) {
            result = 3.4028234663852886E38;
        }
        return result;
    }
}

