/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.AutoAttackStop;
import com.l2jserver.util.ConcurrentFastMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AttackStanceTaskManager {
    protected static final Logger _log = Logger.getLogger(AttackStanceTaskManager.class.getName());
    protected static final ConcurrentFastMap<L2Character, Long> _attackStanceTasks = new ConcurrentFastMap();

    protected AttackStanceTaskManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new FightModeScheduler(), 0L, 1000L);
    }

    public void addAttackStanceTask(L2Character actor) {
        if (actor != null) {
            if (actor.isPlayable()) {
                L2PcInstance player = actor.getActingPlayer();
                for (L2CubicInstance cubic : player.getCubics().values()) {
                    if (cubic.getId() == 3) continue;
                    cubic.doAction();
                }
            }
            _attackStanceTasks.put(actor, System.currentTimeMillis());
        }
    }

    public void removeAttackStanceTask(L2Character actor) {
        if (actor != null) {
            if (actor.isSummon()) {
                actor = actor.getActingPlayer();
            }
            _attackStanceTasks.remove(actor);
        }
    }

    public boolean hasAttackStanceTask(L2Character actor) {
        if (actor != null) {
            if (actor.isSummon()) {
                actor = actor.getActingPlayer();
            }
            return _attackStanceTasks.containsKey(actor);
        }
        return false;
    }

    public static AttackStanceTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final AttackStanceTaskManager _instance = new AttackStanceTaskManager();

        private SingletonHolder() {
        }
    }

    protected class FightModeScheduler
    implements Runnable {
        protected FightModeScheduler() {
        }

        @Override
        public void run() {
            long current = System.currentTimeMillis();
            try {
                Iterator iter = _attackStanceTasks.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = (Map.Entry)iter.next();
                    if (e.getValue() == null || current - (Long)e.getValue() <= 15000L) continue;
                    L2Character actor = (L2Character)e.getKey();
                    actor.broadcastPacket(new AutoAttackStop(actor.getObjectId()));
                    actor.getAI().setAutoAttacking(false);
                    if (actor.isPlayer() && actor.hasSummon()) {
                        actor.getSummon().broadcastPacket(new AutoAttackStop(actor.getSummon().getObjectId()));
                    }
                    iter.remove();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Error in FightModeScheduler: " + e.getMessage(), e);
            }
        }
    }
}

