/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastSet;

public final class KnownListUpdateTaskManager
implements Runnable {
    protected static final Logger _log = Logger.getLogger(KnownListUpdateTaskManager.class.getName());
    private static final int FULL_UPDATE_TIMER = 100;
    private static boolean updatePass = true;
    private static int _fullUpdateTimer = 0;
    private static final FastSet<L2WorldRegion> _failedRegions = new FastSet(1);

    protected KnownListUpdateTaskManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(this, 1000L, Config.KNOWNLIST_UPDATE_INTERVAL);
    }

    @Override
    public void run() {
        try {
            L2WorldRegion[][] l2WorldRegionArray = L2World.getInstance().getWorldRegions();
            int n = l2WorldRegionArray.length;
            for (int i = 0; i < n; ++i) {
                L2WorldRegion[] regions;
                for (L2WorldRegion r : regions = l2WorldRegionArray[i]) {
                    try {
                        boolean failed = _failedRegions.contains((Object)r);
                        if (r.isActive()) {
                            this.updateRegion(r, _fullUpdateTimer == 0 || failed, updatePass);
                        }
                        if (!failed) continue;
                        _failedRegions.remove((Object)r);
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "KnownListUpdateTaskManager: updateRegion(" + _fullUpdateTimer + "," + updatePass + ") failed for region " + r.getName() + ". Full update scheduled. " + e.getMessage(), e);
                        _failedRegions.add((Object)r);
                    }
                }
            }
            updatePass = !updatePass;
            _fullUpdateTimer = (_fullUpdateTimer + 1) % 100;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
    }

    public void updateRegion(L2WorldRegion region, boolean fullUpdate, boolean forgetObjects) {
        Collection vObj = region.getVisibleObjects().values();
        for (L2Object object : vObj) {
            boolean aggro;
            if (object == null || !object.isVisible()) continue;
            boolean bl = aggro = Config.GUARD_ATTACK_AGGRO_MOB && object instanceof L2GuardInstance;
            if (forgetObjects) {
                object.getKnownList().forgetObjects(aggro || fullUpdate);
                continue;
            }
            for (L2WorldRegion regi : region.getSurroundingRegions()) {
                if (object instanceof L2Playable || aggro && regi.isActive() || fullUpdate) {
                    Collection inrObj = regi.getVisibleObjects().values();
                    for (L2Object obj : inrObj) {
                        if (obj == object) continue;
                        object.getKnownList().addKnownObject(obj);
                    }
                    continue;
                }
                if (!(object instanceof L2Character) || !regi.isActive()) continue;
                Collection inrPls = regi.getVisiblePlayable().values();
                for (L2Object obj : inrPls) {
                    if (obj == object) continue;
                    object.getKnownList().addKnownObject(obj);
                }
            }
        }
    }

    public static KnownListUpdateTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final KnownListUpdateTaskManager _instance = new KnownListUpdateTaskManager();

        private SingletonHolder() {
        }
    }
}

