/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import com.l2jserver.gameserver.taskmanager.tasks.TaskBirthday;
import com.l2jserver.gameserver.taskmanager.tasks.TaskClanLeaderApply;
import com.l2jserver.gameserver.taskmanager.tasks.TaskCleanUp;
import com.l2jserver.gameserver.taskmanager.tasks.TaskDailySkillReuseClean;
import com.l2jserver.gameserver.taskmanager.tasks.TaskGlobalVariablesSave;
import com.l2jserver.gameserver.taskmanager.tasks.TaskJython;
import com.l2jserver.gameserver.taskmanager.tasks.TaskOlympiadSave;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRaidPointsReset;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRecom;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRestart;
import com.l2jserver.gameserver.taskmanager.tasks.TaskScript;
import com.l2jserver.gameserver.taskmanager.tasks.TaskSevenSignsUpdate;
import com.l2jserver.gameserver.taskmanager.tasks.TaskShutdown;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class TaskManager {
    protected static final Logger _log = Logger.getLogger(TaskManager.class.getName());
    private final FastIntObjectMap<Task> _tasks = new FastIntObjectMap().shared();
    protected final FastList<ExecutedTask> _currentTasks = new FastList().shared();
    private static final String SQL_STATEMENT_0 = "SELECT id,task,type,last_activation,param1,param2,param3 FROM global_tasks";
    private static final String SQL_STATEMENT_1 = "UPDATE global_tasks SET last_activation=? WHERE id=?";
    private static final String SQL_STATEMENT_2 = "SELECT id FROM global_tasks WHERE task=?";
    private static final String SQL_STATEMENT_3 = "INSERT INTO global_tasks (task,type,last_activation,param1,param2,param3) VALUES(?,?,?,?,?,?)";

    protected TaskManager() {
        this.initializate();
        this.startAllTasks();
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._tasks.size() + " Tasks");
    }

    private void initializate() {
        this.registerTask(new TaskBirthday());
        this.registerTask(new TaskClanLeaderApply());
        this.registerTask(new TaskCleanUp());
        this.registerTask(new TaskDailySkillReuseClean());
        this.registerTask(new TaskGlobalVariablesSave());
        this.registerTask(new TaskJython());
        this.registerTask(new TaskOlympiadSave());
        this.registerTask(new TaskRaidPointsReset());
        this.registerTask(new TaskRecom());
        this.registerTask(new TaskRestart());
        this.registerTask(new TaskScript());
        this.registerTask(new TaskSevenSignsUpdate());
        this.registerTask(new TaskShutdown());
    }

    public void registerTask(Task task) {
        int key = task.getName().hashCode();
        this._tasks.computeIfAbsent(key, k -> {
            task.initializate();
            return task;
        });
    }

    private void startAllTasks() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(SQL_STATEMENT_0);
             ResultSet rset = statement.executeQuery();){
            while (rset.next()) {
                ExecutedTask current;
                TaskTypes type;
                Task task = (Task)this._tasks.get(rset.getString("task").trim().toLowerCase().hashCode());
                if (task == null || (type = TaskTypes.valueOf(rset.getString("type"))) == TaskTypes.TYPE_NONE || !this.launchTask(current = new ExecutedTask(task, type, rset))) continue;
                this._currentTasks.add((Object)current);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error while loading Global Task table: " + e.getMessage(), e);
        }
    }

    private boolean launchTask(ExecutedTask task) {
        ThreadPoolManager scheduler = ThreadPoolManager.getInstance();
        TaskTypes type = task.getType();
        switch (type) {
            case TYPE_STARTUP: {
                task.run();
                return false;
            }
            case TYPE_SHEDULED: {
                long delay = Long.parseLong(task.getParams()[0]);
                task.scheduled = scheduler.scheduleGeneral(task, delay);
                return true;
            }
            case TYPE_FIXED_SHEDULED: {
                long delay = Long.parseLong(task.getParams()[0]);
                long interval = Long.parseLong(task.getParams()[1]);
                task.scheduled = scheduler.scheduleGeneralAtFixedRate(task, delay, interval);
                return true;
            }
            case TYPE_TIME: {
                try {
                    Date desired = DateFormat.getInstance().parse(task.getParams()[0]);
                    long diff = desired.getTime() - System.currentTimeMillis();
                    if (diff >= 0L) {
                        task.scheduled = scheduler.scheduleGeneral(task, diff);
                        return true;
                    }
                    _log.info(this.getClass().getSimpleName() + ": Task " + task.getId() + " is obsoleted.");
                }
                catch (Exception e) {}
                break;
            }
            case TYPE_SPECIAL: {
                ScheduledFuture<?> result = task.getTask().launchSpecial(task);
                if (result == null) break;
                task.scheduled = result;
                return true;
            }
            case TYPE_GLOBAL_TASK: {
                long interval = Long.parseLong(task.getParams()[0]) * 86400000L;
                String[] hour = task.getParams()[1].split(":");
                if (hour.length != 3) {
                    _log.warning(this.getClass().getSimpleName() + ": Task " + task.getId() + " has incorrect parameters");
                    return false;
                }
                Calendar check = Calendar.getInstance();
                check.setTimeInMillis(task.getLastActivation() + interval);
                Calendar min = Calendar.getInstance();
                try {
                    min.set(11, Integer.parseInt(hour[0]));
                    min.set(12, Integer.parseInt(hour[1]));
                    min.set(13, Integer.parseInt(hour[2]));
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Bad parameter on task " + task.getId() + ": " + e.getMessage(), e);
                    return false;
                }
                long delay = min.getTimeInMillis() - System.currentTimeMillis();
                if (check.after(min) || delay < 0L) {
                    delay += interval;
                }
                task.scheduled = scheduler.scheduleGeneralAtFixedRate(task, delay, interval);
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static boolean addUniqueTask(String task, TaskTypes type, String param1, String param2, String param3) {
        return TaskManager.addUniqueTask(task, type, param1, param2, param3, 0L);
    }

    /*
     * Exception decompiling
     */
    public static boolean addUniqueTask(String task, TaskTypes type, String param1, String param2, String param3, long lastActivation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean addTask(String task, TaskTypes type, String param1, String param2, String param3) {
        return TaskManager.addTask(task, type, param1, param2, param3, 0L);
    }

    /*
     * Exception decompiling
     */
    public static boolean addTask(String task, TaskTypes type, String param1, String param2, String param3, long lastActivation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static TaskManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final TaskManager _instance = new TaskManager();

        private SingletonHolder() {
        }
    }

    public class ExecutedTask
    implements Runnable {
        int id;
        long lastActivation;
        Task task;
        TaskTypes type;
        String[] params;
        ScheduledFuture<?> scheduled;

        public ExecutedTask(Task ptask, TaskTypes ptype, ResultSet rset) throws SQLException {
            this.task = ptask;
            this.type = ptype;
            this.id = rset.getInt("id");
            this.lastActivation = rset.getLong("last_activation");
            this.params = new String[]{rset.getString("param1"), rset.getString("param2"), rset.getString("param3")};
        }

        @Override
        public void run() {
            this.task.onTimeElapsed(this);
            this.lastActivation = System.currentTimeMillis();
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(TaskManager.SQL_STATEMENT_1);){
                statement.setLong(1, this.lastActivation);
                statement.setInt(2, this.id);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Cannot updated the Global Task " + this.id + ": " + e.getMessage(), e);
            }
            if (this.type == TaskTypes.TYPE_SHEDULED || this.type == TaskTypes.TYPE_TIME) {
                this.stopTask();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ExecutedTask)) {
                return false;
            }
            return this.id == ((ExecutedTask)object).id;
        }

        public int hashCode() {
            return this.id;
        }

        public Task getTask() {
            return this.task;
        }

        public TaskTypes getType() {
            return this.type;
        }

        public int getId() {
            return this.id;
        }

        public String[] getParams() {
            return this.params;
        }

        public long getLastActivation() {
            return this.lastActivation;
        }

        public void stopTask() {
            this.task.onDestroy();
            if (this.scheduled != null) {
                this.scheduled.cancel(true);
            }
            TaskManager.this._currentTasks.remove((Object)this);
        }
    }
}

