/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javolution.util.FastMap;

public class ConcurrentFastMap<K, V>
extends FastMap<K, V> {
    public ConcurrentFastMap() {
        this.shared();
    }

    public V getOrDefault(Object key, V defaultValue) {
        Object v = this.get(key);
        return (V)(v != null ? v : defaultValue);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        for (Map.Entry entry : this.entrySet()) {
            if (entry == null) continue;
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public boolean remove(Object key, Object value) {
        FastMap.Entry entry = this.getEntry(key);
        if (entry == null || !this.getValueComparator().areEqual(entry.getValue(), value)) {
            return false;
        }
        this.remove(key);
        return true;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        FastMap.Entry entry = this.getEntry(key);
        if (entry == null || !this.getValueComparator().areEqual(entry.getValue(), oldValue)) {
            return false;
        }
        entry.setValue(newValue);
        return true;
    }

    public V replace(K key, V value) {
        FastMap.Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return (V)entry.setValue(value);
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        this.forEach((k, v) -> {
            while (!this.replace(k, v, function.apply((K)k, (V)v)) && (v = this.get(k)) != null) {
            }
        });
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object v = this.get(key);
        return (V)(v == null && (newValue = mappingFunction.apply(key)) != null && (v = this.putIfAbsent(key, newValue)) == null ? newValue : v);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        Objects.requireNonNull(remappingFunction);
        while ((oldValue = this.get(key)) != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                if (!this.replace(key, oldValue, newValue)) continue;
                return newValue;
            }
            if (!this.remove(key, oldValue)) continue;
            return null;
        }
        return (V)oldValue;
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Objects.requireNonNull(remappingFunction);
        Object oldValue = this.get(key);
        while (true) {
            if ((newValue = remappingFunction.apply(key, oldValue)) == null) {
                if (oldValue != null || this.containsKey(key)) {
                    if (this.remove(key, oldValue)) {
                        return null;
                    }
                    oldValue = this.get(key);
                    continue;
                }
                return null;
            }
            if (oldValue != null) {
                if (this.replace(key, oldValue, newValue)) {
                    return newValue;
                }
                oldValue = this.get(key);
                continue;
            }
            oldValue = this.putIfAbsent(key, newValue);
            if (oldValue == null) break;
        }
        return newValue;
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        Object oldValue = this.get(key);
        while (true) {
            if (oldValue != null) {
                V newValue = remappingFunction.apply(oldValue, value);
                if (newValue != null) {
                    if (this.replace(key, oldValue, newValue)) {
                        return newValue;
                    }
                } else if (this.remove(key, oldValue)) {
                    return null;
                }
                oldValue = this.get(key);
                continue;
            }
            oldValue = this.putIfAbsent(key, value);
            if (oldValue == null) break;
        }
        return value;
    }
}

