/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.log.filter;

import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.model.items.type.ItemType;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class ItemFilter
implements Filter {
    private static final String EXCLUDE_PROCESS = "Consume";
    private static final Set<ItemType> EXCLUDED_ITEM_TYPES = new HashSet<ItemType>();

    @Override
    public boolean isLoggable(LogRecord record) {
        if (!"item".equals(record.getLoggerName())) {
            return false;
        }
        String[] messageList = record.getMessage().split(":");
        if (messageList.length < 2 || !EXCLUDE_PROCESS.contains(messageList[1])) {
            return true;
        }
        L2ItemInstance item = (L2ItemInstance)record.getParameters()[0];
        return !EXCLUDED_ITEM_TYPES.contains(item.getItemType());
    }

    static {
        EXCLUDED_ITEM_TYPES.add((ItemType)EtcItemType.ARROW);
        EXCLUDED_ITEM_TYPES.add((ItemType)EtcItemType.SHOT);
    }
}

