/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.Server;
import com.l2jserver.UPnPService;
import com.l2jserver.loginserver.GameServerListener;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.SelectorHelper;
import com.l2jserver.loginserver.ddns.NoIpUpdater;
import com.l2jserver.loginserver.mail.MailSystem;
import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.L2LoginPacketHandler;
import com.l2jserver.status.Status;
import com.l2jserver.util.JavaTea;
import com.l2jserver.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.mmocore.network.IAcceptFilter;
import org.mmocore.network.IClientFactory;
import org.mmocore.network.IMMOExecutor;
import org.mmocore.network.IPacketHandler;
import org.mmocore.network.SelectorConfig;
import org.mmocore.network.SelectorThread;

public final class L2LoginServer {
    private final Logger _log = Logger.getLogger(L2LoginServer.class.getName());
    public static final int PROTOCOL_REV = 262;
    private static L2LoginServer _instance;
    private GameServerListener _gameServerListener;
    private SelectorThread<L2LoginClient> _selectorThread;
    private Status _statusServer;
    private Thread _restartLoginServer;

    public static void main(String[] args) {
        new L2LoginServer();
    }

    public static L2LoginServer getInstance() {
        return _instance;
    }

    public L2LoginServer() {
        _instance = this;
        Server.serverMode = 2;
        String LOG_FOLDER = "log";
        String LOG_NAME = "./log.cfg";
        File logFolder = new File(Config.DATAPACK_ROOT, "log");
        logFolder.mkdir();
        JavaTea.redirect(System.getProperty("tee"));
        try (FileInputStream is = new FileInputStream(new File("./log.cfg"));){
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (IOException e) {
            this._log.warning(this.getClass().getSimpleName() + ": " + e.getMessage());
        }
        System.out.println(Util.dateFormat());
        Config.load();
        try {
            L2DatabaseFactory.getInstance();
        }
        catch (SQLException e) {
            this._log.log(Level.SEVERE, "FATAL: Failed initializing database. Reason: " + e.getMessage(), e);
            System.exit(1);
        }
        try {
            LoginController.load();
        }
        catch (GeneralSecurityException e) {
            this._log.log(Level.SEVERE, "FATAL: Failed initializing LoginController. Reason: " + e.getMessage(), e);
            System.exit(1);
        }
        GameServerTable.getInstance();
        this.loadBanFile();
        if (Config.EMAIL_SYS_ENABLED) {
            MailSystem.getInstance();
        }
        InetAddress bindAddress = null;
        if (!Config.LOGIN_BIND_ADDRESS.equals("*")) {
            try {
                bindAddress = InetAddress.getByName(Config.LOGIN_BIND_ADDRESS);
            }
            catch (UnknownHostException e) {
                this._log.log(Level.WARNING, "WARNING: The LoginServer bind address is invalid, using all avaliable IPs. Reason: " + e.getMessage(), e);
            }
        }
        SelectorConfig sc = new SelectorConfig();
        sc.MAX_READ_PER_PASS = Config.MMO_MAX_READ_PER_PASS;
        sc.MAX_SEND_PER_PASS = Config.MMO_MAX_SEND_PER_PASS;
        sc.SLEEP_TIME = Config.MMO_SELECTOR_SLEEP_TIME;
        sc.HELPER_BUFFER_COUNT = Config.MMO_HELPER_BUFFER_COUNT;
        L2LoginPacketHandler lph = new L2LoginPacketHandler();
        SelectorHelper sh = new SelectorHelper();
        try {
            this._selectorThread = new SelectorThread(sc, (IMMOExecutor)sh, (IPacketHandler)lph, (IClientFactory)sh, (IAcceptFilter)sh);
        }
        catch (IOException e) {
            this._log.log(Level.SEVERE, "FATAL: Failed to open Selector. Reason: " + e.getMessage(), e);
            System.exit(1);
        }
        try {
            this._gameServerListener = new GameServerListener();
            this._gameServerListener.start();
            this._log.info("Listening for GameServers on " + Config.GAME_SERVER_LOGIN_HOST + ":" + Config.GAME_SERVER_LOGIN_PORT);
        }
        catch (IOException e) {
            this._log.log(Level.SEVERE, "FATAL: Failed to start the Game Server Listener. Reason: " + e.getMessage(), e);
            System.exit(1);
        }
        if (Config.IS_TELNET_ENABLED) {
            try {
                this._statusServer = new Status(Server.serverMode);
                this._statusServer.start();
            }
            catch (IOException e) {
                this._log.log(Level.WARNING, "Failed to start the Telnet Server. Reason: " + e.getMessage(), e);
            }
        } else {
            this._log.info("Telnet server is currently disabled.");
        }
        try {
            this._selectorThread.openServerSocket(bindAddress, Config.PORT_LOGIN);
            this._selectorThread.start();
            this._log.log(Level.INFO, this.getClass().getSimpleName() + ": is now listening on: " + Config.LOGIN_BIND_ADDRESS + ":" + Config.PORT_LOGIN);
        }
        catch (IOException e) {
            this._log.log(Level.SEVERE, "FATAL: Failed to open server socket. Reason: " + e.getMessage(), e);
            System.exit(1);
        }
        UPnPService.getInstance();
        switch (Config.DYNAMIC_DNS) {
            case "no-ip": {
                NoIpUpdater ddnsThread = new NoIpUpdater();
                ddnsThread.setDaemon(true);
                ddnsThread.start();
            }
        }
    }

    public Status getStatusServer() {
        return this._statusServer;
    }

    public GameServerListener getGameServerListener() {
        return this._gameServerListener;
    }

    private void loadBanFile() {
        File bannedFile = new File("./banned_ip.cfg");
        if (bannedFile.exists() && bannedFile.isFile()) {
            block48: {
                try (FileInputStream fis = new FileInputStream(bannedFile);
                     InputStreamReader is = new InputStreamReader(fis);){
                    LineNumberReader reader = new LineNumberReader(is);
                    Throwable throwable = null;
                    block33: while (true) {
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                                String[] parts = line.split("#", 2);
                                line = parts[0];
                                parts = line.split(" ");
                                String address = parts[0];
                                long duration = 0L;
                                if (parts.length > 1) {
                                    try {
                                        duration = Long.parseLong(parts[1]);
                                    }
                                    catch (NumberFormatException e) {
                                        this._log.warning("Skipped: Incorrect ban duration (" + parts[1] + ") on (" + bannedFile.getName() + "). Line: " + reader.getLineNumber());
                                        continue;
                                    }
                                }
                                try {
                                    LoginController.getInstance().addBanForAddress(address, duration);
                                    continue block33;
                                }
                                catch (UnknownHostException e) {
                                    this._log.warning("Skipped: Invalid address (" + parts[0] + ") on (" + bannedFile.getName() + "). Line: " + reader.getLineNumber());
                                }
                            }
                            break block48;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    this._log.log(Level.WARNING, "Error while reading the bans file (" + bannedFile.getName() + "). Details: " + e.getMessage(), e);
                }
            }
            this._log.info("Loaded " + LoginController.getInstance().getBannedIps().size() + " IP Bans.");
        } else {
            this._log.warning("IP Bans file (" + bannedFile.getName() + ") is missing or is a directory, skipped.");
        }
        if (Config.LOGIN_SERVER_SCHEDULE_RESTART) {
            this._log.info("Scheduled LS restart after " + Config.LOGIN_SERVER_SCHEDULE_RESTART_TIME + " hours");
            this._restartLoginServer = new LoginServerRestart();
            this._restartLoginServer.setDaemon(true);
            this._restartLoginServer.start();
        }
    }

    public void shutdown(boolean restart) {
        Runtime.getRuntime().exit(restart ? 2 : 0);
    }

    class LoginServerRestart
    extends Thread {
        public LoginServerRestart() {
            this.setName("LoginServerRestart");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(Config.LOGIN_SERVER_SCHEDULE_RESTART_TIME * 3600000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                L2LoginServer.this.shutdown(true);
            }
        }
    }
}

