/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.SessionKey;
import com.l2jserver.loginserver.model.data.AccountInfo;
import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.serverpackets.LoginFail;
import com.l2jserver.util.ConcurrentFastMap;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.crypt.ScrambledKeyPair;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javolution.util.FastList;

public class LoginController {
    protected static final Logger _log = Logger.getLogger(LoginController.class.getName());
    private static LoginController _instance;
    public static final int LOGIN_TIMEOUT = 60000;
    protected ConcurrentFastMap<String, L2LoginClient> _loginServerClients = new ConcurrentFastMap();
    protected ConcurrentFastMap<String, String> _loginServerIpAddrs = new ConcurrentFastMap();
    private final Map<InetAddress, Integer> _failedLoginAttemps = new HashMap<InetAddress, Integer>();
    private final ConcurrentFastMap<InetAddress, Long> _bannedIps = new ConcurrentFastMap();
    protected ScrambledKeyPair[] _keyPairs;
    private final Thread _purge;
    protected byte[][] _blowfishKeys;
    private static final int BLOWFISH_KEYS = 20;
    private static final String USER_INFO_SELECT = "SELECT login, password, IF(? > value OR value IS NULL, accessLevel, -1) AS accessLevel, lastServer FROM accounts LEFT JOIN (account_data) ON (account_data.account_name=accounts.login AND account_data.var=\"ban_temp\") WHERE login=?";
    private static final String AUTOCREATE_ACCOUNTS_INSERT = "INSERT INTO accounts (login, password, lastactive, accessLevel, lastIP) values (?, ?, ?, ?, ?)";
    private static final String ACCOUNT_INFO_UPDATE = "UPDATE accounts SET lastactive = ?, lastIP = ? WHERE login = ?";
    private static final String ACCOUNT_LAST_SERVER_UPDATE = "UPDATE accounts SET lastServer = ? WHERE login = ?";
    private static final String ACCOUNT_ACCESS_LEVEL_UPDATE = "UPDATE accounts SET accessLevel = ? WHERE login = ?";
    private static final String ACCOUNT_IPS_UPDATE = "UPDATE accounts SET pcIp = ?, hop1 = ?, hop2 = ?, hop3 = ?, hop4 = ? WHERE login = ?";
    private static final String ACCOUNT_IPAUTH_SELECT = "SELECT * FROM accounts_ipauth WHERE login = ?";

    private LoginController() throws GeneralSecurityException {
        _log.info("Loading LoginController...");
        this._keyPairs = new ScrambledKeyPair[10];
        KeyPairGenerator keygen = null;
        keygen = KeyPairGenerator.getInstance("RSA");
        RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(1024, RSAKeyGenParameterSpec.F4);
        keygen.initialize(spec);
        for (int i = 0; i < 10; ++i) {
            this._keyPairs[i] = new ScrambledKeyPair(keygen.generateKeyPair());
        }
        _log.info("Cached 10 KeyPairs for RSA communication");
        this.testCipher((RSAPrivateKey)this._keyPairs[0]._pair.getPrivate());
        this.generateBlowFishKeys();
        this._purge = new PurgeThread();
        this._purge.setDaemon(true);
        this._purge.start();
    }

    private void testCipher(RSAPrivateKey key) throws GeneralSecurityException {
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
        rsaCipher.init(2, key);
    }

    private void generateBlowFishKeys() {
        this._blowfishKeys = new byte[20][16];
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < this._blowfishKeys[i].length; ++j) {
                this._blowfishKeys[i][j] = (byte)(Rnd.nextInt(255) + 1);
            }
        }
        _log.info("Stored " + this._blowfishKeys.length + " keys for Blowfish communication");
    }

    public byte[] getBlowfishKey() {
        return this._blowfishKeys[(int)(Math.random() * 20.0)];
    }

    public SessionKey assignSessionKeyToClient(String account, L2LoginClient client) {
        SessionKey key = new SessionKey(Rnd.nextInt(), Rnd.nextInt(), Rnd.nextInt(), Rnd.nextInt());
        this._loginServerClients.put(account, (Object)client);
        return key;
    }

    public void removeAuthedLoginClient(String account) {
        if (account == null) {
            return;
        }
        this._loginServerClients.remove(account);
    }

    public L2LoginClient getAuthedClient(String account) {
        return (L2LoginClient)((Object)this._loginServerClients.get(account));
    }

    public AccountInfo retriveAccountInfo(InetAddress clientAddr, String login, String password) {
        return this.retriveAccountInfo(clientAddr, login, password, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordFailedLoginAttemp(InetAddress addr) {
        Integer failedLoginAttemps;
        Map<InetAddress, Integer> map = this._failedLoginAttemps;
        synchronized (map) {
            failedLoginAttemps = this._failedLoginAttemps.get(addr);
            failedLoginAttemps = failedLoginAttemps == null ? Integer.valueOf(1) : Integer.valueOf(failedLoginAttemps + 1);
            this._failedLoginAttemps.put(addr, failedLoginAttemps);
        }
        if (failedLoginAttemps >= Config.LOGIN_TRY_BEFORE_BAN) {
            this.addBanForAddress(addr, (long)(Config.LOGIN_BLOCK_AFTER_BAN * 1000));
            this.clearFailedLoginAttemps(addr);
            _log.warning("Added banned address " + addr.getHostAddress() + "! Too many login attemps.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFailedLoginAttemps(InetAddress addr) {
        Map<InetAddress, Integer> map = this._failedLoginAttemps;
        synchronized (map) {
            this._failedLoginAttemps.remove(addr);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AccountInfo retriveAccountInfo(InetAddress addr, String login, String password, boolean autoCreateIfEnabled) {
        try {
            Throwable throwable;
            PreparedStatement ps;
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] raw = password.getBytes(StandardCharsets.UTF_8);
            String hashBase64 = Base64.getEncoder().encodeToString(md.digest(raw));
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
                ps = con.prepareStatement(USER_INFO_SELECT);
                throwable = null;
                try {
                    ps.setString(1, Long.toString(System.currentTimeMillis()));
                    ps.setString(2, login);
                    try (ResultSet rset = ps.executeQuery();){
                        if (rset.next()) {
                            AccountInfo info;
                            if (Config.DEBUG) {
                                _log.fine("Account '" + login + "' exists.");
                            }
                            if (!(info = new AccountInfo(rset.getString("login"), rset.getString("password"), rset.getInt("accessLevel"), rset.getInt("lastServer"))).checkPassHash(hashBase64)) {
                                this.recordFailedLoginAttemp(addr);
                                AccountInfo accountInfo = null;
                                return accountInfo;
                            }
                            this.clearFailedLoginAttemps(addr);
                            AccountInfo accountInfo = info;
                            return accountInfo;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            if (!autoCreateIfEnabled || !Config.AUTO_CREATE_ACCOUNTS) {
                this.recordFailedLoginAttemp(addr);
                return null;
            }
            try {
                con = L2DatabaseFactory.getInstance().getConnectionFast();
                var9_11 = null;
                try {
                    ps = con.prepareStatement(AUTOCREATE_ACCOUNTS_INSERT);
                    throwable = null;
                    try {
                        ps.setString(1, login);
                        ps.setString(2, hashBase64);
                        ps.setLong(3, System.currentTimeMillis());
                        ps.setInt(4, 0);
                        ps.setString(5, addr.getHostAddress());
                        ps.execute();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (ps != null) {
                            if (throwable != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ps.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    var9_11 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (con != null) {
                        if (var9_11 != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable7) {
                                var9_11.addSuppressed(throwable7);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception while auto creating account for '" + login + "'!", e);
                return null;
            }
            _log.info("Auto created account '" + login + "'.");
            return this.retriveAccountInfo(addr, login, password, false);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception while retriving account info for '" + login + "'!", e);
            return null;
        }
    }

    public void removeLoginIpAddr(String account) {
        this._loginServerIpAddrs.remove(account);
    }

    public String getLoginIpAddr(String account) {
        return (String)this._loginServerIpAddrs.get(account);
    }

    public String[] getAlreadyLoginAccounts(String address) {
        FastList ret = new FastList();
        for (Map.Entry e : this._loginServerIpAddrs.entrySet()) {
            if (!((String)e.getValue()).equals(address)) continue;
            ret.add(e.getKey());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public boolean isIpAddrInGameServer(String account, String address) {
        if (!Config.DENY_MULTI_LOGIN_BY_IPADDR) {
            return false;
        }
        if (!this._loginServerIpAddrs.containsKey(account) && this._loginServerIpAddrs.containsValue(address)) {
            return this.getUserLevel(account) <= 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthLoginResult tryCheckinAccount(L2LoginClient client, InetAddress address, AccountInfo info, LoginFail.LoginFailReason[] loginFailReason) {
        if (info.getAccessLevel() < 0) {
            return AuthLoginResult.ACCOUNT_BANNED;
        }
        AuthLoginResult ret = AuthLoginResult.INVALID_PASSWORD;
        loginFailReason[0] = LoginFail.LoginFailReason.REASON_USER_OR_PASS_WRONG;
        String ip = client.getConnection().getInetAddress().getHostAddress();
        if (Config.DENY_BANNED_USER_BY_IPADDR && this.isIPinBanList(info.getLogin(), ip)) {
            return AuthLoginResult.ACCOUNT_BANNED;
        }
        if (this.canCheckin(client, address, info, loginFailReason)) {
            loginFailReason[0] = LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE;
            ret = AuthLoginResult.ALREADY_ON_GS;
            if (!this.isAccountInAnyGameServer(info.getLogin())) {
                ret = AuthLoginResult.ALREADY_IPADDR;
                ConcurrentFastMap<String, String> concurrentFastMap = this._loginServerIpAddrs;
                synchronized (concurrentFastMap) {
                    if (this.isIpAddrInGameServer(info.getLogin(), ip)) {
                        return ret;
                    }
                    this._loginServerIpAddrs.putIfAbsent(info.getLogin(), ip);
                }
                loginFailReason[0] = LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE;
                ret = AuthLoginResult.ALREADY_ON_LS;
                if (this._loginServerClients.putIfAbsent(info.getLogin(), (Object)client) == null) {
                    ret = AuthLoginResult.AUTH_SUCCESS;
                }
            }
        }
        return ret;
    }

    public void addBanForAddress(String address, long expiration) throws UnknownHostException {
        this._bannedIps.putIfAbsent(InetAddress.getByName(address), expiration);
    }

    public void addBanForAddress(InetAddress address, long duration) {
        this._bannedIps.putIfAbsent(address, System.currentTimeMillis() + duration);
    }

    public boolean isBannedAddress(InetAddress address) {
        String[] parts = address.getHostAddress().split("\\.");
        Long bi = (Long)this._bannedIps.get(address);
        if (bi == null) {
            bi = (Long)this._bannedIps.get(parts[0] + "." + parts[1] + "." + parts[2] + ".0");
        }
        if (bi == null) {
            bi = (Long)this._bannedIps.get(parts[0] + "." + parts[1] + ".0.0");
        }
        if (bi == null) {
            bi = (Long)this._bannedIps.get(parts[0] + ".0.0.0");
        }
        if (bi != null) {
            if (bi > 0L && bi < System.currentTimeMillis()) {
                this._bannedIps.remove(address);
                _log.info("Removed expired ip address ban " + address.getHostAddress() + ".");
                return false;
            }
            return true;
        }
        return false;
    }

    public Map<InetAddress, Long> getBannedIps() {
        return this._bannedIps;
    }

    public boolean removeBanForAddress(InetAddress address) {
        return this._bannedIps.remove(address.getHostAddress()) != null;
    }

    public boolean removeBanForAddress(String address) {
        try {
            return this.removeBanForAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public SessionKey getKeyForAccount(String account) {
        L2LoginClient client = (L2LoginClient)((Object)this._loginServerClients.get(account));
        if (client != null) {
            return client.getSessionKey();
        }
        return null;
    }

    public boolean isAccountInAnyGameServer(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            GameServerThread gst = gsi.getGameServerThread();
            if (gst == null || !gst.hasAccountOnGameServer(account)) continue;
            return true;
        }
        return false;
    }

    public GameServerTable.GameServerInfo getAccountOnGameServer(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            GameServerThread gst = gsi.getGameServerThread();
            if (gst == null || !gst.hasAccountOnGameServer(account)) continue;
            return gsi;
        }
        return null;
    }

    public void getCharactersOnAccount(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            if (!gsi.isAuthed()) continue;
            gsi.getGameServerThread().requestCharacters(account);
        }
    }

    public boolean isLoginPossible(L2LoginClient client, int serverId) {
        GameServerTable.GameServerInfo gsi = GameServerTable.getInstance().getRegisteredGameServerById(serverId);
        int access = client.getAccessLevel();
        if (gsi != null && gsi.isAuthed()) {
            boolean loginOk;
            boolean bl = loginOk = gsi.getCurrentPlayerCount() < gsi.getMaxPlayers() && gsi.getStatus() != 5 || access > 0;
            if (loginOk && client.getLastServer() != serverId) {
                try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                     PreparedStatement ps = con.prepareStatement(ACCOUNT_LAST_SERVER_UPDATE);){
                    ps.setInt(1, serverId);
                    ps.setString(2, client.getAccount());
                    ps.executeUpdate();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Could not set lastServer: " + e.getMessage(), e);
                }
            }
            return loginOk;
        }
        return false;
    }

    public void setAccountAccessLevel(String account, int banLevel) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(ACCOUNT_ACCESS_LEVEL_UPDATE);){
            ps.setInt(1, banLevel);
            ps.setString(2, account);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not set accessLevel: " + e.getMessage(), e);
        }
    }

    public void setAccountLastTracert(String account, String pcIp, String hop1, String hop2, String hop3, String hop4) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(ACCOUNT_IPS_UPDATE);){
            ps.setString(1, pcIp);
            ps.setString(2, hop1);
            ps.setString(3, hop2);
            ps.setString(4, hop3);
            ps.setString(5, hop4);
            ps.setString(6, account);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not set last tracert: " + e.getMessage(), e);
        }
    }

    public void setCharactersOnServer(String account, int charsNum, long[] timeToDel, int serverId) {
        L2LoginClient client = (L2LoginClient)((Object)this._loginServerClients.get(account));
        if (client == null) {
            return;
        }
        if (charsNum > 0) {
            client.setCharsOnServ(serverId, charsNum);
        }
        if (timeToDel.length > 0) {
            client.serCharsWaitingDelOnServ(serverId, timeToDel);
        }
    }

    public ScrambledKeyPair getScrambledRSAKeyPair() {
        return this._keyPairs[Rnd.nextInt(10)];
    }

    public boolean canCheckin(L2LoginClient client, InetAddress address, AccountInfo info, LoginFail.LoginFailReason[] loginFailReason) {
        loginFailReason[0] = LoginFail.LoginFailReason.REASON_USER_OR_PASS_WRONG;
        try {
            Throwable throwable;
            PreparedStatement ps;
            ArrayList<InetAddress> ipWhiteList = new ArrayList<InetAddress>();
            ArrayList<InetAddress> ipBlackList = new ArrayList<InetAddress>();
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
                ps = con.prepareStatement(ACCOUNT_IPAUTH_SELECT);
                throwable = null;
                try {
                    ps.setString(1, info.getLogin());
                    try (ResultSet rset = ps.executeQuery();){
                        while (rset.next()) {
                            String ip = rset.getString("ip");
                            String type = rset.getString("type");
                            if (!this.isValidIPAddress(ip)) continue;
                            if (type.equals("allow")) {
                                ipWhiteList.add(InetAddress.getByName(ip));
                                continue;
                            }
                            if (!type.equals("deny")) continue;
                            ipBlackList.add(InetAddress.getByName(ip));
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            if (!ipWhiteList.isEmpty() || !ipBlackList.isEmpty()) {
                if (!ipWhiteList.isEmpty() && !ipWhiteList.contains(address)) {
                    _log.warning("Account checkin attemp from address(" + address.getHostAddress() + ") not present on whitelist for account '" + info.getLogin() + "'.");
                    loginFailReason[0] = LoginFail.LoginFailReason.REASON_RESTRICTED_IP;
                    return false;
                }
                if (!ipBlackList.isEmpty() && ipBlackList.contains(address)) {
                    _log.warning("Account checkin attemp from address(" + address.getHostAddress() + ") on blacklist for account '" + info.getLogin() + "'.");
                    loginFailReason[0] = LoginFail.LoginFailReason.REASON_RESTRICTED_IP;
                    return false;
                }
            }
            client.setAccessLevel(info.getAccessLevel());
            client.setLastServer(info.getLastServer());
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            var8_9 = null;
            try {
                ps = con.prepareStatement(ACCOUNT_INFO_UPDATE);
                throwable = null;
                try {
                    ps.setLong(1, System.currentTimeMillis());
                    ps.setString(2, address.getHostAddress());
                    ps.setString(3, info.getLogin());
                    ps.execute();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var8_9 = throwable6;
                throw throwable6;
            }
            finally {
                if (con != null) {
                    if (var8_9 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable7) {
                            var8_9.addSuppressed(throwable7);
                        }
                    } else {
                        con.close();
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not finish login process!", e);
            return false;
        }
    }

    public boolean isValidIPAddress(String ipAddress) {
        String[] parts = ipAddress.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String s : parts) {
            int i = Integer.parseInt(s);
            if (i >= 0 && i <= 255) continue;
            return false;
        }
        return true;
    }

    public int getUserLevel(String account) {
        int ret = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT userLevel FROM accounts WHERE login=?");){
            statement.setString(1, account);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                ret = rset.getInt(1);
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "could not check userlevel state:", e);
        }
        return ret;
    }

    public boolean isIPinBanList(String user, String address) {
        boolean ok = false;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT login FROM accounts WHERE lastIP=? and accessLevel = -100");){
            statement.setString(1, address);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                ok = true;
                _log.warning("connection from IP exists in BAN List (ID:" + user + ", IP:" + address + ")");
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "could not check IP in BanList:", e);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws GeneralSecurityException {
        Class<LoginController> clazz = LoginController.class;
        synchronized (LoginController.class) {
            if (_instance != null) {
                throw new IllegalStateException("LoginController can only be loaded a single time.");
            }
            _instance = new LoginController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static LoginController getInstance() {
        return _instance;
    }

    public static enum AuthLoginResult {
        INVALID_PASSWORD,
        ACCOUNT_BANNED,
        ALREADY_IPADDR,
        ALREADY_ON_LS,
        ALREADY_ON_GS,
        AUTH_SUCCESS;

    }

    class PurgeThread
    extends Thread {
        public PurgeThread() {
            this.setName("PurgeThread");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                for (L2LoginClient client : LoginController.this._loginServerClients.values()) {
                    if (client == null || client.getConnectionStartTime() + 60000L >= System.currentTimeMillis()) continue;
                    client.close(LoginFail.LoginFailReason.REASON_ACCESS_FAILED);
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

