/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.ddns;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoIpUpdater
extends Thread {
    protected static final Logger _log = Logger.getLogger(NoIpUpdater.class.getName());
    private static final boolean DEBUG = false;
    private static final String TITLE = "NoIpUpdater";
    private static final boolean VERIFY = true;
    private String DUCUPDATE_QUERY;
    private String HOSTNAMES;
    private String USERNAME;
    private String PASSWORD;
    private long INTERVAL;
    private int PERIOD;
    private long SLEEP;
    private static final String CACHE_FILE = "log/no-ip.cache";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean load() {
        Properties p = new Properties();
        try (FileInputStream inputStream = new FileInputStream(new File("./config/DynamicDNS.properties"));){
            p.load(inputStream);
            this.HOSTNAMES = p.getProperty("noip.hostnames");
            this.USERNAME = p.getProperty("noip.username");
            this.PASSWORD = p.getProperty("noip.password");
            this.INTERVAL = Long.parseLong(p.getProperty("noip.interval", "600000"));
            this.PERIOD = Integer.parseInt(p.getProperty("noip.period", "14"));
            this.SLEEP = Long.parseLong(p.getProperty("noip.sleep", "45000"));
            if (this.HOSTNAMES == null || this.HOSTNAMES.isEmpty() || this.USERNAME == null || this.USERNAME.isEmpty() || this.PASSWORD == null || this.PASSWORD.isEmpty()) {
                _log.warning("<!>NoIpUpdater: DynamicDNS.properties does not config");
                boolean bl2 = false;
                return bl2;
            }
            this.DUCUPDATE_QUERY = "http://dynupdate.noip.com/ducupdate.php?username=" + this.USERNAME + "&pass=" + this.PASSWORD + "&h[]=" + this.HOSTNAMES;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "<!>NoIpUpdater: " + e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void run() {
        if (this.load()) {
            _log.info("no-ip updater started successfully, interval time " + this.INTERVAL + "ms");
        } else {
            return;
        }
        while (!this.isInterrupted()) {
            this.update();
            if (this.isInterrupted()) {
                return;
            }
            try {
                Thread.sleep(this.INTERVAL);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private void update() {
        ArrayList<String> aa = new ArrayList<String>();
        try {
            URL url = new URL(this.DUCUPDATE_QUERY);
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                Object object = null;
                try {
                    String temp;
                    while ((temp = in.readLine()) != null) {
                        aa.add(temp);
                    }
                }
                catch (Throwable temp) {
                    object = temp;
                    throw temp;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable temp) {
                                ((Throwable)object).addSuppressed(temp);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                _log.warning("<!>NoIpUpdater: " + e.getMessage());
                return;
            }
        }
        catch (MalformedURLException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
            this.interrupt();
            return;
        }
        boolean todo = false;
        Pattern pattern = Pattern.compile(":(\\d+)$");
        block53: for (String e : aa) {
            Matcher m = pattern.matcher(e);
            if (!m.find()) {
                _log.warning("<!>NoIpUpdater: Illegal response " + this.indentJoin(aa));
                return;
            }
            switch (m.group(1)) {
                case "0": {
                    todo = true;
                    continue block53;
                }
                case "1": {
                    continue block53;
                }
                case "2": {
                    _log.warning("<!>NoIpUpdater: Hostname error " + this.indentJoin(aa));
                    return;
                }
                case "4": {
                    _log.warning("<!>NoIpUpdater: Account error " + this.indentJoin(aa));
                    return;
                }
                case "5": {
                    _log.warning("<!>NoIpUpdater: Busy " + this.indentJoin(aa));
                    return;
                }
            }
            _log.warning("<!>NoIpUpdater: Unknown error " + this.indentJoin(aa));
            return;
        }
        pattern = null;
        aa = null;
        File cacheFile = new File(CACHE_FILE);
        if (todo) {
            URL url;
            int dd;
            if (cacheFile.exists() && (dd = (int)((System.currentTimeMillis() - cacheFile.lastModified()) / 86400000L)) <= this.PERIOD) {
                if (dd == 0) {
                    return;
                }
                return;
            }
            try {
                url = new URL(this.DUCUPDATE_QUERY + "&ip=0.0.0.0");
                try {
                    url.openStream();
                }
                catch (IOException e) {
                    _log.warning("<!>NoIpUpdater: " + e.getMessage());
                    return;
                }
            }
            catch (MalformedURLException e) {
                _log.log(Level.WARNING, e.getMessage(), e);
                this.interrupt();
                return;
            }
            try {
                Thread.sleep(this.SLEEP);
            }
            catch (InterruptedException e) {
                return;
            }
            try {
                url = new URL(this.DUCUPDATE_QUERY);
                try {
                    url.openStream();
                }
                catch (IOException e) {
                    _log.warning("<!>NoIpUpdater: " + e.getMessage());
                    return;
                }
            }
            catch (MalformedURLException e) {
                _log.log(Level.WARNING, e.getMessage(), e);
                this.interrupt();
                return;
            }
        }
        if (!cacheFile.exists()) {
            try {
                cacheFile.createNewFile();
            }
            catch (IOException e) {
                _log.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            cacheFile.setLastModified(System.currentTimeMillis());
        }
        cacheFile = null;
        String ip = null;
        try {
            URL url = new URL("http://ip1.dynupdate.no-ip.com:8245/");
            try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
                ip = in.readLine();
                if (ip != null) {
                    // empty if block
                }
            }
            catch (IOException e) {
                _log.warning("<!>NoIpUpdater: " + e.getMessage());
                return;
            }
        }
        catch (MalformedURLException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
            this.interrupt();
            return;
        }
        _log.info("NoIpUpdater: New IP " + ip);
    }

    private String indentJoin(Iterable<String> a) {
        return this.join("\n\t", a);
    }

    private String join(CharSequence separator, Iterable<String> a) {
        StringBuilder sb = new StringBuilder(256);
        for (String s : a) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

