/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.configurator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JIPTextField
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private JTextField[] _textFields;
    private List<FocusListener> _focusListeners;

    public JIPTextField(String textIp) {
        super.addFocusListener(this);
        this.initIPTextField(textIp);
        for (JTextField _textField : this._textFields) {
            _textField.addFocusListener(this);
        }
    }

    public JIPTextField() {
        this("...");
    }

    public JIPTextField(Inet4Address value) {
        this(value.getHostAddress());
    }

    private void initIPTextField(String textIp) {
        ActionListener nextfocusaction = evt -> ((Component)evt.getSource()).transferFocus();
        this.setLayout(new GridBagLayout());
        this._textFields = new JTextField[4];
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 19;
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        MaxLengthDocument previous = null;
        String[] parts = textIp.split("\\.");
        for (int i = 0; i < 4; ++i) {
            String str = parts[i];
            if (i > 0) {
                JLabel dot = new JLabel(".");
                cons.weightx = 0.0;
                this.add((Component)dot, cons);
                ++cons.gridx;
            }
            MaxLengthDocument maxDoc = new MaxLengthDocument(3);
            this._textFields[i] = new JTextField(maxDoc, str, 3);
            if (previous != null) {
                previous.setNext(this._textFields[i]);
            }
            previous = maxDoc;
            this.add((Component)this._textFields[i], cons);
            this._textFields[i].addActionListener(nextfocusaction);
            ++cons.gridx;
        }
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        if (this._focusListeners == null) {
            this._focusListeners = new LinkedList<FocusListener>();
        }
        if (fl != null && !this._focusListeners.contains(fl)) {
            this._focusListeners.add(fl);
        }
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        if (this._focusListeners != null) {
            this._focusListeners.remove(fl);
        }
    }

    public String getText() {
        StringBuilder str = new StringBuilder(256);
        for (int i = 0; i < 4; ++i) {
            if (this._textFields[i].getText().length() == 0) {
                str.append('0');
            } else {
                str.append(this._textFields[i].getText());
            }
            if (i >= 3) continue;
            str.append('.');
        }
        return str.toString();
    }

    public void setText(String str) {
        try {
            str.length();
            InetAddress ip = InetAddress.getByName(str);
            byte[] b = ip.getAddress();
            for (int i = 0; i < 4; ++i) {
                if (b[i] >= 0) {
                    this._textFields[i].setText(Byte.toString(b[i]));
                    continue;
                }
                this._textFields[i].setText(Integer.toString(b[i] + 256));
            }
            return;
        }
        catch (UnknownHostException ex) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        for (int i = 0; i < 4; ++i) {
            this._textFields[i].setText("");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (JTextField _textField : this._textFields) {
            if (_textField == null) continue;
            _textField.setEnabled(enabled);
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < 4; ++i) {
            if (this._textFields[i].getText().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isCorrect() {
        for (int i = 0; i < 4; ++i) {
            if (this._textFields[i].getText().length() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (this._focusListeners != null) {
            for (FocusListener fl : this._focusListeners) {
                fl.focusGained(event);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if ((this.isCorrect() || this.isEmpty()) && this._focusListeners != null) {
            for (FocusListener fl : this._focusListeners) {
                fl.focusLost(event);
            }
        }
    }

    public class MaxLengthDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private final int _max;
        private JTextField _next;

        public MaxLengthDocument(int maxLength) {
            this(maxLength, null);
        }

        public MaxLengthDocument(int maxLength, JTextField next) {
            this._max = maxLength;
            this.setNext(next);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (this.getLength() + str.length() > this._max) {
                if (this.getNext() != null) {
                    if (this.getNext().getText().length() > 0) {
                        this.getNext().select(0, this.getNext().getText().length());
                    } else {
                        this.getNext().getDocument().insertString(0, str, a);
                    }
                    this.getNext().requestFocusInWindow();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                super.insertString(offset, str, a);
            }
        }

        public void setNext(JTextField next) {
            this._next = next;
        }

        public JTextField getNext() {
            return this._next;
        }
    }
}

