/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.gsregistering;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.Server;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.tools.gsregistering.GUserInterface;
import com.l2jserver.tools.gsregistering.GameServerRegister;
import com.l2jserver.tools.i18n.LanguageControl;
import com.l2jserver.util.Util;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class BaseGameServerRegister {
    private boolean _loaded = false;
    private ResourceBundle _bundle;

    public static void main(String[] args) {
        Locale locale = null;
        boolean gui = true;
        boolean interactive = true;
        boolean force = false;
        boolean fallback = false;
        BaseTask task = null;
        ResourceBundle bundle = null;
        try {
            locale = Locale.getDefault();
            bundle = ResourceBundle.getBundle("gsregister.GSRegister", locale, LanguageControl.INSTANCE);
        }
        catch (Throwable t) {
            System.out.println("FATAL: Failed to load default translation.");
            System.exit(666);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-c") || arg.equals("--cmd")) {
                gui = false;
                continue;
            }
            if (arg.equals("-f") || arg.equals("--force")) {
                force = true;
                continue;
            }
            if (arg.equals("-b") || arg.equals("--fallback")) {
                fallback = true;
                continue;
            }
            if (arg.equals("-r") || arg.equals("--register")) {
                gui = false;
                interactive = false;
                int id = Integer.parseInt(args[++i]);
                String dir = args[++i];
                task = new RegisterTask(id, dir, force, fallback);
                continue;
            }
            if (arg.equals("-u") || arg.equals("--unregister")) {
                String gsId;
                gui = false;
                interactive = false;
                if ((gsId = args[++i]).equalsIgnoreCase("all")) {
                    task = new UnregisterAllTask();
                    continue;
                }
                try {
                    int id = Integer.parseInt(gsId);
                    task = new UnregisterTask(id);
                }
                catch (NumberFormatException e) {
                    if (bundle != null) {
                        System.out.printf(bundle.getString("wrongUnregisterArg") + Config.EOL, gsId);
                    }
                    System.exit(1);
                }
                continue;
            }
            if (arg.equals("-l") || arg.equals("--language")) {
                String loc = args[++i];
                Locale[] availableLocales = Locale.getAvailableLocales();
                for (int j = 0; j < availableLocales.length && locale == null; ++j) {
                    Locale l = availableLocales[j];
                    if (!l.toString().equals(loc)) continue;
                    locale = l;
                }
                if (locale == null) {
                    System.out.println("Specified locale '" + loc + "' was not found, using default behaviour.");
                    continue;
                }
                try {
                    bundle = ResourceBundle.getBundle("gsregister.GSRegister", locale, LanguageControl.INSTANCE);
                }
                catch (Throwable t) {
                    System.out.println("Failed to load translation ''");
                }
                continue;
            }
            if (!arg.equals("-h") && !arg.equals("--help")) continue;
            gui = false;
            interactive = false;
            BaseGameServerRegister.printHelp(bundle);
        }
        try {
            if (gui) {
                BaseGameServerRegister.startGUI(bundle);
            } else if (interactive) {
                BaseGameServerRegister.startCMD(bundle);
            } else if (task != null) {
                task.setBundle(bundle);
                task.run();
            }
        }
        catch (HeadlessException e) {
            BaseGameServerRegister.startCMD(bundle);
        }
    }

    private static void printHelp(ResourceBundle bundle) {
        String[] help;
        for (String str : help = new String[]{bundle.getString("purpose"), "", bundle.getString("options"), "-b, --fallback\t\t\t\t" + bundle.getString("fallbackOpt"), "-c, --cmd\t\t\t\t" + bundle.getString("cmdOpt"), "-f, --force\t\t\t\t" + bundle.getString("forceOpt"), "-h, --help\t\t\t\t" + bundle.getString("helpOpt"), "-l, --language <locale>\t\t\t\t" + bundle.getString("languageOpt"), "-r, --register <id> <hexid_dest_dir>\t" + bundle.getString("registerOpt1"), "\t\t\t\t\t" + bundle.getString("registerOpt2"), "\t\t\t\t\t" + bundle.getString("registerOpt3"), "", "-u, --unregister <id>|all\t\t" + bundle.getString("unregisterOpt"), "", bundle.getString("credits"), bundle.getString("bugReports") + " http://www.l2jserver.com"}) {
            System.out.println(str);
        }
    }

    private static void startGUI(ResourceBundle bundle) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(() -> {
            GUserInterface gui = new GUserInterface(bundle);
            gui.getFrame().setVisible(true);
        });
    }

    private static void startCMD(ResourceBundle bundle) {
        GameServerRegister cmdUi = new GameServerRegister(bundle);
        try {
            cmdUi.consoleUI();
        }
        catch (IOException e) {
            cmdUi.showError("I/O exception trying to get input from keyboard.", e);
        }
    }

    public BaseGameServerRegister(ResourceBundle bundle) {
        this.setBundle(bundle);
    }

    public void load() {
        Server.serverMode = 2;
        Config.load();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            con.createStatement().executeQuery("SELECT * FROM gameservers");
        }
        catch (Exception e) {
            this.showError("DATABASE ERROR", e);
            e.printStackTrace();
            System.exit(1);
        }
        GameServerTable.getInstance();
        this._loaded = true;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void setBundle(ResourceBundle bundle) {
        this._bundle = bundle;
    }

    public ResourceBundle getBundle() {
        return this._bundle;
    }

    public abstract void showError(String var1, Throwable var2);

    public static void unregisterGameServer(int id) throws SQLException {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM gameservers WHERE server_id = ?");){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        GameServerTable.getInstance().getRegisteredGameServers().remove(id);
    }

    public static void unregisterAllGameServers() throws SQLException {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();){
            s.executeUpdate("DELETE FROM gameservers");
        }
        GameServerTable.getInstance().getRegisteredGameServers().clear();
    }

    public static void registerGameServer(int id, String outDir) throws IOException {
        byte[] hexId = Util.generateHex(16);
        GameServerTable.getInstance().registerServerOnDB(hexId, id, "");
        Properties hexSetting = new Properties();
        File file = new File(outDir, "hexid.txt");
        file.createNewFile();
        try (FileOutputStream out = new FileOutputStream(file);){
            hexSetting.setProperty("ServerID", String.valueOf(id));
            hexSetting.setProperty("HexID", new BigInteger(hexId).toString(16));
            hexSetting.store(out, "The HexId to Auth into LoginServer");
        }
    }

    public static int registerFirstAvailable(String outDir) throws IOException {
        for (Map.Entry<Integer, String> e : GameServerTable.getInstance().getServerNames().entrySet()) {
            if (GameServerTable.getInstance().hasRegisteredGameServerOnId(e.getKey())) continue;
            BaseGameServerRegister.registerGameServer(e.getKey(), outDir);
            return e.getKey();
        }
        return -1;
    }

    protected static class UnregisterAllTask
    extends BaseTask {
        protected UnregisterAllTask() {
        }

        @Override
        public void run() {
            try {
                BaseGameServerRegister.unregisterAllGameServers();
            }
            catch (SQLException e) {
                this.showError(this.getBundle().getString("sqlErrorUnregisterAll"), e);
            }
        }
    }

    private static class UnregisterTask
    extends BaseTask {
        private final int _id;

        public UnregisterTask(int id) {
            this._id = id;
        }

        @Override
        public void run() {
            System.out.printf(this.getBundle().getString("removingGsId") + Config.EOL, this._id);
            try {
                BaseGameServerRegister.unregisterGameServer(this._id);
            }
            catch (SQLException e) {
                this.showError(this.getBundle().getString("sqlErrorRegister"), e);
            }
        }
    }

    private static class RegisterTask
    extends BaseTask {
        private final int _id;
        private final String _outDir;
        private boolean _force;
        private boolean _fallback;

        public RegisterTask(int id, String outDir, boolean force, boolean fallback) {
            this._id = id;
            this._outDir = outDir;
            this._force = force;
            this._fallback = fallback;
        }

        public void setActions(boolean force, boolean fallback) {
            this._force = force;
            this._fallback = fallback;
        }

        @Override
        public void run() {
            try {
                if (this._id < 0) {
                    int registeredId = BaseGameServerRegister.registerFirstAvailable(this._outDir);
                    if (registeredId < 0) {
                        System.out.println(this.getBundle().getString("noFreeId"));
                    } else {
                        System.out.printf(this.getBundle().getString("registrationOk") + Config.EOL, registeredId);
                    }
                } else {
                    System.out.printf(this.getBundle().getString("checkingIdInUse") + Config.EOL, this._id);
                    if (GameServerTable.getInstance().hasRegisteredGameServerOnId(this._id)) {
                        System.out.println(this.getBundle().getString("yes"));
                        if (this._force) {
                            System.out.printf(this.getBundle().getString("forcingRegistration") + Config.EOL, this._id);
                            BaseGameServerRegister.unregisterGameServer(this._id);
                            BaseGameServerRegister.registerGameServer(this._id, this._outDir);
                            System.out.printf(this.getBundle().getString("registrationOk") + Config.EOL, this._id);
                        } else if (this._fallback) {
                            System.out.println(this.getBundle().getString("fallingBack"));
                            int registeredId = BaseGameServerRegister.registerFirstAvailable(this._outDir);
                            if (registeredId < 0) {
                                System.out.println(this.getBundle().getString("noFreeId"));
                            } else {
                                System.out.printf(this.getBundle().getString("registrationOk") + Config.EOL, registeredId);
                            }
                        } else {
                            System.out.println(this.getBundle().getString("noAction"));
                        }
                    } else {
                        System.out.println(this.getBundle().getString("no"));
                        BaseGameServerRegister.registerGameServer(this._id, this._outDir);
                    }
                }
            }
            catch (SQLException e) {
                this.showError(this.getBundle().getString("sqlErrorRegister"), e);
            }
            catch (IOException e) {
                this.showError(this.getBundle().getString("ioErrorRegister"), e);
            }
        }
    }

    protected static abstract class BaseTask
    implements Runnable {
        private ResourceBundle _bundle;

        protected BaseTask() {
        }

        public void setBundle(ResourceBundle bundle) {
            this._bundle = bundle;
        }

        public ResourceBundle getBundle() {
            return this._bundle;
        }

        public void showError(String msg, Throwable t) {
            String title;
            if (this.getBundle() != null) {
                title = this.getBundle().getString("error");
                msg = msg + Config.EOL + this.getBundle().getString("reason") + ' ' + t.getLocalizedMessage();
            } else {
                title = "Error";
                msg = msg + Config.EOL + "Cause: " + t.getLocalizedMessage();
            }
            System.out.println(title + ": " + msg);
            t.printStackTrace();
        }
    }
}

