/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Broadcast {
    private static Logger _log = Logger.getLogger(Broadcast.class.getName());

    public static void toPlayersTargettingMyself(L2Character character, L2GameServerPacket mov) {
        Collection plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player.getTarget() != character) continue;
            player.sendPacket(mov);
        }
    }

    public static void toKnownPlayers(L2Character character, L2GameServerPacket mov) {
        Collection plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            try {
                player.sendPacket(mov);
                if (!(mov instanceof CharInfo) || !(character instanceof L2PcInstance)) continue;
                int relation = ((L2PcInstance)character).getRelation(player);
                Integer oldrelation = (Integer)character.getKnownList().getKnownRelations().get(player.getObjectId());
                if (oldrelation == null || oldrelation == relation) continue;
                player.sendPacket((L2GameServerPacket)new RelationChanged((L2Playable)((L2PcInstance)character), relation, character.isAutoAttackable((L2Character)player)));
                if (!character.hasSummon()) continue;
                player.sendPacket((L2GameServerPacket)new RelationChanged((L2Playable)character.getSummon(), relation, character.isAutoAttackable((L2Character)player)));
            }
            catch (NullPointerException e) {
                _log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public static void toKnownPlayersInRadius(L2Character character, L2GameServerPacket mov, int radius) {
        if (radius < 0) {
            radius = 1500;
        }
        Collection plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (!character.isInsideRadius((ILocational)player, radius, false, false)) continue;
            player.sendPacket(mov);
        }
    }

    public static void toSelfAndKnownPlayers(L2Character character, L2GameServerPacket mov) {
        if (character instanceof L2PcInstance) {
            character.sendPacket(mov);
        }
        Broadcast.toKnownPlayers(character, mov);
    }

    public static void toSelfAndKnownPlayersInRadius(L2Character character, L2GameServerPacket mov, int radius) {
        if (radius < 0) {
            radius = 600;
        }
        if (character instanceof L2PcInstance) {
            character.sendPacket(mov);
        }
        Collection plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !Util.checkIfInRange(radius, (L2Object)character, (L2Object)player, false)) continue;
            player.sendPacket(mov);
        }
    }

    public static void toAllOnlinePlayers(L2GameServerPacket packet) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            if (!player.isOnline()) continue;
            player.sendPacket(packet);
        }
    }

    public static void announceToOnlinePlayers(String text, boolean isCritical) {
        CreatureSay cs = isCritical ? new CreatureSay(0, 18, "", text) : new CreatureSay(0, 10, "", text);
        Broadcast.toAllOnlinePlayers((L2GameServerPacket)cs);
    }

    public static void announceToOnlinePlayers(String text) {
        Broadcast.toAllOnlinePlayers((L2GameServerPacket)new CreatureSay(0, 10, "", text));
    }

    public static void announceToOnlinePlayers(SystemMessage message) {
        Broadcast.toAllOnlinePlayers((L2GameServerPacket)message);
    }

    public static void toPlayersInInstance(L2GameServerPacket packet, int instanceId) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            if (!player.isOnline() || player.getInstanceId() != instanceId) continue;
            player.sendPacket(packet);
        }
    }
}

