/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.Config;
import com.l2jserver.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GMAudit {
    private static final Logger _log = Logger.getLogger(GMAudit.class.getName());

    public static void auditGMAction(String gmName, String action, String target, String params) {
        SimpleDateFormat _formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String date = _formatter.format(new Date());
        String name = Util.replaceIllegalCharacters(gmName);
        if (!Util.isValidFileName(name)) {
            name = "INVALID_GM_NAME_" + date;
        }
        File file = new File("log/GMAudit/" + name + ".txt");
        try (FileWriter save = new FileWriter(file, true);){
            save.write(date + ">" + gmName + ">" + action + ">" + target + ">" + params + Config.EOL);
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "GMAudit for GM " + gmName + " could not be saved: ", e);
        }
    }

    public static void auditGMAction(String gmName, String action, String target) {
        GMAudit.auditGMAction(gmName, action, target, "");
    }

    static {
        new File("log/GMAudit").mkdirs();
    }
}

