/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Evolve {
    protected static final Logger _log = Logger.getLogger(Evolve.class.getName());

    public static final boolean doEvolve(L2PcInstance player, L2Npc npc, int itemIdtake, int itemIdgive, int petminlvl) {
        if (itemIdtake == 0 || itemIdgive == 0 || petminlvl == 0) {
            return false;
        }
        if (!player.hasPet()) {
            return false;
        }
        L2PetInstance currentPet = (L2PetInstance)player.getSummon();
        if (currentPet.isAlikeDead()) {
            Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to use death pet exploit!", Config.DEFAULT_PUNISH);
            return false;
        }
        L2ItemInstance item = null;
        long petexp = currentPet.getStat().getExp();
        String oldname = currentPet.getName();
        int oldX = currentPet.getX();
        int oldY = currentPet.getY();
        int oldZ = currentPet.getZ();
        L2PetData oldData = PetDataTable.getInstance().getPetDataByItemId(itemIdtake);
        if (oldData == null) {
            return false;
        }
        int oldnpcID = oldData.getNpcId();
        if (currentPet.getStat().getLevel() < petminlvl || currentPet.getId() != oldnpcID) {
            return false;
        }
        L2PetData petData = PetDataTable.getInstance().getPetDataByItemId(itemIdgive);
        if (petData == null) {
            return false;
        }
        int npcID = petData.getNpcId();
        if (npcID == 0) {
            return false;
        }
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(npcID);
        currentPet.unSummon(player);
        currentPet.destroyControlItem(player, true);
        item = player.getInventory().addItem("Evolve", itemIdgive, 1L, player, (Object)npc);
        L2PetInstance petSummon = L2PetInstance.spawnPet((L2NpcTemplate)npcTemplate, (L2PcInstance)player, (L2ItemInstance)item);
        if (petSummon == null) {
            return false;
        }
        long _minimumexp = petSummon.getStat().getExpForLevel(petminlvl);
        if (petexp < _minimumexp) {
            petexp = _minimumexp;
        }
        petSummon.getStat().addExp(petexp);
        petSummon.setCurrentHp((double)petSummon.getMaxHp());
        petSummon.setCurrentMp((double)petSummon.getMaxMp());
        petSummon.setCurrentFed(petSummon.getMaxFed());
        petSummon.setTitle(player.getName());
        petSummon.setName(oldname);
        petSummon.setRunning();
        petSummon.storeMe();
        player.setPet((L2Summon)petSummon);
        player.sendPacket((L2GameServerPacket)new MagicSkillUse((L2Character)npc, 2046, 1, 1000, 600000));
        player.sendPacket(SystemMessageId.SUMMON_A_PET);
        petSummon.spawnMe(oldX, oldY, oldZ);
        petSummon.startFeed();
        item.setEnchantLevel(petSummon.getLevel());
        ThreadPoolManager.getInstance().scheduleGeneral((Runnable)new EvolveFinalizer(player, petSummon), 900L);
        if (petSummon.getCurrentFed() <= 0) {
            ThreadPoolManager.getInstance().scheduleGeneral((Runnable)new EvolveFeedWait(player, petSummon), 60000L);
        } else {
            petSummon.startFeed();
        }
        return true;
    }

    public static final boolean doRestore(L2PcInstance player, L2Npc npc, int itemIdtake, int itemIdgive, int petminlvl) {
        L2PetData oldData;
        if (itemIdtake == 0 || itemIdgive == 0 || petminlvl == 0) {
            return false;
        }
        L2ItemInstance item = player.getInventory().getItemByItemId(itemIdtake);
        if (item == null) {
            return false;
        }
        int oldpetlvl = item.getEnchantLevel();
        if (oldpetlvl < petminlvl) {
            oldpetlvl = petminlvl;
        }
        if ((oldData = PetDataTable.getInstance().getPetDataByItemId(itemIdtake)) == null) {
            return false;
        }
        L2PetData petData = PetDataTable.getInstance().getPetDataByItemId(itemIdgive);
        if (petData == null) {
            return false;
        }
        int npcId = petData.getNpcId();
        if (npcId == 0) {
            return false;
        }
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(npcId);
        L2ItemInstance removedItem = player.getInventory().destroyItem("PetRestore", item, player, (Object)npc);
        SystemMessage sm = SystemMessage.getSystemMessage((SystemMessageId)SystemMessageId.S1_DISAPPEARED);
        sm.addItemName(removedItem);
        player.sendPacket((L2GameServerPacket)sm);
        L2ItemInstance addedItem = player.getInventory().addItem("PetRestore", itemIdgive, 1L, player, (Object)npc);
        L2PetInstance petSummon = L2PetInstance.spawnPet((L2NpcTemplate)npcTemplate, (L2PcInstance)player, (L2ItemInstance)addedItem);
        if (petSummon == null) {
            return false;
        }
        long _maxexp = petSummon.getStat().getExpForLevel(oldpetlvl);
        petSummon.getStat().addExp(_maxexp);
        petSummon.setCurrentHp((double)petSummon.getMaxHp());
        petSummon.setCurrentMp((double)petSummon.getMaxMp());
        petSummon.setCurrentFed(petSummon.getMaxFed());
        petSummon.setTitle(player.getName());
        petSummon.setRunning();
        petSummon.storeMe();
        player.setPet((L2Summon)petSummon);
        player.sendPacket((L2GameServerPacket)new MagicSkillUse((L2Character)npc, 2046, 1, 1000, 600000));
        player.sendPacket(SystemMessageId.SUMMON_A_PET);
        petSummon.spawnMe(player.getX(), player.getY(), player.getZ());
        petSummon.startFeed();
        addedItem.setEnchantLevel(petSummon.getLevel());
        InventoryUpdate iu = new InventoryUpdate();
        iu.addRemovedItem(removedItem);
        player.sendPacket((L2GameServerPacket)iu);
        StatusUpdate su = new StatusUpdate((L2Object)player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket((L2GameServerPacket)su);
        player.broadcastUserInfo();
        L2World world = L2World.getInstance();
        world.removeObject((L2Object)removedItem);
        ThreadPoolManager.getInstance().scheduleGeneral((Runnable)new EvolveFinalizer(player, petSummon), 900L);
        if (petSummon.getCurrentFed() <= 0) {
            ThreadPoolManager.getInstance().scheduleGeneral((Runnable)new EvolveFeedWait(player, petSummon), 60000L);
        } else {
            petSummon.startFeed();
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");){
            ps.setInt(1, removedItem.getObjectId());
            ps.execute();
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    static final class EvolveFinalizer
    implements Runnable {
        private final L2PcInstance _activeChar;
        private final L2PetInstance _petSummon;

        EvolveFinalizer(L2PcInstance activeChar, L2PetInstance petSummon) {
            this._activeChar = activeChar;
            this._petSummon = petSummon;
        }

        @Override
        public void run() {
            try {
                this._activeChar.sendPacket((L2GameServerPacket)new MagicSkillLaunched((L2Character)this._activeChar, 2046, 1));
                this._petSummon.setFollowStatus(true);
                this._petSummon.setShowSummonAnimation(false);
            }
            catch (Throwable e) {
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    static final class EvolveFeedWait
    implements Runnable {
        private final L2PcInstance _activeChar;
        private final L2PetInstance _petSummon;

        EvolveFeedWait(L2PcInstance activeChar, L2PetInstance petSummon) {
            this._activeChar = activeChar;
            this._petSummon = petSummon;
        }

        @Override
        public void run() {
            try {
                if (this._petSummon.getCurrentFed() <= 0) {
                    this._petSummon.unSummon(this._activeChar);
                } else {
                    this._petSummon.startFeed();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
        }
    }
}

