/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.dbinstaller.util.mysql;

import com.l2jserver.tools.dbinstaller.DBOutputInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Formatter;
import java.util.GregorianCalendar;

public class DBDumper {
    DBOutputInterface _frame;
    String _host;
    String _db;

    public DBDumper(DBOutputInterface frame, String host, String db) {
        this._frame = frame;
        this._host = host;
        this._db = db;
        this.createDump();
    }

    public void createDump() {
        try {
            Throwable throwable;
            ResultSet rset2;
            Throwable throwable2;
            Statement s;
            Connection con = this._frame.getConnection();
            String serverVersion = "Unknown";
            try {
                s = con.createStatement();
                throwable2 = null;
                try {
                    rset2 = s.executeQuery("SELECT VERSION()");
                    throwable = null;
                    try {
                        if (rset2.next()) {
                            serverVersion = rset2.getString(1);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rset2 != null) {
                            if (throwable != null) {
                                try {
                                    rset2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                rset2.close();
                            }
                        }
                    }
                }
                catch (Throwable rset2) {
                    throwable2 = rset2;
                    throw rset2;
                }
                finally {
                    if (s != null) {
                        if (throwable2 != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable rset2) {
                                throwable2.addSuppressed(rset2);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            s = con.createStatement();
            throwable2 = null;
            try {
                rset2 = s.executeQuery("SHOW TABLES");
                throwable = null;
                try {
                    Formatter form = new Formatter();
                    File dump = new File("dumps", form.format("dump_%3$s_%1$s_%2$tY%2$tm%2$td-%2$tH%2$tM%2$tS.sql", this._db, new GregorianCalendar().getTime(), this._host).toString());
                    form.close();
                    new File("dumps").mkdir();
                    dump.createNewFile();
                    this._frame.appendToProgressArea("Writing dump " + dump.getName());
                    if (rset2.last()) {
                        int rows = rset2.getRow();
                        rset2.beforeFirst();
                        if (rows > 0) {
                            this._frame.setProgressIndeterminate(false);
                            this._frame.setProgressMaximum(rows);
                        }
                    }
                    try (PrintWriter fws = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dump), StandardCharsets.UTF_8));){
                        fws.println("-- L2J DBDumper 1.0");
                        fws.println("--");
                        fws.println("-- Host: " + this._host + "    Database: " + this._db);
                        fws.println("-- ------------------------------------------------------");
                        fws.println("-- Server version\t\t" + serverVersion);
                        fws.println();
                        fws.println("SET NAMES utf8;");
                        fws.println();
                        while (rset2.next()) {
                            Throwable throwable5;
                            ResultSet dset;
                            String table = rset2.getString(1);
                            this._frame.setProgressValue(rset2.getRow());
                            this._frame.appendToProgressArea("Dumping Table " + table);
                            try (Statement desc = con.createStatement();){
                                dset = desc.executeQuery("SHOW CREATE TABLE " + table);
                                throwable5 = null;
                                try {
                                    fws.println("DROP TABLE IF EXISTS `" + table + "`;");
                                    while (dset.next()) {
                                        fws.println(dset.getString(2) + ";");
                                    }
                                }
                                catch (Throwable throwable6) {
                                    throwable5 = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (dset != null) {
                                        if (throwable5 != null) {
                                            try {
                                                dset.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable5.addSuppressed(throwable7);
                                            }
                                        } else {
                                            dset.close();
                                        }
                                    }
                                }
                            }
                            desc = con.createStatement();
                            var13_30 = null;
                            try {
                                dset = desc.executeQuery("SELECT * FROM " + table);
                                throwable5 = null;
                                try {
                                    int cnt = 0;
                                    while (dset.next()) {
                                        if (cnt == 0) {
                                            fws.println("\nLOCK TABLES `" + table + "` WRITE;");
                                        }
                                        if (cnt % 100 == 0) {
                                            fws.println("INSERT INTO `" + table + "` VALUES ");
                                        } else {
                                            fws.println(",");
                                        }
                                        fws.print("(");
                                        for (int i = 1; i <= dset.getMetaData().getColumnCount(); ++i) {
                                            String value = dset.getString(i);
                                            if (i > 1) {
                                                fws.print(", ");
                                            }
                                            if (value == null) {
                                                fws.print("NULL");
                                                continue;
                                            }
                                            fws.print("'" + value.replace("'", "\\'") + "'");
                                        }
                                        fws.print(")");
                                        if (++cnt % 100 != 0) continue;
                                        fws.println(";");
                                    }
                                    if (cnt % 100 != 0) {
                                        fws.println(";");
                                    }
                                    if (cnt > 0) {
                                        fws.println("UNLOCK TABLES;");
                                    }
                                    fws.println();
                                }
                                catch (Throwable throwable8) {
                                    throwable5 = throwable8;
                                    throw throwable8;
                                }
                                finally {
                                    if (dset == null) continue;
                                    if (throwable5 != null) {
                                        try {
                                            dset.close();
                                        }
                                        catch (Throwable throwable9) {
                                            throwable5.addSuppressed(throwable9);
                                        }
                                        continue;
                                    }
                                    dset.close();
                                }
                            }
                            catch (Throwable throwable10) {
                                var13_30 = throwable10;
                                throw throwable10;
                            }
                            finally {
                                if (desc == null) continue;
                                if (var13_30 != null) {
                                    try {
                                        desc.close();
                                    }
                                    catch (Throwable throwable11) {
                                        var13_30.addSuppressed(throwable11);
                                    }
                                    continue;
                                }
                                desc.close();
                            }
                        }
                        fws.flush();
                    }
                }
                catch (Throwable throwable12) {
                    throwable = throwable12;
                    throw throwable12;
                }
                finally {
                    if (rset2 != null) {
                        if (throwable != null) {
                            try {
                                rset2.close();
                            }
                            catch (Throwable throwable13) {
                                throwable.addSuppressed(throwable13);
                            }
                        } else {
                            rset2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable14) {
                throwable2 = throwable14;
                throw throwable14;
            }
            finally {
                if (s != null) {
                    if (throwable2 != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable15) {
                            throwable2.addSuppressed(throwable15);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        this._frame.appendToProgressArea("Dump Complete!");
    }
}

