/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import com.l2jserver.Config;
import javolution.text.TextBuilder;

public final class StringUtil {
    private StringUtil() {
    }

    public static String concat(String ... strings) {
        TextBuilder sbString = TextBuilder.newInstance();
        for (String string : strings) {
            sbString.append(string);
        }
        String result = sbString.toString();
        TextBuilder.recycle((TextBuilder)sbString);
        return result;
    }

    public static StringBuilder startAppend(int sizeHint, String ... strings) {
        int length = StringUtil.getLength(strings);
        StringBuilder sbString = new StringBuilder(sizeHint > length ? sizeHint : length);
        for (String string : strings) {
            sbString.append(string);
        }
        return sbString;
    }

    public static void append(StringBuilder sbString, String ... strings) {
        sbString.ensureCapacity(sbString.length() + StringUtil.getLength(strings));
        for (String string : strings) {
            sbString.append(string);
        }
    }

    public static int getLength(Iterable<String> strings) {
        int length = 0;
        for (String string : strings) {
            length += string == null ? 4 : string.length();
        }
        return length;
    }

    public static int getLength(String[] strings) {
        int length = 0;
        for (String string : strings) {
            length += string == null ? 4 : string.length();
        }
        return length;
    }

    public static String getTraceString(StackTraceElement[] trace) {
        TextBuilder sbString = TextBuilder.newInstance();
        for (StackTraceElement element : trace) {
            sbString.append("\tat ").append(element.toString()).append(Config.EOL);
        }
        String result = sbString.toString();
        TextBuilder.recycle((TextBuilder)sbString);
        return result;
    }
}

