/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import ai.npc.AbstractNpcAI;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;

/**
 * Flee Monsters AI.
 * @author Pandragon, Nos
 */
public final class FleeMonsters extends AbstractNpcAI
{
	// NPCs
	private static final int[] MOBS =
	{
		20002, // L2Monster ETM
		20432, // L2Monster Gs[
		22228, // L2Monster OC Gs[
		25604, // L2Monster iCȂn ~[^g Gs[
	};
	// Misc
	private static final int FLEE_DISTANCE = 500;
	
	private FleeMonsters()
	{
		super(FleeMonsters.class.getSimpleName(), "ai/group_template");
		addAttackId(MOBS);
		addSpawnId(MOBS);
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon)
	{
		L2Attackable mob = (L2Attackable) npc;
		if (mob.isMovementDisabled())
		{
			return null;
		}
		if (mob.getAI().getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO && !(npc.getXdestination() == npc.getSpawn().getX() && npc.getYdestination() == npc.getSpawn().getY()))
		{
			return null;
		}
		
		npc.setRunning();
		
		final L2Playable attackerLoc = isSummon ? attacker.getSummon() : attacker;
		final double radians = Math.atan2(npc.getY() - attackerLoc.getY(), npc.getX() - attackerLoc.getX());
		int x = npc.getX() + (int) Math.round(FLEE_DISTANCE * Math.cos(radians));
		int y = npc.getY() + (int) Math.round(FLEE_DISTANCE * Math.sin(radians));
		int z = npc.getZ();
		int h = com.l2jserver.gameserver.util.Util.convertRadianToClientHeading(radians);
		
		if (Config.GEODATA > 0)
		{
			Location destiny = GeoData.getInstance().moveCheck(npc.getX(), npc.getY(), npc.getZ(), x, y, z, npc.getInstanceId());
			x = destiny.getX();
			y = destiny.getY();
			z = destiny.getZ();
		}
		npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(x, y, z, h));
		return super.onAttack(npc, attacker, damage, isSummon);
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		npc.disableCoreAI(true);
		return super.onSpawn(npc);
 	}
	
	public static void main(String[] args)
	{
		new FleeMonsters();
	}
}
