/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.util.Rnd;

/**
 * J oOxA[
 * Karul Bugbear
 */
class KarulBugbear extends Quest
{
	private static final int KARUL_BUGBEAR = 20600;
	
	private static int[] SAY1 =
	{
		1000381,	//$s1! Watch your back!		$s1IwɋC񂾂ȁI
	};
	private static int[] SAY2 =
	{
		1000382,	//Your rear is practically unguarded!	낪XL炯ȁI
		1000383,	//How dare you turn your back on me!	wƂ́IĂ̂I
	};
	
	private KarulBugbear()
	{
		super(-1, "KarulBugbear", "ai");
		addAttackId(KARUL_BUGBEAR);
		addSpellFinishedId(KARUL_BUGBEAR);
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet, Skill skill)
	{
		if (npc.getCurrentHp() == npc.getMaxHp())
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getId(), SAY1[Rnd.get(SAY1.length)]).addPcName(attacker));
//		else if (Rnd.get(20) == 0)
//			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getId(), SAY2[Rnd.get(SAY2.length)]));
		return null;
	}
	
	@Override
	public String onSpellFinished(L2Npc npc, L2PcInstance player, Skill skill)
	{
		if (Rnd.get(100) > npc.getSkillChance())
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getId(), SAY2[Rnd.get(SAY2.length)]));
		return null;
	}
	
	public static void main(String[] args)
	{
		new KarulBugbear();
	}
}
